/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.transition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.review.IAtsReviewService;
import org.eclipse.osee.ats.api.task.IAtsTaskService;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.util.AtsTopicEvent;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IExecuteListener;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinitionService;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.WidgetResult;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workdef.model.RuleDefinitionOption;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.IAtsWorkItemService;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.api.workflow.transition.TransitionData;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResult;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.task.CreateTasksRuleRunner;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class TransitionManager
implements IExecuteListener {
    private Date transitionOnDate;
    private final IAtsUserService userService;
    private final IAtsReviewService reviewService;
    private final IAtsWorkItemService workItemService;
    private final IAtsTaskService taskService;
    private final IAtsWorkDefinitionService workDefService;
    private final IAttributeResolver attrResolver;
    private final Map<IAtsWorkItem, String> workItemFromStateMap;
    private final AtsApi atsApi;
    private final TransitionData transData;
    private IAtsChangeSet changes;
    private final TransitionResults results = new TransitionResults();

    public TransitionManager(TransitionData transData) {
        this(transData, AtsApiService.get());
    }

    public TransitionManager(TransitionData transData, AtsApi atsApi) {
        this(transData, false, atsApi);
    }

    public TransitionManager(TransitionData transData, boolean overrideClientCheck, AtsApi atsApi) {
        this.transData = transData;
        this.atsApi = atsApi;
        this.userService = atsApi.getUserService();
        this.reviewService = atsApi.getReviewService();
        this.workItemService = atsApi.getWorkItemService();
        this.workDefService = atsApi.getWorkDefinitionService();
        this.attrResolver = atsApi.getAttributeResolver();
        this.taskService = atsApi.getTaskService();
        this.workItemFromStateMap = new HashMap<IAtsWorkItem, String>();
        this.results.setDebug(transData.isDebug());
        if (atsApi.isIde() && !overrideClientCheck && !AtsUtil.isInTest()) {
            try {
                throw new OseeArgumentException("TransitionManager should NOT be used on client.  Use AtsApiService.get().getWorkItemServiceClient().transition() instead.", new Object[0]);
            }
            catch (Exception ex) {
                OseeLog.log(TransitionManager.class, (Level)Level.WARNING, (String)("Exception: " + Lib.exceptionToString((Exception)ex)));
            }
        }
    }

    public TransitionResults handleAll() {
        this.loadWorkItems();
        this.handleTransitionValidation(this.results);
        if (this.results.isCancelled() || !this.results.isEmpty()) {
            return this.results;
        }
        this.handleTransition(this.results);
        this.results.getTimeRd().addTimeMapToResultData();
        return this.results;
    }

    public TransitionResults handleAllAndPersist() {
        TransitionResults results = this.handleAll();
        if (results.isEmpty()) {
            if (this.getChangeSet() != null) {
                this.logTimeStart("30 - ChangeSet.execute");
                TransactionToken transactionId = this.getChangeSet().execute();
                results.setTransaction((TransactionId)transactionId);
                this.logTimeSpent("30 - ChangeSet.execute");
            }
            if (this.atsApi.getEventService() != null) {
                this.logTimeStart("35 - ChangeSet.execute");
                this.atsApi.getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_TRANSITIONED, this.transData.getWorkItems(), results.getTransaction());
                this.logTimeSpent("35 - ChangeSet.execute");
            }
        } else if (this.atsApi.getEventService() != null) {
            this.logTimeStart("35 - ChangeSet.execute");
            this.atsApi.getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_TRANSITION_FAILED, this.transData.getWorkItems(), (TransactionId)TransactionToken.SENTINEL);
            this.logTimeSpent("35 - ChangeSet.execute");
        }
        return results;
    }

    private void loadWorkItems() {
        this.logTimeStart("01 - loadWorkItems");
        if (this.transData.getWorkItems().isEmpty()) {
            for (ArtifactToken art : this.atsApi.getQueryService().getArtifacts((Collection)org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)this.transData.getWorkItemIds()), (BranchId)this.atsApi.getAtsBranch())) {
                this.transData.getWorkItems().add(this.atsApi.getWorkItemService().getWorkItem(art));
            }
        }
        this.logTimeSpent("01 - loadWorkItems");
    }

    public TransitionResults handleTransitionValidation(TransitionResults results) {
        this.loadWorkItems();
        this.logTimeStart("05 - handleTransitionValidation");
        boolean overrideAssigneeCheck = this.isOverrideAssigneeCheck();
        try {
            if (this.transData.getWorkItems().isEmpty()) {
                results.addResult(TransitionResult.NO_WORKFLOWS_PROVIDED_FOR_TRANSITION);
                return results;
            }
            if (this.transData.getToStateName() == null) {
                results.addResult(TransitionResult.TO_STATE_CANT_BE_NULL);
                return results;
            }
            if (!overrideAssigneeCheck && this.transData.isSystemUser()) {
                results.addResult(TransitionResult.CAN_NOT_TRANSITION_AS_SYSTEM_USER);
                return results;
            }
        }
        catch (OseeCoreException ex) {
            results.addResult(new TransitionResult(String.format("Exception while validating transition [%s]", this.transData.getName()), (Exception)((Object)ex)));
        }
        for (IAtsWorkItem workItem : this.transData.getWorkItems()) {
            try {
                boolean currentlyUnAssignedOrCompletedOrCancelled;
                StateDefinition fromStateDef;
                if (this.getChangeSet() != null) {
                    this.getChangeSet().add((Object)workItem);
                }
                if ((fromStateDef = workItem.getStateDefinition()) == null) {
                    OseeLog.log(TransitionManager.class, (Level)Level.SEVERE, (String)String.format("from state for workItem %s is null", workItem.getName()));
                    continue;
                }
                this.logTimeStart("05.1 - Validate toState valid");
                StateDefinition toStateDef = workItem.getWorkDefinition().getStateByName(this.transData.getToStateName());
                if (toStateDef == null) {
                    results.addResult(workItem, new TransitionResult(String.format("Transition-To State [%s] does not exist for Work Definition [%s]", this.transData.getToStateName(), workItem.getWorkDefinition().getName())));
                    continue;
                }
                this.logTimeSpent("05.1 - Validate toState valid");
                if (fromStateDef.equals((Object)toStateDef)) continue;
                List toStatesWithReturnStates = this.workItemService.getAllToStates(workItem);
                if (!(this.transData.isOverrideTransitionValidityCheck() || toStatesWithReturnStates.contains(toStateDef) || fromStateDef.isCompletedOrCancelled())) {
                    String errStr = String.format("Work Definition [%s] is not configured to transition from \"[%s]\" to \"[%s]\"", fromStateDef.getWorkDefinition().getName(), fromStateDef.getName(), toStateDef.getName());
                    OseeLog.log(TransitionManager.class, (Level)Level.SEVERE, (String)errStr);
                    results.addResult(workItem, new TransitionResult(errStr));
                    continue;
                }
                this.logTimeStart("05.2 - Validate Editable");
                boolean isEditable = AtsApiService.get().getAtsAccessService().isWorkflowEditable(workItem);
                boolean bl = currentlyUnAssignedOrCompletedOrCancelled = workItem.isCompletedOrCancelled() || workItem.getStateMgr().getAssignees().contains(AtsCoreUsers.UNASSIGNED_USER);
                if (workItem.isTask() && workItem.getParentTeamWorkflow().getCurrentStateType().isCompletedOrCancelled()) {
                    results.addResult(workItem, TransitionResult.TASK_CANT_TRANSITION_IF_PARENT_COMPLETED);
                    continue;
                }
                if (!(workItem.isTask() || isEditable || currentlyUnAssignedOrCompletedOrCancelled || overrideAssigneeCheck)) {
                    results.addResult(workItem, TransitionResult.UNABLE_TO_ASSIGN);
                    continue;
                }
                this.logTimeSpent("05.2 - Validate Editable");
                this.logTimeStart("05.3 - Validate Working Branch");
                if (!this.isOverrideWorkingBranchCheck()) {
                    this.isWorkingBranchTransitionable(results, workItem, toStateDef);
                    if (results.isCancelled()) continue;
                }
                this.logTimeSpent("05.3 - Validate Working Branch");
                if (!overrideAssigneeCheck && !toStateDef.isCancelled() && this.transData.isSystemUserAssingee(workItem)) {
                    results.addResult(workItem, TransitionResult.CAN_NOT_TRANSITION_WITH_SYSTEM_USER_ASSIGNED);
                    continue;
                }
                this.isStateTransitionable(results, workItem, toStateDef);
                if (results.isCancelled()) continue;
                this.isTransitionValidForExtensions(results, workItem, fromStateDef, toStateDef);
                if (!results.isCancelled()) continue;
            }
            catch (OseeCoreException ex) {
                results.addResult(workItem, new TransitionResult(String.format("Exception while validating transition [%s]", this.transData.getName()), (Exception)((Object)ex)));
            }
        }
        this.logTimeSpent("05 - handleTransitionValidation");
        return results;
    }

    public void isTransitionValidForExtensions(TransitionResults results, IAtsWorkItem workItem, StateDefinition fromStateDef, StateDefinition toStateDef) {
        this.logTimeStart("05.5 - isTransitionValidForExtensions");
        for (IAtsTransitionHook listener : this.getTransitionHooks()) {
            try {
                this.logTimeStart("05.51 - transitioning 1 - " + listener.getClass().getSimpleName());
                listener.transitioning(results, workItem, (IStateToken)fromStateDef, (IStateToken)toStateDef, this.getToAssignees(workItem, toStateDef), this.transData.getTransitionUser());
                this.logTimeSpent("05.51 - transitioning 1 - " + listener.getClass().getSimpleName());
                if (results.isCancelled() || results.isEmpty()) continue;
            }
            catch (OseeCoreException ex) {
                results.addResult(workItem, new TransitionResult(String.format("Exception [%s] while validating transition extensions 1 [%s]", ex.getMessage(), this.transData.getName()), (Exception)((Object)ex)));
            }
        }
        if (results.isEmpty()) {
            for (IAtsTransitionHook listener : this.getTransitionHooks()) {
                try {
                    this.logTimeStart("05.52 - transitioning 2 - " + listener.getClass().getSimpleName());
                    listener.transitioning(results, workItem, (IStateToken)fromStateDef, (IStateToken)toStateDef, this.getToAssignees(workItem, toStateDef), AtsApiService.get().getUserService().getCurrentUser());
                    this.logTimeSpent("05.52 - transitioning 2 - " + listener.getClass().getSimpleName());
                    if (results.isCancelled() || results.isEmpty()) continue;
                }
                catch (OseeCoreException ex) {
                    results.addResult(workItem, new TransitionResult(String.format("Exception [%s] while validating transition extensions 2 [%s]", ex.getMessage(), this.transData.getName()), (Exception)((Object)ex)));
                }
            }
        }
        this.logTimeSpent("05.5 - isTransitionValidForExtensions");
    }

    public void handleTransition(TransitionResults results) {
        this.logTimeStart("20 - handleTransition");
        try {
            IAtsChangeSet changes = this.getChangeSet();
            if (changes != null) {
                changes.addExecuteListener((IExecuteListener)this);
            }
            for (IAtsWorkItem workItem : this.transData.getWorkItems()) {
                try {
                    StateDefinition fromState = workItem.getStateDefinition();
                    StateDefinition toState = workItem.getWorkDefinition().getStateByName(this.transData.getToStateName());
                    if (!fromState.equals((Object)toState)) {
                        IAtsDecisionReview review;
                        Date transitionDate = this.getTransitionOnDate();
                        AtsUser transitionUser = this.getTransitionAsUser();
                        if (fromState.isCancelled()) {
                            this.logWorkflowUnCancelledEvent(workItem, toState, changes, this.attrResolver);
                        } else if (fromState.isCompleted()) {
                            this.logWorkflowUnCompletedEvent(workItem, toState, changes, this.attrResolver);
                        }
                        if (toState.isCancelled()) {
                            this.logWorkflowCancelledEvent(workItem, fromState, toState, transitionDate, transitionUser, changes, this.attrResolver);
                        } else if (toState.isCompleted()) {
                            this.logWorkflowCompletedEvent(workItem, fromState, toState, transitionDate, transitionUser, changes);
                        } else {
                            this.updatePercentComplete(workItem, toState, changes);
                            this.logStateCompletedEvent(workItem, workItem.getCurrentStateName(), transitionDate, transitionUser);
                        }
                        TransitionManager.logStateStartedEvent(workItem, (IStateToken)toState, transitionDate, transitionUser);
                        List<? extends AtsUser> updatedAssigees = this.getToAssignees(workItem, toState);
                        workItem.getStateMgr().transitionHelper(updatedAssigees, (IStateToken)fromState, (IStateToken)toState);
                        if (this.reviewService.isValidationReviewRequired(workItem) && workItem.isTeamWorkflow() && (review = this.reviewService.createValidateReview((IAtsTeamWorkflow)workItem, false, transitionDate, transitionUser, changes)) != null && changes != null) {
                            changes.add((Object)review);
                        }
                        if (workItem.isTeamWorkflow()) {
                            CreateTasksRuleRunner taskRunner = new CreateTasksRuleRunner((IAtsTeamWorkflow)workItem, workItem.getWorkDefinition().getCreateTasksDefs(), this.atsApi);
                            XResultData result = taskRunner.run();
                            if (result.isErrors()) {
                                results.addResult(new TransitionResult(result.toString()));
                            } else {
                                result.getIds().isEmpty();
                            }
                        }
                        for (IAtsTransitionHook listener : this.getTransitionHooks()) {
                            this.logTimeStart("20.1 - hooks transitioned " + listener.getClass().getSimpleName());
                            listener.transitioned(workItem, (IStateToken)fromState, (IStateToken)toState, updatedAssigees, this.transData.getTransitionUser(), changes);
                            this.logTimeSpent("20.1 - hooks transitioned " + listener.getClass().getSimpleName());
                        }
                        for (IAtsTransitionHook listener : toState.getTransitionListeners()) {
                            this.logTimeStart("20.2 - state hook transitioned " + listener.getClass().getSimpleName());
                            listener.transitioned(workItem, (IStateToken)fromState, (IStateToken)toState, updatedAssigees, this.transData.getTransitionUser(), changes);
                            this.logTimeSpent("20.2 - state hook transitioned " + listener.getClass().getSimpleName());
                        }
                        if (toState.isCompletedOrCancelled()) {
                            this.workItemService.clearImplementersCache(workItem);
                        }
                        if (changes != null) {
                            changes.add((Object)workItem);
                        }
                        this.workItemFromStateMap.put(workItem, fromState.getName());
                    }
                }
                catch (Exception ex) {
                    results.addResult(workItem, new TransitionResult(String.format("Exception while transitioning [%s]", this.transData.getName()), ex));
                }
                results.getWorkItemIds().add(ArtifactToken.valueOf((long)workItem.getId(), (String)workItem.getName(), (BranchToken)this.atsApi.getAtsBranch()));
            }
        }
        catch (Exception ex) {
            results.addResult(new TransitionResult(String.format("Exception while transitioning [%s]", this.transData.getName()), ex));
        }
        this.logTimeSpent("20 - handleTransition");
    }

    private void isWorkingBranchTransitionable(TransitionResults results, IAtsWorkItem workItem, StateDefinition toStateDef) {
        this.logTimeStart("05.32 - isWorkingBranchTransitionable");
        if (workItem.isTeamWorkflow() && this.transData.isWorkingBranchInWork((IAtsTeamWorkflow)workItem, this.atsApi)) {
            if (toStateDef.getName().equals(TeamState.Cancelled.getName())) {
                results.addResult(workItem, TransitionResult.DELETE_WORKING_BRANCH_BEFORE_CANCEL);
            } else if (this.transData.isBranchInCommit((IAtsTeamWorkflow)workItem, this.atsApi)) {
                results.addResult(workItem, TransitionResult.WORKING_BRANCH_BEING_COMMITTED);
            } else if (!toStateDef.hasRule(RuleDefinitionOption.AllowTransitionWithWorkingBranch.name())) {
                results.addResult(workItem, TransitionResult.WORKING_BRANCH_EXISTS);
            }
        }
        this.logTimeSpent("05.32 - isWorkingBranchTransitionable");
    }

    private boolean isOverrideAttributeValidationState(IAtsWorkItem workItem, StateDefinition toStateDef) {
        this.logTimeStart("05.31 - isWorkingBranchTransitionable");
        List visitedStateNames = workItem.getStateMgr().getVisitedStateNames();
        if (visitedStateNames.contains(toStateDef.getName())) {
            StateDefinition currState = workItem.getStateDefinition();
            for (StateDefinition stateDef : toStateDef.getWorkDefinition().getStates()) {
                if (!stateDef.getName().equals(toStateDef.getName()) || toStateDef.getOrdinal() >= currState.getOrdinal()) continue;
                return true;
            }
        }
        this.logTimeSpent("05.31 - isWorkingBranchTransitionable");
        return false;
    }

    private void isStateTransitionable(TransitionResults results, IAtsWorkItem workItem, StateDefinition toStateDef) {
        boolean isOverrideAttributeValidationState;
        this.logTimeStart("05.4 - isStateTransitionable");
        boolean bl = isOverrideAttributeValidationState = this.transData.isOverrideTransitionValidityCheck() || this.isOverrideAttributeValidationState(workItem, toStateDef);
        if (toStateDef.isCancelled()) {
            this.validateTaskCompletion(workItem, toStateDef, this.taskService);
            this.validateReviewsCancelled(results, workItem, toStateDef);
        } else if (!toStateDef.isCancelled() && !isOverrideAttributeValidationState) {
            Collection widgetResults = this.workItemService.validateWidgetTransition(workItem, toStateDef);
            for (WidgetResult widgetResult : widgetResults) {
                if (widgetResult.isSuccess()) continue;
                results.addResult(workItem, (TransitionResult)widgetResult);
            }
            this.validateTaskCompletion(workItem, toStateDef, this.taskService);
            boolean teamDefRequiresTargetedVersion = this.workDefService.teamDefHasRule(workItem, RuleDefinitionOption.RequireTargetedVersion);
            boolean pageRequiresTargetedVersion = workItem.getStateDefinition().hasRule(RuleDefinitionOption.RequireTargetedVersion.name());
            if (workItem.isTeamWorkflow() && (teamDefRequiresTargetedVersion || pageRequiresTargetedVersion) && !this.atsApi.getVersionService().hasTargetedVersion(workItem) && !toStateDef.isCancelled()) {
                results.addResult(workItem, TransitionResult.MUST_BE_TARGETED_FOR_VERSION);
            }
            if (workItem.isTeamWorkflow()) {
                for (IAtsAbstractReview review : this.reviewService.getReviewsFromCurrentState((IAtsTeamWorkflow)workItem)) {
                    if (this.reviewService.getReviewBlockType(review) != ReviewBlockType.Transition || review.getCurrentStateType().isCompletedOrCancelled()) continue;
                    results.addResult(workItem, TransitionResult.COMPLETE_BLOCKING_REVIEWS);
                }
            }
        }
        this.logTimeSpent("05.4 - isStateTransitionable");
    }

    private void validateReviewsCancelled(TransitionResults results, IAtsWorkItem workItem, StateDefinition toStateDef) {
        this.logTimeStart("05.42 - validateReviewsCancelled");
        if (workItem.isTeamWorkflow() && toStateDef.isCancelled()) {
            for (IAtsAbstractReview review : this.reviewService.getReviewsFromCurrentState((IAtsTeamWorkflow)workItem)) {
                ReviewBlockType reviewBlockType = this.reviewService.getReviewBlockType(review);
                boolean completedOrCancelled = review.getCurrentStateType().isCompletedOrCancelled();
                if (reviewBlockType != ReviewBlockType.Transition || completedOrCancelled) continue;
                results.addResult(workItem, TransitionResult.CANCEL_REVIEWS_BEFORE_CANCEL);
                break;
            }
        }
        this.logTimeSpent("05.42 - validateReviewsCancelled");
    }

    private void validateTaskCompletion(IAtsWorkItem workItem, StateDefinition toStateDef, IAtsTaskService taskService) {
        this.logTimeStart("05.41 - validateTaskCompletion");
        TransitionManager.validateTaskCompletion(this.results, workItem, toStateDef, taskService);
        this.logTimeSpent("05.41 - validateTaskCompletion");
    }

    public static void validateTaskCompletion(TransitionResults results, IAtsWorkItem workItem, StateDefinition toStateDef, IAtsTaskService taskService) {
        if (!workItem.isTeamWorkflow()) {
            return;
        }
        boolean checkTasksCompletedForState = true;
        if (workItem.getStateDefinition().hasRule(RuleDefinitionOption.AllowTransitionWithoutTaskCompletion.name()) && toStateDef.getStateType().isWorking()) {
            checkTasksCompletedForState = false;
        }
        if (checkTasksCompletedForState && workItem.getCurrentStateType().isWorking()) {
            HashSet tasksToCheck = new HashSet();
            if (toStateDef.getStateType().isCompletedOrCancelled()) {
                tasksToCheck.addAll(taskService.getTask(workItem));
            } else {
                tasksToCheck.addAll(taskService.getTasks(workItem, (IStateToken)workItem.getStateDefinition()));
            }
            for (IAtsTask task : tasksToCheck) {
                if (!task.getCurrentStateType().isWorking()) continue;
                results.addResult(workItem, TransitionResult.TASKS_NOT_COMPLETED);
                break;
            }
        }
    }

    private void logWorkflowCancelledEvent(IAtsWorkItem workItem, StateDefinition fromState, StateDefinition toState, Date cancelDate, AtsUser cancelBy, IAtsChangeSet changes, IAttributeResolver attrResolver) {
        TransitionManager.logWorkflowCancelledEvent(workItem, fromState, toState, cancelDate, this.transData.getCancellationReason(), this.transData.getCancellationReasonAttrType(), this.transData.getCancellationReasonDetails(), cancelBy, changes, attrResolver);
    }

    public static void logWorkflowCancelledEvent(IAtsWorkItem workItem, StateDefinition fromState, StateDefinition toState, Date cancelDate, String cancelReason, AttributeTypeToken cancelReasonAttrType, String cancelReasonDetails, AtsUser cancelBy, IAtsChangeSet changes, IAttributeResolver attrResolver) {
        workItem.getLog().addLog(LogType.StateCancelled, fromState.getName(), cancelReason, cancelDate, cancelBy.getUserId());
        if (attrResolver.isAttributeTypeValid(workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedBy)) {
            attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledBy, (Object)cancelBy.getUserId(), changes);
            attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledDate, (Object)cancelDate, changes);
            if (Strings.isValid((String)cancelReason)) {
                Conditions.assertTrue((boolean)cancelReasonAttrType.isValid(), (String)"Cancel Attr Type must be valid", (Object[])new Object[0]);
                attrResolver.setSoleAttributeValue((IAtsObject)workItem, cancelReasonAttrType, (Object)cancelReason, changes);
            }
            if (Strings.isValid((String)cancelReasonDetails)) {
                attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledReasonDetails, (Object)cancelReasonDetails, changes);
            }
            attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledFromState, (Object)fromState.getName(), changes);
        }
        TransitionManager.validateUpdatePercentComplete(workItem, toState, changes);
    }

    private void logWorkflowUnCancelledEvent(IAtsWorkItem workItem, StateDefinition toState, IAtsChangeSet changes, IAttributeResolver attrResolver) {
        if (attrResolver.isAttributeTypeValid(workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedBy)) {
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledBy, changes);
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledDate, changes);
            changes.deleteAttributes((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledReason);
            changes.deleteAttributes((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledReasonEnum);
            changes.deleteAttributes((ArtifactId)workItem.getStoreObject(), (AttributeTypeToken)AtsAttributeTypes.CancelledReasonDetails);
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledFromState, changes);
        }
        TransitionManager.validateUpdatePercentComplete(workItem, toState, changes);
    }

    private void logWorkflowCompletedEvent(IAtsWorkItem workItem, StateDefinition fromState, StateDefinition toState, Date cancelDate, AtsUser cancelBy, IAtsChangeSet changes) {
        workItem.getLog().addLog(LogType.StateComplete, fromState.getName(), "", cancelDate, cancelBy.getUserId());
        if (this.attrResolver.isAttributeTypeValid(workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedBy)) {
            this.attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CompletedBy, (Object)cancelBy.getUserId(), changes);
            this.attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CompletedDate, (Object)cancelDate, changes);
            this.attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CompletedFromState, (Object)fromState.getName(), changes);
        }
        TransitionManager.validateUpdatePercentComplete(workItem, toState, changes);
    }

    private void logWorkflowUnCompletedEvent(IAtsWorkItem workItem, StateDefinition toState, IAtsChangeSet changes, IAttributeResolver attrResolver) {
        if (attrResolver.isAttributeTypeValid(workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedBy)) {
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeToken)AtsAttributeTypes.CompletedBy, changes);
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeToken)AtsAttributeTypes.CompletedDate, changes);
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeToken)AtsAttributeTypes.CompletedFromState, changes);
        }
        TransitionManager.validateUpdatePercentComplete(workItem, toState, changes);
    }

    private void updatePercentComplete(IAtsWorkItem workItem, StateDefinition toState, IAtsChangeSet changes) {
        Integer percent = AtsApiService.get().getWorkItemMetricsService().getPercentComplete(workItem);
        if (percent == null) {
            percent = 0;
        }
        if (toState.isWorking()) {
            Integer recPercent = toState.getRecommendedPercentComplete();
            if (recPercent != null && recPercent > 0) {
                AtsApiService.get().getWorkItemMetricsService().setPercentComplete(workItem, recPercent, changes);
            }
            changes.add((Object)workItem);
        }
    }

    private static void validateUpdatePercentComplete(IAtsWorkItem workItem, StateDefinition toState, IAtsChangeSet changes) {
        Integer percent = AtsApiService.get().getWorkItemMetricsService().getPercentComplete(workItem);
        if (percent == null) {
            percent = 0;
        }
        if (toState.isCompletedOrCancelled() && percent != 100) {
            AtsApiService.get().getWorkItemMetricsService().setPercentComplete(workItem, Integer.valueOf(100), changes);
            changes.add((Object)workItem);
        } else if (toState.isWorking() && percent == 100) {
            AtsApiService.get().getWorkItemMetricsService().setPercentComplete(workItem, Integer.valueOf(0), changes);
            changes.add((Object)workItem);
        }
    }

    private void logStateCompletedEvent(IAtsWorkItem workItem, String fromStateName, Date date, AtsUser user) {
        workItem.getLog().addLog(LogType.StateComplete, fromStateName, "", date, user.getUserId());
    }

    public static void logStateStartedEvent(IAtsWorkItem workItem, IStateToken state, Date date, AtsUser user) {
        workItem.getLog().addLog(LogType.StateEntered, state.getName(), "", date, user.getUserId());
    }

    public AtsUser getTransitionAsUser() {
        AtsUser user = this.transData.getTransitionUser();
        if (user == null) {
            user = this.userService.getCurrentUser();
        }
        return user;
    }

    public Date getTransitionOnDate() {
        if (this.transitionOnDate == null) {
            return new Date();
        }
        return this.transitionOnDate;
    }

    public void setTransitionOnDate(Date transitionOnDate) {
        this.transitionOnDate = transitionOnDate;
    }

    public List<? extends AtsUser> getToAssignees(IAtsWorkItem workItem, StateDefinition toState) {
        ArrayList<AtsUser> toAssignees = new ArrayList<AtsUser>();
        if (toState.isWorking()) {
            Collection<AtsUser> requestedAssignees = this.getToAssignees(workItem);
            if (requestedAssignees != null) {
                for (AtsUser user : requestedAssignees) {
                    toAssignees.add(user);
                }
            }
            if (toAssignees.contains(AtsCoreUsers.UNASSIGNED_USER)) {
                toAssignees.remove(AtsCoreUsers.UNASSIGNED_USER);
                toAssignees.add(this.getTransitionAsUser());
            }
            if (toAssignees.isEmpty()) {
                if (this.transData.isSystemUser()) {
                    toAssignees.add(AtsCoreUsers.UNASSIGNED_USER);
                } else {
                    toAssignees.add(this.getTransitionAsUser());
                }
            }
        }
        return toAssignees;
    }

    public void changesStored(IAtsChangeSet changes) {
        for (IAtsTransitionHook listener : this.getTransitionHooks()) {
            this.logTimeStart("25.0 - transitionPersisted " + listener.getClass().getSimpleName());
            listener.transitionPersisted(this.transData.getWorkItems(), this.workItemFromStateMap, this.transData.getToStateName(), this.transData.getTransitionUser());
            this.logTimeSpent("25.0 - transitionPersisted " + listener.getClass().getSimpleName());
        }
    }

    public Collection<IAtsTransitionHook> getTransitionHooks() {
        try {
            ArrayList<IAtsTransitionHook> hooks = new ArrayList<IAtsTransitionHook>();
            hooks.addAll(this.workItemService.getTransitionHooks());
            hooks.addAll(this.transData.getTransitionHooks());
            return hooks;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(TransitionManager.class, (Level)Level.SEVERE, (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public AtsApi getServices() {
        return this.atsApi;
    }

    public Collection<TransitionOption> getTransitionOptions() {
        return this.transData.getTransitionOptions();
    }

    public boolean isOverrideAssigneeCheck() {
        return this.getTransitionOptions().contains(TransitionOption.OverrideAssigneeCheck);
    }

    public boolean isOverrideWorkingBranchCheck() {
        return this.transData.getTransitionOptions().contains(TransitionOption.OverrideWorkingBranchCheck);
    }

    public IAtsChangeSet getChangeSet() {
        if (this.changes == null) {
            if (this.transData.getChanges() != null) {
                this.changes = this.transData.getChanges();
            } else {
                AtsUser transitionUser = this.getTransitionUser();
                this.changes = this.atsApi.createChangeSet(this.getName(), transitionUser);
            }
        }
        return this.changes;
    }

    public String getName() {
        return this.transData.getName();
    }

    public AtsUser getTransitionUser() {
        AtsUser user = this.transData.getTransitionUser();
        if (user == null) {
            user = this.atsApi.getUserService().getCurrentUser();
        }
        return user;
    }

    public void setTransitionUser(AtsUser user) {
        this.transData.setTransitionUser(user);
    }

    public Collection<AtsUser> getToAssignees(IAtsWorkItem workItem) {
        return this.transData.getToAssignees();
    }

    public void addTransitionOption(TransitionOption transitionOption) {
        this.transData.getTransitionOptions().add(transitionOption);
    }

    public void removeTransitionOption(TransitionOption transitionOption) {
        this.transData.getTransitionOptions().remove(transitionOption);
    }

    private void logTimeSpent(String key) {
        if (this.transData.isDebug()) {
            this.results.getTimeRd().logTimeSpent(key);
        }
    }

    private void logTimeStart(String key) {
        if (this.transData.isDebug()) {
            this.results.getTimeRd().logTimeStart(key);
        }
    }
}

