/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.note;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workflow.note.AtsStateNoteXml;
import org.eclipse.osee.ats.api.workflow.note.AtsStateNoteXmlType;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.exception.UserNotInDatabase;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.xml.Jaxp;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StateNotesXml {
    private final IAtsWorkItem workItem;
    public static final String LOG_ITEM_TAG = "Item";
    public static final String ATS_NOTE_TAG = "AtsNote";
    private final AtsApi atsApi;

    public StateNotesXml(IAtsWorkItem workItem, AtsApi atsApi) {
        this.workItem = workItem;
        this.atsApi = atsApi;
    }

    public void addNote(AtsStateNoteXmlType type, String state, String msg) {
        this.addNote(type, state, msg, new Date(), this.atsApi.userService().getUser());
    }

    public void addNoteItem(AtsStateNoteXml noteItem) {
        this.addNote(noteItem.getType(), noteItem.getState(), noteItem.getMsg(), noteItem.getDate(), noteItem.getUser());
    }

    public void addNote(AtsStateNoteXmlType type, String state, String msg, Date date, UserToken user) {
        AtsStateNoteXml logItem = new AtsStateNoteXml(type, state, String.valueOf(date.getTime()), user, msg);
        List<AtsStateNoteXml> logItems = this.getNoteItems();
        if (logItems.isEmpty()) {
            logItems = Arrays.asList(logItem);
        } else {
            logItems.add(logItem);
        }
        this.saveNoteItems(logItems);
    }

    public List<AtsStateNoteXml> getNoteItems() {
        try {
            String xml = this.getNoteXml();
            if (Strings.isValid((String)xml)) {
                return StateNotesXml.fromXml(xml, this.getNoteId(), this.atsApi);
            }
        }
        catch (Exception ex) {
            this.atsApi.getLogger().error((Throwable)ex, "Error extracting note", new Object[0]);
        }
        return Collections.emptyList();
    }

    public void saveNoteItems(List<AtsStateNoteXml> items) {
        try {
            String xml = StateNotesXml.toXml(items, this.atsApi);
            this.saveNoteXml(xml);
        }
        catch (Exception ex) {
            this.atsApi.getLogger().error((Throwable)ex, "Error saving note", new Object[0]);
        }
    }

    public String getTable(String state) {
        if (!this.isNoteable()) {
            return "";
        }
        ArrayList<AtsStateNoteXml> showNotes = new ArrayList<AtsStateNoteXml>();
        List<AtsStateNoteXml> noteItems = this.getNoteItems();
        for (AtsStateNoteXml li : noteItems) {
            if (state == null && li.getState().equals("")) {
                showNotes.add(li);
                continue;
            }
            if (state == null || !"ALL".equals(state) && !li.getState().equals(state)) continue;
            showNotes.add(li);
        }
        if (showNotes.isEmpty()) {
            return "";
        }
        return this.buildTable(showNotes);
    }

    private String buildTable(List<AtsStateNoteXml> showNotes) {
        StringBuilder builder = new StringBuilder();
        builder.append(AHTML.beginMultiColumnTable((int)100, (int)1));
        builder.append(AHTML.addHeaderRowMultiColumnTable(Arrays.asList("Type", "State", "Message", "User", "Date")));
        DateFormat dateFormat = this.getDateFormat();
        for (AtsStateNoteXml note : showNotes) {
            UserToken user = note.getUser();
            String name = "";
            if (user != null && !Strings.isValid((String)(name = user.getName()))) {
                name = user.getName();
            }
            builder.append(AHTML.addRowMultiColumnTable((String[])new String[]{String.valueOf(note.getType()), note.getState().isEmpty() ? "," : note.getState(), note.getMsg().equals("") ? "," : note.getMsg(), name, dateFormat.format(note.getDate())}));
        }
        builder.append(AHTML.endMultiColumnTable());
        return builder.toString();
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("MM/dd/yyyy h:mm a", Locale.US);
    }

    public static List<AtsStateNoteXml> fromXml(String xml, String atsId, AtsApi atsApi) {
        ArrayList<AtsStateNoteXml> logItems;
        block5: {
            logItems = new ArrayList<AtsStateNoteXml>();
            try {
                if (!Strings.isValid((String)xml)) break block5;
                NodeList nodes = Jaxp.readXmlDocument((String)xml).getElementsByTagName(LOG_ITEM_TAG);
                int i = 0;
                while (i < nodes.getLength()) {
                    AtsStateNoteXml item;
                    Element element = (Element)nodes.item(i);
                    try {
                        UserToken user = atsApi.userService().getUserByUserId(element.getAttribute("userId"));
                        item = new AtsStateNoteXml(element.getAttribute("type"), element.getAttribute("state"), element.getAttribute("date"), user, element.getAttribute("msg"));
                        logItems.add(item);
                    }
                    catch (UserNotInDatabase ex) {
                        atsApi.getLogger().error((Throwable)ex, "Error parsing notes for [%s]", new Object[]{atsId});
                        item = new AtsStateNoteXml(element.getAttribute("type"), element.getAttribute("state"), element.getAttribute("date"), SystemUser.OseeSystem, element.getAttribute("msg"));
                        logItems.add(item);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                atsApi.getLogger().error((Throwable)ex, "Error reading AtsNote", new Object[0]);
            }
        }
        return logItems;
    }

    public static String toXml(List<AtsStateNoteXml> items, AtsApi atsApi) {
        try {
            Document doc = Jaxp.newDocumentNamespaceAware();
            Element rootElement = doc.createElement(ATS_NOTE_TAG);
            doc.appendChild(rootElement);
            for (AtsStateNoteXml item : items) {
                Element element = doc.createElement(LOG_ITEM_TAG);
                element.setAttribute("type", item.getType().name());
                element.setAttribute("state", item.getState());
                element.setAttribute("date", String.valueOf(item.getDate().getTime()));
                element.setAttribute("userId", item.getUser().getUserId());
                element.setAttribute("msg", item.getMsg());
                rootElement.appendChild(element);
            }
            return Jaxp.getDocumentXml((Document)doc);
        }
        catch (Exception ex) {
            atsApi.getLogger().error((Throwable)ex, "Error writing AtsNote", new Object[0]);
            return null;
        }
    }

    public String getNoteXml() {
        return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.StateNotes, (Object)"");
    }

    public Result saveNoteXml(String xml) {
        try {
            this.atsApi.getAttributeResolver().setSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeId)AtsAttributeTypes.StateNotes, (Object)xml);
            return Result.TrueResult;
        }
        catch (OseeCoreException ex) {
            this.atsApi.getLogger().error((Throwable)ex, "Error saving note xml", new Object[0]);
            return new Result(false, "saveLogXml exception " + ex.getLocalizedMessage());
        }
    }

    public String getNoteTitle() {
        return "History for \"" + this.atsApi.getStoreService().getArtifactType((ArtifactId)this.workItem.getStoreObject()).getName() + "\" - " + this.getNoteId() + " - titled \"" + this.workItem.getName() + "\"";
    }

    public String getNoteId() {
        return this.workItem.getAtsId();
    }

    public boolean isNoteable() {
        return this.atsApi.getStoreService().isAttributeTypeValid((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.StateNotes);
    }
}

