/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.branch.BranchData;
import org.eclipse.osee.ats.api.commit.CommitConfigItem;
import org.eclipse.osee.ats.api.commit.CommitOverride;
import org.eclipse.osee.ats.api.commit.CommitOverrideOperations;
import org.eclipse.osee.ats.api.commit.CommitStatus;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.team.ITeamWorkflowProvider;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.IAtsVersionService;
import org.eclipse.osee.ats.api.workflow.IAtsBranchService;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.core.commit.operations.CommitOverrideOperationsImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public abstract class AbstractAtsBranchService
implements IAtsBranchService {
    protected static Map<String, BranchToken> idToWorkingBranchCache = new HashMap<String, BranchToken>();
    protected static Map<String, Long> idToWorkingBranchCacheUpdated = new HashMap<String, Long>(50);
    private final Map<ArtifactId, Boolean> workingBranchCreatingInProgress = new HashMap<ArtifactId, Boolean>();
    private final Map<ArtifactId, Boolean> workingBranchCommitInProgress = new HashMap<ArtifactId, Boolean>();
    protected AtsApi atsApi;
    private static final int SHORT_NAME_LIMIT = 35;
    private static Set<BranchId> branchesInCommit = new HashSet<BranchId>();
    private final ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy;
    private CommitOverrideOperations commitOverrideOps;

    public AbstractAtsBranchService(AtsApi atsApi, ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy) {
        this.atsApi = atsApi;
        this.teamWorkflowProvidersLazy = teamWorkflowProvidersLazy;
    }

    public boolean isWorkingBranchEverCommitted(IAtsTeamWorkflow teamWf) {
        return this.getBranchesCommittedTo(teamWf).size() > 0;
    }

    public Collection<BranchId> getBranchesToCommitTo(IAtsTeamWorkflow teamWf) {
        HashSet<BranchId> branches = new HashSet<BranchId>();
        for (CommitConfigItem obj : this.getConfigArtifactsConfiguredToCommitTo(teamWf)) {
            if (!this.isBranchValid(obj)) continue;
            branches.add(this.getBranch(obj));
        }
        return branches;
    }

    public BranchToken getWorkingBranch(IAtsTeamWorkflow teamWf, boolean force) {
        boolean notSet;
        long now = new Date().getTime();
        boolean bl = notSet = idToWorkingBranchCacheUpdated.get(teamWf.getAtsId()) == null;
        if (AtsUtil.isInTest() || notSet || force || now - idToWorkingBranchCacheUpdated.get(teamWf.getAtsId()) > 1000L) {
            BranchToken branch = BranchToken.SENTINEL;
            try {
                BranchToken workingBranch = this.getWorkingBranchExcludeStates(teamWf, new BranchState[]{BranchState.REBASELINED, BranchState.DELETED, BranchState.PURGED, BranchState.COMMIT_IN_PROGRESS, BranchState.CREATION_IN_PROGRESS, BranchState.DELETE_IN_PROGRESS, BranchState.PURGE_IN_PROGRESS});
                branch = workingBranch == null ? BranchToken.SENTINEL : workingBranch;
            }
            catch (ItemDoesNotExist itemDoesNotExist) {}
            idToWorkingBranchCache.put(teamWf.getAtsId(), branch);
            idToWorkingBranchCacheUpdated.put(teamWf.getAtsId(), now);
        }
        return idToWorkingBranchCache.get(teamWf.getAtsId());
    }

    public BranchId getConfiguredBranchForWorkflow(IAtsTeamWorkflow teamWf) {
        IAtsVersion verArt;
        BranchId parentBranch = BranchId.SENTINEL;
        if (this.atsApi.getTeamDefinitionService().isTeamUsesVersions(teamWf.getTeamDefinition()) && (verArt = this.atsApi.getVersionService().getTargetedVersion((IAtsWorkItem)teamWf)) != null) {
            parentBranch = this.getBranch((IAtsConfigObject)verArt);
        }
        if (parentBranch.isInvalid() && teamWf.isTeamWorkflow() && this.atsApi.getBranchService().isBranchValid(new CommitConfigItem(teamWf.getTeamDefinition(), this.atsApi))) {
            parentBranch = this.getBranch((IAtsConfigObject)teamWf.getTeamDefinition());
        }
        return parentBranch;
    }

    public CommitStatus getCommitStatus(IAtsTeamWorkflow teamWf, BranchId destinationBranch) {
        CommitStatus commitStatus = this.getCommitStatus(teamWf, destinationBranch, null);
        return commitStatus;
    }

    public TransactionRecord getCommitTransactionRecord(IAtsTeamWorkflow teamWf, BranchId branch) {
        if (branch.isInvalid()) {
            return TransactionRecord.SENTINEL;
        }
        Collection transactions = this.getCommittedArtifactTransactionIds(teamWf);
        for (TransactionRecord transId : transactions) {
            if (!transId.isOnBranch(branch)) continue;
            return transId;
        }
        return TransactionRecord.SENTINEL;
    }

    public CommitConfigItem getParentBranchConfigArtifactConfiguredToCommitTo(IAtsTeamWorkflow teamWf) {
        if (this.atsApi.getTeamDefinitionService().isTeamUsesVersions(teamWf.getTeamDefinition())) {
            if (this.atsApi.getVersionService().hasTargetedVersion((IAtsWorkItem)teamWf)) {
                return new CommitConfigItem(this.atsApi.getVersionService().getTargetedVersion((IAtsWorkItem)teamWf), this.atsApi);
            }
        } else {
            CommitConfigItem item = new CommitConfigItem(teamWf.getTeamDefinition(), this.atsApi);
            if (teamWf.isTeamWorkflow() && this.atsApi.getBranchService().isBranchValid(item)) {
                return item;
            }
        }
        return null;
    }

    public TransactionToken getEarliestTransactionId(IAtsTeamWorkflow teamWf) {
        TransactionToken earliestTransactionId;
        Collection<TransactionRecord> transactionIds = this.getTransactionIds(teamWf, false);
        if (transactionIds.isEmpty()) {
            earliestTransactionId = TransactionToken.SENTINEL;
        } else {
            earliestTransactionId = (TransactionToken)transactionIds.iterator().next();
            for (TransactionToken transactionToken : transactionIds) {
                if (!transactionToken.isOlderThan((TransactionId)earliestTransactionId)) continue;
                earliestTransactionId = transactionToken;
            }
        }
        return earliestTransactionId;
    }

    public boolean isBranchesAllCommittedExcept(IAtsTeamWorkflow teamWf, BranchId branchToExclude) {
        Collection<BranchToken> committedTo = this.getBranchesCommittedTo(teamWf);
        for (BranchId destBranch : this.getBranchesToCommitTo(teamWf)) {
            if (!destBranch.notEqual((Id)branchToExclude) || committedTo.contains(destBranch) || this.isNoCommitNeeded(teamWf, destBranch) || this.isCommitOverridden(teamWf, destBranch)) continue;
            return false;
        }
        return true;
    }

    public Collection<BranchToken> getBranchesCommittedTo(IAtsTeamWorkflow teamWf) {
        HashSet<BranchToken> branches = new HashSet<BranchToken>();
        for (TransactionToken transactionToken : this.getTransactionIds(teamWf, false)) {
            BranchToken branch = this.atsApi.getBranchService().getBranch(transactionToken.getBranch());
            branches.add(branch);
        }
        return branches;
    }

    public Collection<BranchId> getBranchesLeftToCommit(IAtsTeamWorkflow teamWf) {
        HashSet<BranchId> branchesLeft = new HashSet<BranchId>();
        Collection<BranchToken> committedTo = this.getBranchesCommittedTo(teamWf);
        for (BranchId branchToCommit : this.getBranchesToCommitTo(teamWf)) {
            if (committedTo.contains(branchToCommit) || this.isNoCommitNeeded(teamWf, branchToCommit) || this.isCommitOverridden(teamWf, branchToCommit)) continue;
            branchesLeft.add(branchToCommit);
        }
        return branchesLeft;
    }

    public CommitStatus getCommitStatus(IAtsTeamWorkflow teamWf, CommitConfigItem configItem) {
        return this.getCommitStatus((IAtsTeamWorkflow)teamWf.getStoreObject(), this.getBranch(configItem), null);
    }

    public boolean isBranchInCommit(IAtsTeamWorkflow teamWf) {
        if (!this.isWorkingBranchInWork(teamWf)) {
            return false;
        }
        return branchesInCommit.contains(this.getWorkingBranch(teamWf));
    }

    public Collection<CommitConfigItem> getConfigArtifactsConfiguredToCommitTo(IAtsTeamWorkflow teamWf) {
        HashSet<CommitConfigItem> configItems = new HashSet<CommitConfigItem>();
        if (this.atsApi.getTeamDefinitionService().isTeamUsesVersions(teamWf.getTeamDefinition())) {
            if (this.atsApi.getVersionService().hasTargetedVersion((IAtsWorkItem)teamWf)) {
                this.atsApi.getVersionService().getParallelVersions(this.atsApi.getVersionService().getTargetedVersion((IAtsWorkItem)teamWf), configItems);
            }
        } else {
            CommitConfigItem item = new CommitConfigItem(teamWf.getTeamDefinition(), this.atsApi);
            if (teamWf.isTeamWorkflow() && this.atsApi.getBranchService().isBranchValid(item)) {
                configItems.add(item);
            }
        }
        return configItems;
    }

    public Collection<TransactionRecord> getCommitTransactionsToUnarchivedBaselineBranchs(IAtsTeamWorkflow teamWf) {
        ArrayList<TransactionRecord> transactionIds = new ArrayList<TransactionRecord>();
        for (TransactionRecord transactionId : this.getCommittedArtifactTransactionIds(teamWf)) {
            BranchId branch = transactionId.getBranch();
            if (!this.getBranchType(branch).isBaselineBranch() || this.isArchived(branch)) continue;
            transactionIds.add(transactionId);
        }
        return transactionIds;
    }

    public boolean isNoCommitNeeded(IAtsTeamWorkflow teamWf, BranchId destinationBranch) {
        return this.getCommitStatus(teamWf, destinationBranch) == CommitStatus.No_Commit_Needed;
    }

    public boolean isCommitOverridden(IAtsTeamWorkflow teamWf, BranchId destinationBranch) {
        return this.getCommitStatus(teamWf, destinationBranch) == CommitStatus.Commit_Overridden;
    }

    public boolean isBranchesAllCommitted(IAtsTeamWorkflow teamWf) {
        Collection<BranchToken> committedTo = this.getBranchesCommittedTo(teamWf);
        for (BranchId destBranch : this.getBranchesToCommitTo(teamWf)) {
            if (committedTo.contains(destBranch) || this.isNoCommitNeeded(teamWf, destBranch) || this.isCommitOverridden(teamWf, destBranch)) continue;
            return false;
        }
        return true;
    }

    public BranchToken getWorkingBranch(IAtsTeamWorkflow teamWf) {
        return this.getWorkingBranch(teamWf, false);
    }

    public boolean isCommittedBranchExists(IAtsTeamWorkflow teamWf) {
        return !this.getBranchesCommittedTo(teamWf).isEmpty();
    }

    public boolean isAllObjectsToCommitToConfigured(IAtsTeamWorkflow teamWf) {
        Collection<CommitConfigItem> configItems = this.getConfigArtifactsConfiguredToCommitTo(teamWf);
        for (CommitConfigItem config : configItems) {
            if (!this.isBranchValid(config)) {
                return false;
            }
            if (this.branchExists(config.getBaselineBranchId())) continue;
            return false;
        }
        return true;
    }

    public String getBranchShortName(CommitConfigItem commitConfigItem) {
        return Strings.truncate((String)commitConfigItem.getName(), (int)35);
    }

    public boolean isWorkingBranchInWork(IAtsTeamWorkflow teamWf) {
        BranchToken branch = this.getWorkingBranch(teamWf);
        return branch.isValid() && !this.getBranchState((BranchId)branch).isCommitted();
    }

    public BranchId getBranch(IAtsConfigObject configObject) {
        IAtsVersion version;
        BranchId branch = BranchId.SENTINEL;
        if (configObject instanceof IAtsVersion && (version = (IAtsVersion)configObject).getBaselineBranch().isValid()) {
            branch = version.getBaselineBranch();
        }
        if (branch.isInvalid() && configObject instanceof IAtsTeamDefinition) {
            IAtsTeamDefinition teamDef = (IAtsTeamDefinition)configObject;
            if (this.atsApi.getTeamDefinitionService().getBaselineBranchId(teamDef).isValid()) {
                branch = this.atsApi.getTeamDefinitionService().getBaselineBranchId(teamDef);
            }
        }
        if (branch.isInvalid()) {
            branch = BranchId.valueOf((String)((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)configObject, (AttributeTypeToken)AtsAttributeTypes.BaselineBranchId, (Object)Id.SENTINEL.toString())));
        }
        return branch;
    }

    public BranchToken getBranch(IAtsTeamWorkflow teamWf) {
        return this.getWorkingBranch(teamWf, false);
    }

    public BranchId getBranch(CommitConfigItem configItem) {
        return this.getBranch(configItem.getConfigObject());
    }

    public boolean isBranchValid(CommitConfigItem configItem) {
        boolean validBranch = false;
        if (configItem.getBaselineBranchId().isValid()) {
            validBranch = true;
        }
        return validBranch;
    }

    public Collection<Object> combineCommitTransactionsAndConfigItems(Collection<CommitConfigItem> configItems, Collection<TransactionRecord> commitTxs) {
        HashSet<Object> commitMgrInputObjs = new HashSet<Object>();
        commitMgrInputObjs.addAll(configItems);
        for (TransactionToken transactionToken : commitTxs) {
            boolean isCommitAlreadyPresent = false;
            for (CommitConfigItem configItem : configItems) {
                BranchId configItemBranch = this.getBranch(configItem);
                if (!transactionToken.isOnBranch(configItemBranch)) continue;
                isCommitAlreadyPresent = true;
                break;
            }
            if (isCommitAlreadyPresent) continue;
            commitMgrInputObjs.add(transactionToken);
        }
        return commitMgrInputObjs;
    }

    public Collection<Object> getCommitTransactionsAndConfigItemsForTeamWf(IAtsTeamWorkflow teamWf) {
        Collection<CommitConfigItem> configItems = this.getConfigArtifactsConfiguredToCommitTo(teamWf);
        Collection<TransactionRecord> commitTxs = this.getCommitTransactionsToUnarchivedBaselineBranchs(teamWf);
        Collection<Object> commitMgrInputObjs = this.combineCommitTransactionsAndConfigItems(configItems, commitTxs);
        return commitMgrInputObjs;
    }

    public Result isCommitBranchAllowed(IAtsTeamWorkflow teamWf) {
        if (!teamWf.isTeamWorkflow()) {
            return Result.FalseResult;
        }
        if (this.atsApi.getVersionService().isTeamUsesVersions(teamWf.getTeamDefinition())) {
            IAtsVersionService versionService = this.atsApi.getVersionService();
            if (!versionService.hasTargetedVersion((IAtsWorkItem)teamWf)) {
                return new Result(false, "Workflow not targeted for Version");
            }
            IAtsVersion targetedVersion = versionService.getTargetedVersion((IAtsWorkItem)teamWf);
            Result result = targetedVersion.getAtsApi().getVersionService().isAllowCommitBranchInherited(targetedVersion);
            if (result.isFalse()) {
                return result;
            }
            if (targetedVersion.isBranchInvalid()) {
                return new Result(false, "Parent Branch not configured for Version [" + targetedVersion + "]");
            }
            return Result.TrueResult;
        }
        Result result = this.atsApi.getTeamDefinitionService().isAllowCommitBranchInherited(teamWf.getTeamDefinition());
        if (result.isFalse()) {
            return result;
        }
        if (!this.atsApi.getBranchService().isBranchValid(new CommitConfigItem(teamWf.getTeamDefinition(), this.atsApi))) {
            return new Result(false, "Parent Branch not configured for Team Definition [" + teamWf.getTeamDefinition() + "]");
        }
        return Result.TrueResult;
    }

    public Result isCreateBranchAllowed(IAtsTeamWorkflow teamWf) {
        if (!teamWf.isTeamWorkflow()) {
            return Result.FalseResult;
        }
        if (this.atsApi.getTeamDefinitionService().isTeamUsesVersions(teamWf.getTeamDefinition())) {
            IAtsVersionService versionService = this.atsApi.getVersionService();
            if (!versionService.hasTargetedVersion((IAtsWorkItem)teamWf)) {
                return new Result(false, "Workflow not targeted for Version");
            }
            IAtsVersion targetedVersion = versionService.getTargetedVersion((IAtsWorkItem)teamWf);
            Result result = targetedVersion.getAtsApi().getVersionService().isAllowCreateBranchInherited(targetedVersion);
            if (result.isFalse()) {
                return result;
            }
            if (!targetedVersion.isBranchValid()) {
                return new Result(false, "Parent Branch not configured for Version [" + targetedVersion + "]");
            }
            BranchId baselineBranch = this.getBranch((IAtsConfigObject)targetedVersion);
            if (!this.getBranchType(baselineBranch).isBaselineBranch()) {
                return new Result(false, "Parent Branch must be of Baseline branch type.  See Admin for configuration.");
            }
            return Result.TrueResult;
        }
        Result result = this.atsApi.getTeamDefinitionService().isAllowCreateBranchInherited(teamWf.getTeamDefinition());
        if (result.isFalse()) {
            return result;
        }
        if (!this.atsApi.getBranchService().isBranchValid(new CommitConfigItem(teamWf.getTeamDefinition(), this.atsApi))) {
            return new Result(false, "Parent Branch not configured for Team Definition [" + teamWf.getTeamDefinition() + "]");
        }
        BranchId baselineBranch = this.getBranch((IAtsConfigObject)teamWf.getTeamDefinition());
        if (!this.getBranchType(baselineBranch).isBaselineBranch()) {
            return new Result(false, "Parent Branch must be of Baseline branch type.  See Admin for configuration.");
        }
        return Result.TrueResult;
    }

    public CommitStatus getCommitStatus(IAtsTeamWorkflow teamWf, BranchId destinationBranch, CommitConfigItem configItem) {
        BranchToken workingBranch = this.getWorkingBranch(teamWf);
        if (workingBranch.isValid() && this.getBranchState((BranchId)workingBranch).isRebaselineInProgress()) {
            return CommitStatus.Rebaseline_In_Progress;
        }
        if (destinationBranch.isInvalid()) {
            return CommitStatus.Branch_Not_Configured;
        }
        Collection transactions = this.getCommittedArtifactTransactionIds(teamWf);
        boolean mergeBranchExists = this.isMergeBranchExists(teamWf, destinationBranch);
        for (TransactionToken transId : transactions) {
            if (!transId.isOnBranch(destinationBranch)) continue;
            if (mergeBranchExists) {
                return CommitStatus.Committed_With_Merge;
            }
            return CommitStatus.Committed;
        }
        if (this.workingBranchCommittedToDestinationBranchParentPriorToDestinationBranchCreation(teamWf, destinationBranch, transactions)) {
            return CommitStatus.No_Commit_Needed;
        }
        CommitOverride override = this.getCommitOverrideOps().getCommitOverride(teamWf, destinationBranch);
        if (override != null) {
            return CommitStatus.Commit_Overridden;
        }
        Result result = new Result(false);
        result = configItem == null ? this.isCommitBranchAllowed(teamWf) : configItem.isAllowCommitBranchInherited();
        if (result.isFalse()) {
            return CommitStatus.Branch_Commit_Disabled;
        }
        if (this.getWorkingBranch(teamWf).isInvalid()) {
            return CommitStatus.Working_Branch_Not_Created;
        }
        if (mergeBranchExists) {
            return CommitStatus.Merge_In_Progress;
        }
        return CommitStatus.Commit_Needed;
    }

    public Collection<TransactionRecord> getTransactionIds(IAtsTeamWorkflow teamWf, boolean forMergeBranches) {
        if (forMergeBranches) {
            BranchToken workingBranch = this.getWorkingBranch(teamWf);
            ArrayList<TransactionRecord> transactionIds = new ArrayList<TransactionRecord>();
            for (TransactionRecord transactionId : this.getCommitTransactionsToUnarchivedBaselineBranchs(teamWf)) {
                if (!this.isMergeBranchExists(teamWf, (BranchId)workingBranch, transactionId.getBranch())) continue;
                transactionIds.add(transactionId);
            }
            return transactionIds;
        }
        return this.getCommitTransactionsToUnarchivedBaselineBranchs(teamWf);
    }

    public boolean isMergeBranchExists(IAtsTeamWorkflow teamWf, BranchId destinationBranch) {
        return this.isMergeBranchExists(teamWf, (BranchId)this.getWorkingBranch(teamWf), destinationBranch);
    }

    public Set<BranchId> getBranchesInCommit() {
        return branchesInCommit;
    }

    public boolean workingBranchCommittedToDestinationBranchParentPriorToDestinationBranchCreation(IAtsTeamWorkflow teamWf, BranchId destinationBranch, Collection<? extends TransactionToken> commitTransactionIds) {
        BranchId destinationBranchParent = this.getParentBranch(destinationBranch);
        if (this.getBranchType(destinationBranchParent) == BranchType.SYSTEM_ROOT) {
            return false;
        }
        TransactionToken committedToParentTransRecord = null;
        for (TransactionToken transactionToken : commitTransactionIds) {
            if (!transactionToken.isOnBranch(destinationBranchParent)) continue;
            committedToParentTransRecord = transactionToken;
            break;
        }
        if (committedToParentTransRecord != null && committedToParentTransRecord.isOlderThan((TransactionId)this.getBaseTransaction(destinationBranch))) {
            return true;
        }
        return this.workingBranchCommittedToDestinationBranchParentPriorToDestinationBranchCreation(teamWf, destinationBranchParent, commitTransactionIds);
    }

    public String getBranchName(IAtsTeamWorkflow teamWf) {
        String typeName;
        String defaultBranchName = null;
        String smaTitle = teamWf.getName();
        if (smaTitle.length() > 40) {
            smaTitle = String.valueOf(smaTitle.substring(0, 39)) + "...";
        }
        defaultBranchName = Strings.isValid((String)(typeName = this.atsApi.getWorkItemService().getArtifactTypeShortName(teamWf))) ? String.format("%s - %s - %s", teamWf.getAtsId(), typeName, smaTitle) : String.format("%s - %s", teamWf.getAtsId(), smaTitle);
        for (ITeamWorkflowProvider teamExtension : this.teamWorkflowProvidersLazy.getProviders()) {
            String name = teamExtension.getBranchName(teamWf, defaultBranchName);
            if (!Strings.isValid((String)name)) continue;
            defaultBranchName = name;
            break;
        }
        defaultBranchName = Strings.truncate((String)defaultBranchName, (int)195, (boolean)true);
        return defaultBranchName;
    }

    public BranchToken getWorkingBranchInWork(IAtsTeamWorkflow teamWf) {
        BranchToken branch = this.getWorkingBranch(teamWf);
        if (branch.isValid() && (this.getBranchState((BranchId)branch).isCreated() || this.getBranchState((BranchId)branch).isModified())) {
            return branch;
        }
        return BranchToken.SENTINEL;
    }

    public CommitOverrideOperations getCommitOverrideOps() {
        if (this.commitOverrideOps == null) {
            this.commitOverrideOps = new CommitOverrideOperationsImpl(this.atsApi);
        }
        return this.commitOverrideOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkingBranchCreationInProgress(IAtsTeamWorkflow teamWf, boolean inProgress) {
        Map<ArtifactId, Boolean> map = this.workingBranchCreatingInProgress;
        synchronized (map) {
            this.workingBranchCreatingInProgress.put(teamWf.getArtifactId(), inProgress);
        }
    }

    public boolean isWorkingBranchCreationInProgress(IAtsTeamWorkflow teamWf) {
        Boolean inProgress = this.workingBranchCreatingInProgress.get(teamWf.getArtifactId());
        return inProgress == null ? false : inProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkingBranchCommitInProgress(IAtsTeamWorkflow teamWf, boolean inProgress) {
        Map<ArtifactId, Boolean> map = this.workingBranchCommitInProgress;
        synchronized (map) {
            this.workingBranchCommitInProgress.put(teamWf.getArtifactId(), inProgress);
        }
    }

    public boolean isWorkingBranchCommitInProgress(IAtsTeamWorkflow teamWf) {
        Boolean inProgress = this.workingBranchCommitInProgress.get(teamWf.getArtifactId());
        return inProgress == null ? false : inProgress;
    }

    public Collection<ChangeItem> getChangeData(IAtsTeamWorkflow teamWf) {
        throw new UnsupportedOperationException();
    }

    public boolean isAtsBranch(BranchId branchId) {
        ArtifactId assocArtId = this.atsApi.getBranchService().getAssociatedArtifactId(branchId);
        ArtifactToken assocArt = this.atsApi.getQueryService().getArtifact(assocArtId);
        return assocArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow});
    }

    public BranchData validate(BranchData bd, AtsApi atsApi) {
        if (bd.getParent().isInvalid()) {
            bd.getResults().errorf("Invalid Parent Branch %s", new Object[]{bd.getParent().getIdString()});
            return bd;
        }
        if (Strings.isInValid((String)bd.getBranchName())) {
            bd.getResults().errorf("Invalid new Branch Name", new Object[]{bd.getBranchName()});
            return bd;
        }
        BranchType type = bd.getBranchType();
        if (!type.equals((Object)BranchType.WORKING) && !type.equals((Object)BranchType.BASELINE)) {
            bd.getResults().errorf("Invalid Branch Type [%s] to create", new Object[]{bd.getBranchType()});
            return bd;
        }
        return bd;
    }
}

