/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileService;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxAgileBacklog;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public class AgileBacklogWriter {
    private final AtsApi atsApi;
    private final IAgileService agileService;
    private final JaxAgileBacklog updatedBacklog;

    public AgileBacklogWriter(AtsApi atsApi, IAgileService agileService, JaxAgileBacklog updatedBacklog) {
        this.atsApi = atsApi;
        this.agileService = agileService;
        this.updatedBacklog = updatedBacklog;
    }

    public IAgileBacklog write() {
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Update Agile Backlog", AtsCoreUsers.SYSTEM_USER);
        IAgileBacklog currentBacklog = this.agileService.getAgileBacklog(this.updatedBacklog.getId().longValue());
        if (currentBacklog == null) {
            throw new OseeArgumentException("No Backlog found with ID %d", new Object[]{this.updatedBacklog.getId()});
        }
        if (currentBacklog.getTeamId() != this.updatedBacklog.getTeamId()) {
            if (currentBacklog.getTeamId() == -1L) {
                IAgileTeam team = this.agileService.getAgileTeam(currentBacklog.getTeamId());
                if (team != null) {
                    changes.unrelateAll((Object)team, AtsRelationTypes.AgileTeamToBacklog_Backlog);
                    changes.add((Object)team);
                }
            } else {
                ArtifactToken updateBacklogArt = this.atsApi.getQueryService().getArtifact(this.updatedBacklog.getId());
                IAgileTeam updatedTeam = this.agileService.getAgileTeam(this.updatedBacklog.getTeamId());
                if (updatedTeam != null) {
                    ArtifactToken currentTeamArt;
                    ArtifactToken updatedTeamArt = updatedTeam.getStoreObject();
                    if (!updateBacklogArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
                        throw new OseeArgumentException("Backlog ID %d not valid type", new Object[]{this.updatedBacklog.getId()});
                    }
                    if (this.atsApi.getRelationResolver().getRelatedCount(updateBacklogArt, AtsRelationTypes.AgileTeamToBacklog_AgileTeam) > 0 && updatedTeamArt.notEqual((Id)(currentTeamArt = this.atsApi.getRelationResolver().getRelatedOrNull((ArtifactId)updateBacklogArt, AtsRelationTypes.AgileTeamToBacklog_AgileTeam)))) {
                        changes.unrelate((ArtifactId)currentTeamArt, AtsRelationTypes.AgileTeamToBacklog_Backlog, (ArtifactId)updateBacklogArt);
                        changes.add((Object)currentTeamArt);
                    }
                    changes.relate((ArtifactId)updatedTeamArt, AtsRelationTypes.AgileTeamToBacklog_Backlog, (ArtifactId)updateBacklogArt);
                    if (!this.atsApi.getRelationResolver().areRelated((ArtifactId)updatedTeamArt, CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)updateBacklogArt)) {
                        if (this.atsApi.getRelationResolver().getParent((ArtifactId)updateBacklogArt) != null) {
                            changes.unrelate((ArtifactId)this.atsApi.getRelationResolver().getParent((ArtifactId)updateBacklogArt), CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)updateBacklogArt);
                        }
                        changes.relate((ArtifactId)updatedTeamArt, CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)updateBacklogArt);
                    }
                    changes.add((Object)updatedTeamArt);
                }
            }
        }
        if (!changes.isEmpty()) {
            changes.execute();
        }
        return this.agileService.getAgileBacklog(this.updatedBacklog.getId().longValue());
    }
}

