/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.op.IgnoreOperation;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryFinder;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;

public class ConnectProviderOperation
implements IEGitOperation {
    private final Map<IProject, File> projects = new LinkedHashMap<IProject, File>();
    private boolean refreshResources = true;

    public ConnectProviderOperation(IProject proj) {
        this(proj, proj.getLocation().append(".git").toFile());
    }

    public ConnectProviderOperation(IProject proj, File pathToRepo) {
        this.projects.put(proj, pathToRepo);
    }

    public ConnectProviderOperation(Map<IProject, File> projects) {
        this.projects.putAll(projects);
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)m, (String)CoreText.ConnectProviderOperation_connecting, (int)this.projects.size());
        MultiStatus ms = new MultiStatus(Activator.getPluginId(), 0, CoreText.ConnectProviderOperation_ConnectErrors, null);
        for (Map.Entry<IProject, File> entry : this.projects.entrySet()) {
            this.connectProject(entry, ms, (IProgressMonitor)progress.newChild(1));
        }
        if (!ms.isOK()) {
            throw new CoreException((IStatus)ms);
        }
    }

    private void connectProject(Map.Entry<IProject, File> entry, MultiStatus ms, IProgressMonitor monitor) throws CoreException {
        IProject project = entry.getKey();
        String taskName = NLS.bind((String)CoreText.ConnectProviderOperation_ConnectingProject, (Object)project.getName());
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)100);
        if (GitTraceLocation.CORE.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.CORE.getLocation(), taskName);
        }
        RepositoryFinder finder = new RepositoryFinder(project);
        finder.setFindInChildren(false);
        List<RepositoryMapping> repos = finder.find((IProgressMonitor)subMon.newChild(50));
        if (repos.isEmpty()) {
            ms.add(Activator.error(NLS.bind((String)CoreText.ConnectProviderOperation_NoRepositoriesError, (Object)project.getName()), null));
            return;
        }
        RepositoryMapping actualMapping = this.findActualRepository(repos, entry.getValue());
        if (actualMapping == null) {
            ms.add(Activator.error(NLS.bind((String)CoreText.ConnectProviderOperation_UnexpectedRepositoryError, (Object[])new Object[]{project.getName(), entry.getValue().toString(), repos.toString()}), null));
            return;
        }
        GitProjectData projectData = new GitProjectData(project);
        try {
            projectData.setRepositoryMappings(Arrays.asList(actualMapping));
            projectData.store();
            GitProjectData.add(project, projectData);
        }
        catch (CoreException ce) {
            ms.add(ce.getStatus());
            this.deleteGitProvider(ms, project);
            return;
        }
        catch (RuntimeException ce) {
            ms.add(Activator.error(ce.getMessage(), ce));
            this.deleteGitProvider(ms, project);
            return;
        }
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.egit.core.GitProvider");
        IPath gitPath = actualMapping.getGitDirAbsolutePath();
        if (this.refreshResources) {
            this.touchGitResources(project, (IProgressMonitor)subMon.newChild(10));
            project.refreshLocal(2, (IProgressMonitor)subMon.newChild(30));
            if (gitPath != null) {
                try {
                    Repository repository = Activator.getDefault().getRepositoryCache().lookupRepository(gitPath.toFile());
                    IndexDiffCacheEntry cacheEntry = Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(repository);
                    if (cacheEntry != null) {
                        cacheEntry.refresh();
                    }
                }
                catch (IOException e) {
                    Activator.logError(e.getMessage(), e);
                }
            }
        } else {
            subMon.worked(40);
        }
        this.autoIgnoreDerivedResources(project, (IProgressMonitor)subMon.newChild(10));
        if (gitPath != null) {
            ConnectProviderOperation.autoIgnoreWorkspaceMetaData(gitPath.toFile());
        }
    }

    private void touchGitResources(IProject project, IProgressMonitor monitor) {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            project.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy resource) throws CoreException {
                    int type = resource.getType();
                    if ((type == 1 || type == 2) && ".git".equals(resource.getName())) {
                        progress.setWorkRemaining(2);
                        resource.requestResource().touch((IProgressMonitor)progress.newChild(1));
                        return false;
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException e) {
            Activator.logError(e.getMessage(), e);
        }
    }

    private void deleteGitProvider(MultiStatus ms, IProject project) {
        try {
            GitProjectData.delete(project);
        }
        catch (IOException e) {
            ms.add(Activator.error(e.getMessage(), e));
        }
    }

    private void autoIgnoreDerivedResources(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!Activator.autoIgnoreDerived()) {
            return;
        }
        List<IPath> paths = this.findDerivedResources((IContainer)project);
        if (paths.size() > 0) {
            IgnoreOperation ignoreOp = new IgnoreOperation(paths);
            ignoreOp.execute(monitor);
        }
    }

    private static void autoIgnoreWorkspaceMetaData(File gitDir) {
        java.nio.file.Path workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toPath();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Repository r = FileRepositoryBuilder.create((File)gitDir);){
                if (!r.isBare() && workspaceRoot.startsWith(r.getWorkTree().toPath())) {
                    Collection<IPath> ignoredPaths = ConnectProviderOperation.buildIgnoredPathsList(workspaceRoot, ".metadata", ".recommenders");
                    JobUtil.scheduleUserJob(new IgnoreOperation(ignoredPaths), CoreText.ConnectProviderOperation_autoIgnoreMetaData, JobFamilies.AUTO_IGNORE);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
        }
    }

    private static Collection<IPath> buildIgnoredPathsList(java.nio.file.Path workspaceRoot, String ... metaDataDirectoryNames) {
        HashSet<IPath> ignoredPaths = new HashSet<IPath>();
        String[] stringArray = metaDataDirectoryNames;
        int n = metaDataDirectoryNames.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            Path metaData = new Path(workspaceRoot.resolve(m).toAbsolutePath().toString());
            try {
                if (RepositoryUtil.canBeAutoIgnored((IPath)metaData)) {
                    ignoredPaths.add((IPath)metaData);
                }
            }
            catch (IOException e) {
                Activator.logError(e.getMessage(), e);
            }
            ++n2;
        }
        return ignoredPaths;
    }

    private List<IPath> findDerivedResources(IContainer c) throws CoreException {
        IResource[] members;
        ArrayList<IPath> derived = new ArrayList<IPath>();
        IResource[] iResourceArray = members = c.members(8);
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            if (r.isDerived()) {
                derived.add(r.getLocation());
            } else if (r instanceof IContainer) {
                derived.addAll(this.findDerivedResources((IContainer)r));
            }
            ++n2;
        }
        return derived;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        Set<IProject> projectSet = this.projects.keySet();
        return new MultiRule((ISchedulingRule[])projectSet.toArray(new IProject[0]));
    }

    @Nullable
    private RepositoryMapping findActualRepository(Collection<RepositoryMapping> repos, File suggestedRepo) {
        File path = Path.fromOSString((String)suggestedRepo.getPath()).toFile();
        for (RepositoryMapping rm : repos) {
            IPath other = rm.getGitDirAbsolutePath();
            if (other == null || !path.equals(other.toFile())) continue;
            return rm;
        }
        return null;
    }

    public void setRefreshResources(boolean refresh) {
        this.refreshResources = refresh;
    }
}

