/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.mini;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionToken;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.ats.ide.workflow.task.TaskXViewer;
import org.eclipse.osee.ats.ide.world.WorldContentProvider;
import org.eclipse.osee.ats.ide.world.WorldLabelProvider;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactTopicEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.GenericXWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XLabelValue;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidgetUtility;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public abstract class XMiniTaskWidget
extends GenericXWidget
implements ArtifactWidget,
IArtifactEventListener,
IArtifactTopicEventListener {
    protected TaskXViewer xTaskViewer;
    public static final String normalColor = "#EEEEEE";
    private static final int paddedTableHeightHint = 2;
    protected Label extraInfoLabel;
    private int lastSize = 0;
    private final int MAX_TABLE_SIZE = 10;
    private Composite mainComp;
    private Composite parentComp;
    protected final AtsApi atsApi;
    protected XLabelValue pointsLabel;
    private final IXViewerFactory xViewerFactory;
    protected IAtsTeamWorkflow teamWf;

    public XMiniTaskWidget(String label, IXViewerFactory xViewerFactory) {
        super(label);
        this.xViewerFactory = xViewerFactory;
        this.atsApi = AtsApiService.get();
    }

    public abstract Collection<IAtsTask> getTasks();

    public abstract AtsWorkDefinitionToken getTaskWorkDefTok();

    public String getTaskNameFormat() {
        return "Estimate for [%s]";
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        this.parentComp = new Composite(parent, 0x800000);
        this.parentComp.setLayoutData((Object)new GridData(768));
        this.parentComp.setLayout((Layout)ALayout.getZeroMarginLayout());
        final XMiniTaskWidget fWidget = this;
        this.parentComp.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                OseeEventManager.removeListener((IEventListener)fWidget);
            }
        });
        OseeEventManager.addListener((IEventListener)this);
        this.redrawComposite();
    }

    protected WorldLabelProvider getWorldLabelProvider(TaskXViewer xTaskViewer) {
        return new WorldLabelProvider(xTaskViewer);
    }

    protected WorldContentProvider getWorldContentProvider(TaskXViewer xTaskViewer) {
        return new WorldContentProvider(xTaskViewer);
    }

    private void redrawComposite() {
        if (this.parentComp == null || !Widgets.isAccessible((Widget)this.parentComp)) {
            return;
        }
        if (this.mainComp != null && Widgets.isAccessible((Widget)this.mainComp)) {
            this.mainComp.dispose();
            this.xTaskViewer = null;
        }
        this.mainComp = new Composite(this.parentComp, 0x800000);
        this.mainComp.setLayoutData((Object)new GridData(768));
        this.mainComp.setLayout((Layout)new GridLayout(1, true));
        if (this.toolkit != null) {
            this.toolkit.paintBordersFor(this.mainComp);
        }
        this.labelWidget = new Label(this.mainComp, 0);
        this.labelWidget.setText(String.valueOf(this.getLabel()) + ":");
        if (this.getToolTip() != null) {
            this.labelWidget.setToolTipText(this.getToolTip());
        }
        try {
            Composite tableComp = new Composite(this.mainComp, 2048);
            GridData gd = new GridData(768);
            tableComp.setLayoutData((Object)gd);
            tableComp.setLayout((Layout)ALayout.getZeroMarginLayout());
            if (this.toolkit != null) {
                this.toolkit.paintBordersFor(tableComp);
            }
            ToolBar toolBar = this.createActionBar(tableComp);
            this.xTaskViewer = this.createXTaskViewer(tableComp);
            this.xTaskViewer.getTree().setLayoutData((Object)new GridData(768));
            this.xTaskViewer.setContentProvider((IContentProvider)this.getWorldContentProvider(this.xTaskViewer));
            this.xTaskViewer.setLabelProvider((IBaseLabelProvider)this.getWorldLabelProvider(this.xTaskViewer));
            new ActionContributionItem((IAction)this.xTaskViewer.getCustomizeAction()).fill(toolBar, -1);
            if (this.toolkit != null && this.xTaskViewer.getStatusLabel() != null) {
                this.toolkit.adapt((Control)this.xTaskViewer.getStatusLabel(), false, false);
            }
            this.pointsLabel = new XLabelValue("Total Estimated Points", "0");
            this.pointsLabel.createWidgets(tableComp, 2);
            this.pointsLabel.getComp().setLayout((Layout)new GridLayout(2, false));
            XWidgetUtility.setLabelFontsBold((XWidget)this.pointsLabel);
            if (this.toolkit != null) {
                this.toolkit.adapt((Control)this.pointsLabel.getLabelWidget(), false, false);
                this.toolkit.adapt((Control)this.pointsLabel.getValueTextWidget(), false, false);
            }
            this.refresh();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        XWidgetUtility.setLabelFontsBold((Control)this.labelWidget, (Font)FontManager.getDefaultLabelFont());
        this.parentComp.layout();
    }

    protected TaskXViewer createXTaskViewer(Composite tableComp) {
        this.xTaskViewer = new TaskXViewer(tableComp, 67586, this.xViewerFactory, null, this.teamWf);
        return this.xTaskViewer;
    }

    public abstract ToolBar createActionBar(Composite var1);

    public void setXviewerTreeSize() {
        if (this.xTaskViewer == null || !Widgets.isAccessible((Widget)this.xTaskViewer.getTree())) {
            return;
        }
        Tree tree = this.xTaskViewer.getTree();
        int size = this.xTaskViewer.getTree().getItemCount();
        if (size > 10) {
            size = 10;
        }
        if (size == this.lastSize) {
            return;
        }
        this.lastSize = size;
        int treeItemHeight = this.xTaskViewer.getTree().getItemHeight();
        GridData gridData = new GridData(768);
        gridData.heightHint = treeItemHeight * (2 + size);
        tree.setLayout((Layout)ALayout.getZeroMarginLayout());
        tree.setLayoutData((Object)gridData);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
    }

    public void loadTable() {
        try {
            if (this.xTaskViewer != null && this.xTaskViewer.getContentProvider() != null) {
                this.xTaskViewer.setInput(this.getTasks());
                this.xTaskViewer.refresh();
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public Control getControl() {
        return this.labelWidget;
    }

    public void refresh() {
        if (this.xTaskViewer == null || this.xTaskViewer.getTree() == null || this.xTaskViewer.getTree().isDisposed()) {
            return;
        }
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                XMiniTaskWidget.this.loadTable();
                XMiniTaskWidget.this.setXviewerTreeSize();
                XMiniTaskWidget.this.updateExtraInfoLabel();
            }
        });
    }

    public WorldXViewer getxWorldViewer() {
        return this.xTaskViewer;
    }

    public Label getExtraInfoLabel() {
        return this.extraInfoLabel;
    }

    public void setExtraInfoLabel(Label extraInfoLabel) {
        this.extraInfoLabel = extraInfoLabel;
    }

    public abstract Pair<Integer, String> getExtraInfoString();

    private void updateExtraInfoLabel() {
        Pair<Integer, String> entry = this.getExtraInfoString();
        this.updateExtraInfoLabel((Integer)entry.getFirst(), (String)entry.getSecond());
    }

    private void updateExtraInfoLabel(final int color, final String infoStr) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Widgets.isAccessible((Widget)XMiniTaskWidget.this.extraInfoLabel)) {
                    String currentString = XMiniTaskWidget.this.extraInfoLabel.getText();
                    if (infoStr == null && currentString != null || infoStr != null && currentString == null || infoStr != null && currentString != null && !infoStr.equals(currentString)) {
                        XMiniTaskWidget.this.extraInfoLabel.setText(infoStr);
                    }
                    XMiniTaskWidget.this.extraInfoLabel.setForeground(Displays.getSystemColor((int)color));
                }
            }
        });
    }

    public void setArtifact(Artifact artifact) {
        if (artifact instanceof IAtsTeamWorkflow) {
            this.teamWf = (IAtsTeamWorkflow)artifact;
        }
    }

    public List<? extends IEventFilter> getEventFilters() {
        return Arrays.asList(AtsUtilClient.getAtsBranchFilter());
    }

    public void handleArtifactEvent(ArtifactEvent artifactEvent, Sender sender) {
        try {
            if (this.teamWf != null && Widgets.isAccessible((Widget)this.mainComp)) {
                if (artifactEvent.isHasEvent((Artifact)this.teamWf.getStoreObject())) {
                    this.refresh();
                    return;
                }
                for (IAtsTask task : this.atsApi.getTaskService().getTasks(this.teamWf)) {
                    if (artifactEvent.isHasEvent((Artifact)task.getStoreObject())) {
                        this.refresh();
                        return;
                    }
                    if (!artifactEvent.isReloaded((Artifact)task.getStoreObject())) continue;
                    this.refresh();
                    return;
                }
            }
        }
        catch (Exception exception) {}
    }

    public void handleArtifactTopicEvent(ArtifactTopicEvent artifactTopicEvent, Sender sender) {
        try {
            if (this.teamWf != null && Widgets.isAccessible((Widget)this.mainComp)) {
                if (artifactTopicEvent.isHasEvent((Artifact)this.teamWf.getStoreObject())) {
                    this.refresh();
                    return;
                }
                for (IAtsTask task : this.atsApi.getTaskService().getTasks(this.teamWf)) {
                    if (artifactTopicEvent.isHasEvent((Artifact)task.getStoreObject())) {
                        this.refresh();
                        return;
                    }
                    if (!artifactTopicEvent.isReloaded((Artifact)task.getStoreObject())) continue;
                    this.refresh();
                    return;
                }
            }
        }
        catch (Exception exception) {}
    }
}

