/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.priority;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IAltLeftClickProvider;
import org.eclipse.nebula.widgets.xviewer.IMultiColumnEditProvider;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokens;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.Priorities;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.PriorityColumn;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumnIdColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.priority.PriorityDialog;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class PriorityColumnUI
extends XViewerAtsColumnIdColumn
implements IAltLeftClickProvider,
IMultiColumnEditProvider {
    public static PriorityColumnUI instance = new PriorityColumnUI();

    public static PriorityColumnUI getInstance() {
        return instance;
    }

    private PriorityColumnUI() {
        super(AtsColumnTokens.PriorityColumn);
    }

    @Override
    public PriorityColumnUI copy() {
        PriorityColumnUI newXCol = new PriorityColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    public static boolean promptPriority(Collection<IAtsTeamWorkflow> teamWfs) {
        try {
            Priorities priority;
            PriorityDialog dialog = new PriorityDialog(teamWfs, null);
            if (teamWfs.size() == 1 && (priority = PriorityColumn.getPriority((IAtsWorkItem)((IAtsWorkItem)teamWfs.iterator().next()), (AtsApi)AtsApiService.get())) != null) {
                dialog.setSelected(priority);
            }
            if (dialog.open() == 0) {
                IAtsChangeSet changes = AtsApiService.get().createChangeSet("ATS Prompt Priority");
                Priorities newChangeType = (Priorities)dialog.getSelected();
                for (IAtsTeamWorkflow team : teamWfs) {
                    PriorityColumn.setPriority((IAtsObject)team, (Priorities)newChangeType, (IAtsChangeSet)changes);
                }
                changes.executeIfNeeded();
            }
            return true;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Can't change Priority", (Throwable)ex);
            return false;
        }
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        block7: {
            Artifact useArt;
            block10: {
                block9: {
                    block8: {
                        if (!(treeItem.getData() instanceof Artifact)) break block7;
                        useArt = AtsApiService.get().getQueryServiceIde().getArtifact(treeItem);
                        if (useArt.getArtifactType().getMax((AttributeTypeToken)AtsAttributeTypes.ChangeType) == 1) break block8;
                        return false;
                    }
                    if (!useArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) break block9;
                    if (AtsApiService.get().getWorkItemService().getTeams((Object)useArt).size() == 1) {
                        useArt = (AbstractWorkflowArtifact)AtsApiService.get().getWorkItemService().getFirstTeam((Object)useArt).getStoreObject();
                        break block9;
                    }
                    return false;
                }
                if (useArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) break block10;
                return false;
            }
            try {
                boolean modified = PriorityColumnUI.promptPriority(Arrays.asList(new IAtsTeamWorkflow[]{(TeamWorkFlowArtifact)useArt}));
                XViewer xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
                if (modified) {
                    useArt.persist("persist change type via alt-left-click");
                    xViewer.update((Object)useArt, null);
                    return true;
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return false;
    }

    @Override
    public Image getColumnImage(Object element, XViewerColumn column, int columnIndex) {
        try {
            Priorities priority;
            IAtsWorkItem workItem;
            IAtsTeamWorkflow useArt;
            if (element instanceof IAtsWorkItem && (useArt = (workItem = (IAtsWorkItem)element).getParentTeamWorkflow()) != null && (priority = PriorityColumn.getPriority((IAtsWorkItem)workItem, (AtsApi)AtsApiService.get())) != null) {
                return PriorityColumnUI.getImage(priority);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return null;
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        HashSet<IAtsTeamWorkflow> awas = new HashSet<IAtsTeamWorkflow>();
        for (TreeItem item : treeItems) {
            if (!(item.getData() instanceof Artifact)) continue;
            Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(item);
            if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) continue;
            awas.add((IAtsTeamWorkflow)art);
        }
        PriorityColumnUI.promptPriority(awas);
        ((XViewer)this.getXViewer()).update(awas.toArray(), null);
    }

    public static Image getImage(Priorities type) {
        return null;
    }
}

