/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.goal;

import java.util.Arrays;
import java.util.List;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerSorter;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.column.AtsColumnTokens;
import org.eclipse.osee.ats.ide.column.AssigneeColumnUI;
import org.eclipse.osee.ats.ide.column.ChangeTypeColumnUI;
import org.eclipse.osee.ats.ide.column.CreatedDateColumnUI;
import org.eclipse.osee.ats.ide.column.GoalOrderColumn;
import org.eclipse.osee.ats.ide.column.GoalOrderVoteColumn;
import org.eclipse.osee.ats.ide.column.TargetedVersionColumnUI;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsAttributeValueColumn;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.priority.PriorityColumnUI;
import org.eclipse.osee.ats.ide.world.WorldXViewerFactory;
import org.eclipse.osee.ats.ide.world.WorldXViewerSorter;
import org.eclipse.osee.ats.ide.world.WorldXViewerUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.IOseeTreeReportProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.SkynetXViewerFactory;

public class GoalXViewerFactory
extends SkynetXViewerFactory {
    private final GoalArtifact soleGoalArtifact;
    private static final String NAMESPACE = "GoalXViewer";
    private final Integer[] widths = new Integer[]{GoalOrderColumn.DEFAULT_WIDTH, GoalOrderVoteColumn.DEFAULT_WIDTH, 250, 60, 60, 20, 20, 100, 50, 50, 50, 80};

    private List<? extends XViewerColumn> getGoalViewerVisibleColumns() {
        List<XViewerColumn> columns = Arrays.asList(new XViewerColumn[]{GoalOrderColumn.getInstance(), GoalOrderVoteColumn.getInstance(), new XViewerAtsAttributeValueColumn(AtsColumnTokens.TitleColumn), WorldXViewerFactory.getColumnServiceColumn(AtsColumnTokens.TypeColumn), WorldXViewerFactory.getColumnServiceColumn(AtsColumnTokens.StateColumn), PriorityColumnUI.getInstance(), ChangeTypeColumnUI.getInstance(), AssigneeColumnUI.getInstance(), WorldXViewerFactory.getColumnServiceColumn(AtsColumnTokens.AtsIdColumnShow), new CreatedDateColumnUI(), TargetedVersionColumnUI.getInstance(), WorldXViewerFactory.getColumnServiceColumn(AtsColumnTokens.StateColumn)});
        return columns;
    }

    public GoalXViewerFactory(GoalArtifact soleGoalArtifact, IOseeTreeReportProvider reportProvider) {
        super(NAMESPACE, reportProvider);
        this.soleGoalArtifact = soleGoalArtifact;
        int widthIndex = 0;
        List<? extends XViewerColumn> goalViewerVisibleColumns = this.getGoalViewerVisibleColumns();
        for (XViewerColumn xViewerColumn : goalViewerVisibleColumns) {
            XViewerColumn newCol = xViewerColumn.copy();
            newCol.setShow(true);
            newCol.setWidth(this.widths[widthIndex++].intValue());
            this.registerColumns(new XViewerColumn[]{newCol});
        }
        XViewerColumn[] xViewerColumnArray = WorldXViewerFactory.getWorldViewColumns();
        int n = xViewerColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            XViewerColumn xViewerColumn = xViewerColumnArray[n2];
            if (!goalViewerVisibleColumns.contains(xViewerColumn)) {
                XViewerColumn newCol = xViewerColumn.copy();
                newCol.setShow(false);
                this.registerColumns(new XViewerColumn[]{newCol});
            }
            ++n2;
        }
        WorldXViewerUtil.registerAtsAttributeColumns(this);
        WorldXViewerUtil.registerPluginColumns(this);
        WorldXViewerUtil.registerConfigurationsColumns(this);
    }

    public XViewerSorter createNewXSorter(XViewer xViewer) {
        return new WorldXViewerSorter(xViewer);
    }

    public CustomizeData getDefaultTableCustomizeData() {
        CustomizeData customizeData = super.getDefaultTableCustomizeData();
        for (XViewerColumn xCol : customizeData.getColumnData().getColumns()) {
            if (!xCol.getId().equals("ats.column.goalOrder")) continue;
            xCol.setSortForward(true);
        }
        customizeData.getSortingData().setSortingNames(new String[]{"ats.column.goalOrder"});
        return customizeData;
    }

    public GoalArtifact getSoleGoalArtifact() {
        return this.soleGoalArtifact;
    }
}

