/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.duplicate;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.clone.CloneData;
import org.eclipse.osee.ats.core.workflow.duplicate.CloneTeamWorkflowOperation;
import org.eclipse.osee.ats.core.workflow.util.IDuplicateWorkflowListener;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.duplicate.CloneDialog;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class CloneWorkflowAction
extends Action {
    private final IAtsTeamWorkflow teamWf;
    private final IDuplicateWorkflowListener duplicateListener;
    private CloneDialog dialog;
    private final AtsApi atsApi;

    public CloneWorkflowAction(IAtsTeamWorkflow teamWf, IDuplicateWorkflowListener duplicateListener) {
        super("Clone Workflow");
        this.teamWf = teamWf;
        this.duplicateListener = duplicateListener;
        this.atsApi = AtsApiService.get();
    }

    public void run() {
        if (this.teamWf.isCompletedOrCancelled()) {
            AWorkbench.popup((String)"Unable to Clone a Completed or Cancelled workflow");
            return;
        }
        if (this.teamWf.isChangeRequest()) {
            AWorkbench.popup((String)"Unable to Clone a Change Request");
            return;
        }
        CloneData data = new CloneData();
        this.dialog = new CloneDialog(this.getText(), "Enter details for new cloned Team Workflow", this.teamWf, data);
        if (data.getResults().isErrors()) {
            AWorkbench.popup((String)data.toString());
        } else if (this.dialog.open() == 0) {
            CloneTeamWorkflowOperation clone = new CloneTeamWorkflowOperation(this.teamWf, this.duplicateListener, data, this.atsApi);
            if ((data = clone.run()).getResults().isErrors()) {
                XResultDataUI.report((XResultData)data.getResults(), (String)"Clone Workflow");
            } else {
                ArtifactId newTeamWf = data.getNewTeamWf();
                IAtsWorkItem workItem = this.atsApi.getQueryService().getWorkItem(newTeamWf.getIdString());
                WorkflowEditor.edit(workItem);
            }
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.DUPLICATE);
    }
}

