/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.walker;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.help.ui.AtsHelpContext;
import org.eclipse.osee.ats.ide.AtsOpenOption;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.ats.ide.walker.ActionWalkerContentProvider;
import org.eclipse.osee.ats.ide.walker.ActionWalkerLabelProvider;
import org.eclipse.osee.ats.ide.walker.IActionWalkerItem;
import org.eclipse.osee.ats.ide.walker.WalkerLayoutManager;
import org.eclipse.osee.ats.ide.walker.action.ActionWalkerLayoutAction;
import org.eclipse.osee.ats.ide.walker.action.ActionWalkerRefreshAction;
import org.eclipse.osee.ats.ide.walker.action.ActionWalkerShowAllAction;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.HelpContext;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactTopicEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ITopicEventFilter;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.HelpUtil;
import org.eclipse.osee.framework.ui.skynet.util.DbConnectionExceptionComposite;
import org.eclipse.osee.framework.ui.skynet.widgets.GenericViewPart;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.layouts.LayoutAlgorithm;

public class ActionWalkerView
extends GenericViewPart
implements IPartListener,
IArtifactEventListener,
IArtifactTopicEventListener,
IPerspectiveListener2 {
    public static final String VIEW_ID = "org.eclipse.osee.ats.ide.ActionWalkerView";
    protected GraphViewer viewer;
    private Composite viewerComp;
    private AbstractWorkflowArtifact activeAwa;
    private IActionWalkerItem activeGraphItem;
    private Artifact topAtsArt;
    private boolean showAll = false;
    private final WalkerLayoutManager layoutMgr;

    public ActionWalkerView() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
        this.layoutMgr = new WalkerLayoutManager(this);
    }

    public void createPartControl(Composite parent) {
        if (DbConnectionExceptionComposite.dbConnectionIsOk((Composite)parent)) {
            this.viewerComp = new Composite(parent, 2048);
            this.viewerComp.setLayout((Layout)new FillLayout());
            this.viewer = new GraphViewer(this.viewerComp, 0);
            this.viewer.setContentProvider((IContentProvider)new ActionWalkerContentProvider(this));
            this.viewer.setLabelProvider((IBaseLabelProvider)new ActionWalkerLabelProvider());
            this.viewer.setConnectionStyle(4);
            this.viewer.setNodeStyle(16);
            this.viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ActionWalkerView.this.handleItemDoubleClick(event);
                }
            });
            this.createActions();
            this.layoutMgr.start();
            this.refresh();
            this.setFocusWidget(this.viewer.getControl());
            HelpUtil.setHelp((Control)this.viewer.getControl(), (HelpContext)AtsHelpContext.ACTION_VIEW);
            OseeEventManager.addListener((IEventListener)this);
        }
    }

    public void dispose() {
        OseeEventManager.removeListener((IEventListener)this);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this);
        super.dispose();
    }

    public void handleItemDoubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        for (Object obj : selection) {
            if (obj instanceof Artifact) {
                Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(obj);
                if (art.isDeleted()) {
                    AWorkbench.popup((String)"ERROR", (String)"Artifact has been deleted");
                    return;
                }
                AtsEditors.openATSAction((ArtifactToken)art, AtsOpenOption.OpenOneOrPopupSelect);
                continue;
            }
            if (!(obj instanceof IActionWalkerItem)) continue;
            ((IActionWalkerItem)obj).handleDoubleClick();
        }
    }

    public Artifact getTopArtifact(Artifact art) {
        Artifact artifact = null;
        try {
            if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
                artifact = art;
            } else if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                artifact = art;
            } else if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                artifact = (Artifact)((TeamWorkFlowArtifact)art).getParentAction().getStoreObject();
            } else if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint})) {
                artifact = art;
            } else if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact}) && !AtsApiService.get().getReviewService().isStandAloneReview((Object)art)) {
                AbstractWorkflowArtifact parentArtifact = ((AbstractWorkflowArtifact)art).getParentAWA();
                if (parentArtifact != null && parentArtifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                    artifact = (Artifact)parentArtifact.getParentAction().getStoreObject();
                } else {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)("Unknown parent " + AtsApiService.get().getAtsId((ArtifactToken)art)));
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return artifact;
    }

    private void explore(AbstractWorkflowArtifact awa) {
        if (awa == null) {
            return;
        }
        this.activeAwa = awa;
        this.topAtsArt = this.getTopArtifact(awa);
        this.viewer.setInput((Object)this.topAtsArt);
        this.highlightActiveAwa();
        this.setTooltips();
        this.setPartName("Action View (" + this.activeAwa.getName() + ")");
    }

    private void setTooltips() {
        try {
            IAtsAction actionArt;
            if (!this.activeAwa.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal}) && !AtsApiService.get().getReviewService().isStandAloneReview((Object)this.activeAwa) && (actionArt = this.activeAwa.getParentAction()) != null) {
                for (IAtsTeamWorkflow teamArt : AtsApiService.get().getWorkItemServiceIde().getTeams(actionArt)) {
                    GraphItem item = this.viewer.findGraphItem((Object)teamArt);
                    if (item == null || !(item instanceof GraphNode)) continue;
                    GraphNode node = (GraphNode)item;
                    node.setTooltip((IFigure)new Label(this.getToolTip((Artifact)teamArt)));
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void highlightActiveAwa() {
        GraphItem item = this.viewer.findGraphItem((Object)this.activeAwa);
        if (item != null && item instanceof GraphNode) {
            GraphNode node = (GraphNode)item;
            node.setBackgroundColor(Displays.getSystemColor((int)13));
            this.viewer.update((Object)node, null);
        } else if (this.activeGraphItem != null && (item = this.viewer.findGraphItem((Object)this.activeGraphItem)) != null && item instanceof GraphNode) {
            GraphNode node = (GraphNode)item;
            node.setBackgroundColor(Displays.getSystemColor((int)13));
            this.viewer.update((Object)node, null);
        }
    }

    private void createActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tbm = bars.getToolBarManager();
        tbm.add((IAction)new ActionWalkerLayoutAction(this));
        tbm.add((IAction)new ActionWalkerShowAllAction(this));
        tbm.add((IAction)new ActionWalkerRefreshAction(this));
        bars.updateActionBars();
    }

    public void refresh() {
        this.explore(this.activeAwa);
    }

    public void processWindowActivated() {
        IEditorPart editor;
        if (!this.getSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null && (editor = page.getActiveEditor()) instanceof WorkflowEditor) {
            this.explore(((WorkflowEditor)editor).getWorkItem());
        }
    }

    public void partActivated(IWorkbenchPart part) {
        this.processWindowActivated();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.processWindowActivated();
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.equals((Object)this)) {
            this.dispose();
        } else {
            this.processWindowActivated();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.processWindowActivated();
    }

    public void partOpened(IWorkbenchPart part) {
        this.processWindowActivated();
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.processWindowActivated();
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        this.processWindowActivated();
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
        this.processWindowActivated();
    }

    public List<? extends IEventFilter> getEventFilters() {
        return AtsUtilClient.getAtsObjectEventFilters();
    }

    public void handleArtifactEvent(ArtifactEvent artifactEvent, Sender sender) {
        if (sender.isRemote()) {
            return;
        }
        if (this.activeAwa == null) {
            return;
        }
        if (artifactEvent.isModifiedReloaded((Artifact)this.activeAwa) || artifactEvent.isRelAddedChangedDeleted((Artifact)this.activeAwa)) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ActionWalkerView.this.explore(ActionWalkerView.this.activeAwa);
                }
            });
        }
    }

    public List<? extends ITopicEventFilter> getTopicEventFilters() {
        return null;
    }

    public void handleArtifactTopicEvent(ArtifactTopicEvent artifactTopicEvent, Sender sender) {
        if (sender.isRemote()) {
            return;
        }
        if (this.activeAwa == null) {
            return;
        }
        if (artifactTopicEvent.isModifiedReloaded((Artifact)this.activeAwa) || artifactTopicEvent.isRelAddedChangedDeleted((Artifact)this.activeAwa)) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ActionWalkerView.this.explore(ActionWalkerView.this.activeAwa);
                }
            });
        }
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
        this.refresh();
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    public WalkerLayoutManager getLayoutMgr() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutAlgorithm algorithm) {
        this.viewer.setLayoutAlgorithm(algorithm);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.layoutMgr.init(site, memento);
    }

    public void saveState(IMemento memento) {
        this.layoutMgr.saveState(memento);
    }

    public String getToolTip(Artifact artifact) {
        if (artifact.isDeleted()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" Name: " + artifact.getName());
        builder.append("\n Type: " + artifact.getArtifactTypeName());
        if (artifact instanceof AbstractWorkflowArtifact) {
            AbstractWorkflowArtifact awa = (AbstractWorkflowArtifact)artifact;
            if (awa instanceof TeamWorkFlowArtifact) {
                try {
                    builder.append("\n Team: " + ((TeamWorkFlowArtifact)awa).getTeamDefinition());
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
            builder.append("\n State: " + AtsApiService.get().getWorkItemService().getCurrentStateName((IAtsWorkItem)((AbstractWorkflowArtifact)artifact)));
            builder.append("\n Assignee: " + this.getAssignee(artifact));
            builder.append("\n Version: " + this.getTargetedVersion(artifact));
        }
        return builder.toString();
    }

    public String getAssignee(Artifact artifact) {
        try {
            if (artifact instanceof AbstractWorkflowArtifact) {
                return AtsObjects.toString((String)"; ", (Collection)((AbstractWorkflowArtifact)artifact).getStateMgr().getAssignees());
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return ex.getLocalizedMessage();
        }
        return "";
    }

    private String getTargetedVersion(Artifact artifact) {
        try {
            if (artifact instanceof IAtsWorkItem) {
                String str = AtsApiService.get().getVersionService().getTargetedVersionStr((IAtsWorkItem)artifact, AtsApiService.get().getVersionService());
                return str.isEmpty() ? "" : str;
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return ex.getLocalizedMessage();
        }
        return "";
    }

    public Artifact getTopAtsArt() {
        return this.topAtsArt;
    }

    public void setActiveGraphItem(IActionWalkerItem activeGraphItem) {
        this.activeGraphItem = activeGraphItem;
    }

    public AbstractWorkflowArtifact getActiveAwa() {
        return this.activeAwa;
    }
}

