/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XWorkingBranchButtonAbstract;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.model.MergeBranch;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ITopicEventFilter;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.util.MergeInProgressHandler;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxBranchDialog;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class XWorkingBranchButtonDeleteMergeBranches
extends XWorkingBranchButtonAbstract {
    public static final String WIDGET_NAME = "XWorkingBranchButtonDeleteMergeBranches";

    @Override
    protected void initButton(Button button) {
        button.setToolTipText("Delete Merge Branch(es)");
        button.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.DELETE_MERGE_BRANCHES));
        button.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    BranchToken workingBranch = XWorkingBranchButtonDeleteMergeBranches.this.getTeamArt().getWorkingBranch();
                    if (XWorkingBranchButtonDeleteMergeBranches.this.isWorkingBranchCommitWithMergeInProgress()) {
                        ArrayList<Object> selectedBranches = new ArrayList<Object>();
                        Collection branchesAlreadyCommitted = AtsApiService.get().getBranchService().getBranchesCommittedTo((IAtsTeamWorkflow)XWorkingBranchButtonDeleteMergeBranches.this.getTeamArt());
                        List mergeBranches = BranchManager.getMergeBranches((BranchId)workingBranch);
                        HashSet<BranchToken> destinationMinusAlreadyCommitted = new HashSet<BranchToken>();
                        for (MergeBranch branch : mergeBranches) {
                            if (branchesAlreadyCommitted.contains(branch.getDestinationBranch())) continue;
                            destinationMinusAlreadyCommitted.add(branch.getDestinationBranch());
                        }
                        if (destinationMinusAlreadyCommitted.size() > 1) {
                            FilteredCheckboxBranchDialog dialog = new FilteredCheckboxBranchDialog("Select Destination Branch(es)", "Select the Destination branch(es) for which you want to Delete the Merge Branch", destinationMinusAlreadyCommitted);
                            if (dialog.open() == 0) {
                                for (BranchId branchToken : dialog.getChecked()) {
                                    selectedBranches.add(branchToken);
                                }
                            }
                        } else if (destinationMinusAlreadyCommitted.size() == 1) {
                            MergeBranch mergeBranch = BranchManager.getFirstMergeBranch((BranchId)workingBranch);
                            selectedBranches.add(mergeBranch.getDestinationBranch());
                        }
                        if (!selectedBranches.isEmpty()) {
                            MergeInProgressHandler.deleteMultipleMergeBranches((BranchId)workingBranch, selectedBranches, (boolean)false);
                        }
                    }
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        });
    }

    @Override
    protected void refreshEnablement(Button button) {
        button.setEnabled(this.destinationBranchNotCommitted() && this.isWidgetAllowedInCurrentState());
    }

    private boolean destinationBranchNotCommitted() {
        boolean toReturn = false;
        try {
            if (this.isWorkingBranchCommitWithMergeInProgress()) {
                List mergeBranches = BranchManager.getMergeBranches((BranchId)this.getWorkingBranch());
                Collection committedBranches = AtsApiService.get().getBranchService().getBranchesCommittedTo((IAtsTeamWorkflow)this.getTeamArt());
                ArrayList<MergeBranch> remainingMergeBranches = new ArrayList<MergeBranch>();
                for (MergeBranch mergeBranch : mergeBranches) {
                    if (committedBranches.contains(mergeBranch.getDestinationBranch())) continue;
                    remainingMergeBranches.add(mergeBranch);
                }
                if (!remainingMergeBranches.isEmpty()) {
                    toReturn = true;
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return toReturn;
    }

    @Override
    protected boolean isWidgetAllowedInCurrentState() {
        return this.isWidgetInState(WIDGET_NAME);
    }

    public List<? extends ITopicEventFilter> getTopicEventFilters() {
        return null;
    }
}

