/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.Date;
import java.util.logging.Level;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.program.IAtsProgramManager;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.XButtonWithLabelDam;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class XValidateReqChangesButton
extends XButtonWithLabelDam {
    private IAtsTeamWorkflow teamWf;
    private IAtsProgramManager programMgr;
    private final XModifiedListener listener = new XModifiedListener(){

        public void widgetModified(XWidget widget) {
            XValidateReqChangesButton.this.handleSelection(true);
        }
    };

    public XValidateReqChangesButton() {
        super("Validate Requirement Changes", "Click to validate requirement changes", ImageManager.getImage((OseeImage)AtsImage.PLAY_GREEN));
        this.addXModifiedListener(this.listener);
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        super.createControls(parent, horizontalSpan);
        this.getLabelWidget().addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 3) {
                    XValidateReqChangesButton.this.handleSelection(false);
                }
            }
        });
    }

    protected String getResultsText() {
        Date ranDate = (Date)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)this.teamWf, (AttributeTypeToken)AtsAttributeTypes.ValidateChangesRanDate, null);
        if (ranDate != null) {
            AtsUser user = AtsApiService.get().getUserService().getUserByUserId((String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)this.teamWf, (AttributeTypeToken)AtsAttributeTypes.ValidateChangesRanBy, (Object)AtsCoreUsers.UNASSIGNED_USER.getUserId()));
            this.labelWidget.setForeground(Displays.getSystemColor((int)2));
            return String.format("ran by %s on %s", user.getName(), DateUtil.getDateNow((Date)ranDate, (String)"MM/dd/yyyy hh:mm a"));
        }
        this.resultsLabelWidget.setForeground(Displays.getSystemColor((int)3));
        return "Not Yet Run";
    }

    private void handleSelection(final boolean logRun) {
        try {
            boolean editable;
            this.programMgr = AtsApiService.get().getProgramService().getProgramManager(this.teamWf);
            if (this.programMgr == null) {
                AWorkbench.popup((String)"Workflow Not Configured", (String)"Team Workflow\n\n%s\n\nnot configured for\n\nValidate Requirement Changes ", (Object[])new Object[]{this.teamWf.toStringWithId()});
                return;
            }
            boolean bl = editable = AtsApiService.get().getBranchService().isWorkingBranchInWork(this.teamWf) || AtsApiService.get().getBranchService().isCommittedBranchExists(this.teamWf);
            if (!editable) {
                AWorkbench.popup((String)"No branch or commit to run against.");
                return;
            }
            Object[] objectArray = new Object[1];
            Object object = objectArray[0] = logRun ? "" : "\n\n(Report Only)";
            if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Validate Requirement Changes", (String)String.format("Run programatic checks against Requirement changes?%s", objectArray))) {
                return;
            }
            IOperation operation = this.programMgr.createValidateReqChangesOp(this.teamWf);
            Operations.executeAsJob((IOperation)operation, (boolean)true, (int)30, (IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (logRun) {
                        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Log Validate Changes Run");
                        changes.setSoleAttributeValue((IAtsWorkItem)XValidateReqChangesButton.this.teamWf, (AttributeTypeToken)AtsAttributeTypes.ValidateChangesRanBy, AtsApiService.get().getUserService().getCurrentUserId());
                        changes.setSoleAttributeValue((IAtsObject)XValidateReqChangesButton.this.teamWf, (AttributeTypeToken)AtsAttributeTypes.ValidateChangesRanDate, (Object)new Date());
                        changes.execute();
                    }
                }
            });
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public TeamWorkFlowArtifact getArtifact() {
        return (TeamWorkFlowArtifact)super.getArtifact();
    }

    public boolean isEditable() {
        return this.teamWf != null;
    }

    public void setArtifact(Artifact artifact) {
        super.setArtifact(artifact);
        if (artifact instanceof TeamWorkFlowArtifact) {
            this.teamWf = (TeamWorkFlowArtifact)artifact;
        }
    }

    public boolean isDisposed() {
        return !Widgets.isAccessible((Widget)this.labelWidget);
    }
}

