/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlinkChangeTypeSelection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.AttributeWidget;
import org.eclipse.osee.framework.ui.swt.Widgets;

public class XHyperlinkChangeTypeSelectionDam
extends XHyperlinkChangeTypeSelection
implements AttributeWidget {
    public static final String WIDGET_ID = XHyperlinkChangeTypeSelectionDam.class.getSimpleName();
    protected Artifact artifact;
    protected AttributeTypeToken attributeType = AtsAttributeTypes.ChangeType;
    public static String NOT_SET = Widgets.NOT_SET;

    public XHyperlinkChangeTypeSelectionDam() {
        this("");
    }

    public XHyperlinkChangeTypeSelectionDam(String label) {
        super(label);
    }

    public XHyperlinkChangeTypeSelectionDam(String label, ChangeTypes ... changeTypes) {
        super(label, changeTypes);
    }

    @Override
    protected void handleSelected(ChangeTypes selected) {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Set Change Type");
        if (selected == null || selected == ChangeTypes.None) {
            changes.deleteAttributes((ArtifactId)this.artifact, this.attributeType);
        } else {
            changes.setSoleAttributeValue((ArtifactId)this.artifact, this.attributeType, (Object)selected.name());
        }
        changes.executeIfNeeded();
        super.handleSelected(selected);
    }

    @Override
    protected List<ChangeTypes> getChangeTypes() {
        if (this.changeTypes != null && !this.changeTypes.isEmpty()) {
            return this.changeTypes;
        }
        List options = AtsApiService.get().getWorkItemService().getChangeTypeOptions((IAtsObject)((IAtsTeamWorkflow)this.artifact));
        return options;
    }

    @Override
    public String getCurrentValue() {
        String value = this.artifact.getAttributesToString((AttributeTypeId)this.attributeType);
        if (Strings.isInValid((String)value)) {
            value = NOT_SET;
        }
        return value;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void saveToArtifact() {
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void setAttributeType(Artifact artifact, AttributeTypeToken attributeType) {
        this.artifact = artifact;
    }

    public AttributeTypeToken getAttributeType() {
        return this.attributeType;
    }

    @Override
    public IStatus isValid() {
        IStatus status = Status.OK_STATUS;
        try {
            if (this.getArtifact() != null && this.getAttributeType() != null) {
                String currValue = this.getCurrentValue();
                if (NOT_SET.equals(currValue)) {
                    currValue = "";
                }
                if (this.isRequiredEntry() && Strings.isInValid((String)currValue)) {
                    status = new Status(4, "org.eclipse.osee.framework.ui.skynet", String.format("Must select [%s]", this.getAttributeType().getUnqualifiedName()));
                }
            }
        }
        catch (OseeCoreException ex) {
            status = new Status(4, "org.eclipse.osee.framework.ui.skynet", "Error getting Artifact", (Throwable)ex);
        }
        return status;
    }
}

