/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.ServiceUtil;
import org.eclipse.osee.framework.core.data.ApplicabilityData;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelCmdValueSelection;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelValueSelection;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.ViewApplicabilityTokenFilterTreeDialog;
import org.eclipse.osee.orcs.rest.model.ApplicabilityEndpoint;

public class XHyperlabelWorkflowApplicabilitySelection
extends XHyperlinkLabelCmdValueSelection
implements ArtifactWidget {
    public List<ApplicabilityToken> selectedAppls;
    private IAtsWorkItem workItem;

    public XHyperlabelWorkflowApplicabilitySelection() {
        super("Referenced Applicabilities", true, Integer.valueOf(80));
    }

    public List<ApplicabilityToken> getSelectedApplicabilities() {
        return this.selectedAppls;
    }

    public Object getData() {
        return this.getSelectedApplicabilities();
    }

    public String getCurrentValue() {
        if (this.selectedAppls == null) {
            this.selectedAppls = this.getSelectedApplicabilities();
        }
        return Collections.toString((String)",", this.selectedAppls);
    }

    public boolean handleClear() {
        this.selectedAppls.clear();
        this.notifyXModifiedListeners();
        return true;
    }

    public boolean handleSelection() {
        try {
            IAtsTeamWorkflow teamWorkflow = this.workItem.getParentTeamWorkflow();
            if (teamWorkflow == null) {
                AWorkbench.popup((String)"No valid parent Team Workflow found");
            }
            if (teamWorkflow != null) {
                BranchId branch = AtsApiService.get().getBranchService().getConfiguredBranchForWorkflow(teamWorkflow);
                ApplicabilityEndpoint applEndpoint = ServiceUtil.getOseeClient().getApplicabilityEndpoint(branch);
                Collection applicabilityTokens = applEndpoint.getApplicabilityTokens();
                ViewApplicabilityTokenFilterTreeDialog dialog = new ViewApplicabilityTokenFilterTreeDialog("Select View Applicability", "Select View Applicability");
                dialog.setInput((Object)applicabilityTokens);
                dialog.setMultiSelect(true);
                int result = dialog.open();
                if (result == 0) {
                    this.selectedAppls = Collections.castAll((Collection)dialog.getSelected());
                    return true;
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.selectedAppls.isEmpty();
    }

    public Artifact getArtifact() {
        return AtsApiService.get().getQueryServiceIde().getArtifact(this.workItem);
    }

    public void saveToArtifact() {
        if (this.isDirty().isTrue()) {
            LinkedList<ApplicabilityData> appDatas = new LinkedList<ApplicabilityData>();
            ApplicabilityData data = new ApplicabilityData();
            data.setArtifact(ArtifactId.create((Id)this.workItem.getStoreObject()));
            data.setApplIds(Collections.castAll(this.selectedAppls));
            appDatas.add(data);
            AtsApiService.get().getOseeClient().getApplicabilityEndpoint((BranchId)AtsApiService.get().getAtsBranch()).setApplicabilityReference(appDatas);
        }
    }

    public void revert() {
        this.selectedAppls = this.getStoredApplicabilities();
    }

    private List<ApplicabilityToken> getStoredApplicabilities() {
        ArrayList<ApplicabilityToken> tokens = new ArrayList<ApplicabilityToken>();
        try {
            BranchToken branch = AtsApiService.get().getAtsBranch();
            ApplicabilityEndpoint applicEndpoint = AtsApiService.get().getOseeClient().getApplicabilityEndpoint((BranchId)branch);
            List applicTokens = applicEndpoint.getApplicabilityReferenceTokens(this.workItem.getArtifactId());
            for (ApplicabilityToken tok : applicTokens) {
                if (!tok.isValid()) continue;
                tokens.add(tok);
            }
        }
        catch (Exception ex) {
            OseeLog.log(XHyperlinkLabelValueSelection.class, (Level)Level.SEVERE, (String)String.format("Exception getting applicability for workItem %s", this.workItem.toStringWithId()), (Throwable)ex);
        }
        return tokens;
    }

    public Result isDirty() {
        if (!Collections.isEqual(this.getStoredApplicabilities(), this.getSelectedApplicabilities())) {
            return Result.TrueResult;
        }
        return Result.FalseResult;
    }

    public void setArtifact(Artifact artifact) {
        if (artifact instanceof IAtsWorkItem) {
            this.workItem = (IAtsWorkItem)artifact;
            this.selectedAppls = this.getStoredApplicabilities();
        }
    }
}

