/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsStoreService;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.workflow.WorkItem;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.internal.AtsChangeSet;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;
import org.eclipse.osee.framework.skynet.core.utility.OseeInfo;
import org.eclipse.osee.jdbc.JdbcService;

public class AtsStoreService
implements IAtsStoreService {
    private final IAtsUserService userService;
    private final JdbcService jdbcService;
    public final AtsApi atsApi;

    public AtsStoreService(AtsApi atsApi, IAtsUserService userService, JdbcService jdbcService) {
        this.atsApi = atsApi;
        this.userService = userService;
        this.jdbcService = jdbcService;
    }

    public JdbcService getJdbcService() {
        return this.jdbcService;
    }

    public IAtsChangeSet createAtsChangeSet(String comment, AtsUser asUser) {
        return new AtsChangeSet(comment, this.atsApi.getAtsBranch(), asUser);
    }

    public List<IAtsWorkItem> reload(Collection<IAtsWorkItem> workItems) {
        ArrayList<IAtsWorkItem> results = new ArrayList<IAtsWorkItem>();
        try {
            LinkedList<Artifact> artifacts = new LinkedList<Artifact>();
            for (IAtsWorkItem workItem : workItems) {
                if (workItem.getStoreObject() == null || !(workItem.getStoreObject() instanceof Artifact)) continue;
                artifacts.add((Artifact)this.atsApi.getQueryService().getArtifact((IAtsObject)workItem));
            }
            for (Artifact art : ArtifactQuery.reloadArtifacts(artifacts)) {
                IAtsWorkItem workItem;
                if (art.isDeleted() || (workItem = this.atsApi.getWorkItemService().getWorkItem((ArtifactToken)art)) == null) continue;
                results.add(workItem);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return results;
    }

    public boolean isDeleted(IAtsObject atsObject) {
        if (atsObject.getStoreObject() instanceof Artifact) {
            return ((Artifact)atsObject.getStoreObject()).isDeleted();
        }
        Artifact art = (Artifact)this.atsApi.getQueryService().getArtifact(atsObject);
        if (art != null) {
            return art.isDeleted();
        }
        return true;
    }

    public boolean isAttributeTypeValid(IAtsObject atsObject, AttributeTypeToken attributeType) {
        return this.isAttributeTypeValid((ArtifactId)this.atsApi.getQueryService().getArtifact(atsObject), attributeType);
    }

    public boolean isAttributeTypeValid(ArtifactId artifact, AttributeTypeToken attributeType) {
        return this.atsApi.getQueryService().getArtifact(artifact).isAttributeTypeValid((AttributeTypeId)attributeType);
    }

    public ArtifactTypeToken getArtifactType(ArtifactId artifact) {
        if (artifact instanceof Artifact) {
            return this.atsApi.getQueryService().getArtifact(artifact).getArtifactType();
        }
        return ArtifactQuery.getArtifactFromId((ArtifactId)artifact, (BranchId)this.atsApi.getAtsBranch(), (DeletionFlag)DeletionFlag.INCLUDE_DELETED).getArtifactType();
    }

    public ArtifactTypeToken getArtifactType(ArtifactId artifact, BranchId branch) {
        if (artifact instanceof Artifact) {
            return this.atsApi.getQueryService().getArtifact(artifact, branch).getArtifactType();
        }
        return ArtifactQuery.getArtifactFromId((ArtifactId)artifact, (BranchId)branch, (DeletionFlag)DeletionFlag.INCLUDE_DELETED).getArtifactType();
    }

    public void executeChangeSet(String comment, IAtsObject atsObject) {
        this.executeChangeSet(comment, Collections.singleton(atsObject));
    }

    public void executeChangeSet(String comment, Collection<? extends IAtsObject> atsObjects) {
        IAtsChangeSet changes = this.createAtsChangeSet(comment, this.userService.getCurrentUser());
        for (IAtsObject iAtsObject : atsObjects) {
            changes.add((Object)iAtsObject);
        }
        changes.execute();
    }

    public Collection<AttributeTypeGeneric<?>> getAttributeTypes() {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)AttributeTypeManager.getAllTypes());
    }

    public boolean isChangedInDb(IAtsWorkItem workItem) {
        return ArtifactQuery.isArtifactChangedViaTransaction((Artifact)((Artifact)this.atsApi.getQueryService().getArtifact((IAtsObject)workItem)));
    }

    public boolean isChangedInDb(ArtifactId artifact) {
        return ArtifactQuery.isArtifactChangedViaTransaction((Artifact)((Artifact)this.atsApi.getQueryService().getArtifact(artifact)));
    }

    public ArtifactTypeToken getArtifactType(IAtsObject atsObject) {
        return this.getArtifactType((ArtifactId)this.atsApi.getQueryService().getArtifact(atsObject));
    }

    public Result setTransactionAssociatedArtifact(TransactionId trans, IAtsTeamWorkflow teamWf) {
        throw new UnsupportedOperationException();
    }

    public TransactionId getTransactionId(IAtsWorkItem workItem) {
        TransactionId transId = TransactionId.SENTINEL;
        ArtifactToken artifact = this.atsApi.getQueryService().getArtifact((ArtifactId)workItem.getStoreObject());
        if (artifact instanceof Artifact) {
            transId = ((Artifact)this.atsApi.getQueryService().getArtifact((ArtifactId)artifact)).getTransaction();
        }
        return transId;
    }

    public boolean isDeleted(ArtifactId artifact) {
        if (artifact instanceof Artifact) {
            return ((Artifact)artifact).isDeleted();
        }
        ArtifactToken art = this.atsApi.getQueryService().getArtifact(artifact);
        if (art != null) {
            return ((Artifact)this.atsApi.getQueryService().getArtifact((ArtifactId)art)).isDeleted();
        }
        return true;
    }

    public CustomizeData getCustomizationByGuid(String customize_guid) {
        CustomizeData cust = null;
        List customizeStoreArt = ArtifactQuery.getArtifactListFromAttributeKeywords((BranchId)this.atsApi.getAtsBranch(), (String)customize_guid, (boolean)false, (DeletionFlag)DeletionFlag.EXCLUDE_DELETED, (boolean)true, (AttributeTypeId[])new AttributeTypeId[]{CoreAttributeTypes.XViewerCustomization});
        if (!customizeStoreArt.isEmpty()) {
            for (String custXml : ((Artifact)customizeStoreArt.iterator().next()).getAttributesToStringList((AttributeTypeId)CoreAttributeTypes.XViewerCustomization)) {
                if (!custXml.contains(customize_guid)) continue;
                cust = new CustomizeData(custXml);
                break;
            }
        }
        return cust;
    }

    public boolean isProductionDb() {
        return ClientSessionManager.isProductionDataStore();
    }

    public boolean isHistorical(IAtsObject atsObject) {
        return ((Artifact)this.atsApi.getQueryService().getArtifact(atsObject)).isHistorical();
    }

    public boolean isHistorical(ArtifactId artifact) {
        return ((Artifact)this.atsApi.getQueryService().getArtifact(artifact)).isHistorical();
    }

    public void clearCaches(IAtsWorkItem workItem) {
        ((WorkItem)workItem).clearCaches();
        ((AbstractWorkflowArtifact)workItem.getStoreObject()).clearCaches();
    }

    public boolean isReadOnly(IAtsWorkItem workItem) {
        return ((Artifact)workItem.getStoreObject()).isReadOnly();
    }

    public boolean isAccessControlWrite(IAtsWorkItem workItem) {
        return ((AbstractWorkflowArtifact)workItem.getStoreObject()).isAccessControlWrite();
    }

    public void reloadArts(Collection<ArtifactToken> artifacts) {
        ArtifactQuery.reloadArtifacts(artifacts);
    }

    public boolean isIdeClient() {
        return true;
    }

    public Collection<ArtifactToken> getDescendants(ArtifactToken art) {
        HashSet<ArtifactToken> arts = new HashSet<ArtifactToken>();
        Artifact artifact = null;
        artifact = art instanceof Artifact ? (Artifact)art : (Artifact)this.atsApi.getQueryService().getArtifact((ArtifactId)art);
        arts.add((ArtifactToken)artifact);
        for (Artifact child : artifact.getChildren()) {
            arts.addAll(this.getDescendants((ArtifactToken)child));
        }
        return arts;
    }

    public String getSafeName(ArtifactToken art) {
        String safeName = "Unknown";
        if (art.isInvalid()) {
            safeName = "Sentinal";
        } else if (art instanceof Artifact) {
            safeName = ((Artifact)art).getName();
        } else {
            Artifact artifact = (Artifact)this.atsApi.getQueryService().getArtifact((ArtifactId)art, (BranchId)this.atsApi.getAtsBranch(), DeletionFlag.INCLUDE_DELETED);
            if (artifact != null) {
                safeName = artifact.getName();
            }
        }
        return safeName;
    }

    public String getSafeName(ArtifactToken art, BranchId branch) {
        String safeName = "unknown";
        if (art.isInvalid()) {
            safeName = "Sentinal";
        } else if (art instanceof Artifact) {
            safeName = ((Artifact)art).getName();
        } else {
            if (branch.isInvalid()) {
                throw new OseeArgumentException("Can't determine branch from art [%s]", new Object[]{art.toStringWithId()});
            }
            safeName = ((Artifact)this.atsApi.getQueryService().getArtifact((ArtifactId)art, branch, DeletionFlag.INCLUDE_DELETED)).getSafeName();
        }
        return safeName;
    }

    public IAtsChangeSet createAtsChangeSet(String comment, BranchToken branch, AtsUser asUser) {
        return new AtsChangeSet(comment, branch, asUser);
    }

    public boolean isOfType(ArtifactId art, ArtifactTypeToken artType) {
        BranchToken branch;
        Artifact artifact = null;
        if (art instanceof ArtifactToken && (branch = ((ArtifactToken)art).getBranch()).isValid()) {
            artifact = (Artifact)this.atsApi.getQueryService().getArtifact(art, (BranchId)branch);
        }
        if (artifact == null) {
            artifact = (Artifact)this.atsApi.getQueryService().getArtifact(art);
        }
        return artifact.isOfType(new ArtifactTypeId[]{artType});
    }

    public XResultData clearAtsCachesAllServers() {
        XResultData rd = new XResultData();
        rd.log("Update Ats Caches All Servers");
        String serversStr = OseeInfo.getValue((String)"osee.health.servers");
        ArrayList<String> servers = new ArrayList<String>();
        serversStr = serversStr.replaceAll(" ", "");
        String[] stringArray = serversStr.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String server = stringArray[n2];
            servers.add(server);
            ++n2;
        }
        if (servers.isEmpty()) {
            rd.logf("No %s configured.  ATS cache is not updated.  ", new Object[]{"osee.health.servers"});
        } else {
            rd.log("\n");
            for (String server : servers) {
                this.atsApi.getServerEndpoints().getConfigEndpoint().requestCacheReload();
                try {
                    WebTarget target = AtsApiService.get().jaxRsApi().newTargetUrl(String.format("http://%s%s", server, "/ats/config/clearcache"));
                    Response response = target.request().get();
                    if (response.getStatus() == 200 || response.getStatus() == 202) {
                        rd.logf("ATS server %s cache update was successful.\n", new Object[]{server});
                        continue;
                    }
                    rd.logf("ERROR: ATS server %s cache update was not successful.\n", new Object[]{server});
                }
                catch (Exception ex) {
                    rd.logf("ERROR: ATS server %s cache update exception %s.\n", new Object[]{server, ex.getLocalizedMessage()});
                }
            }
        }
        return rd;
    }
}

