/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util;

import java.util.Date;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.AtsOpenOption;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Shell;

public class CreateActionUsingAllActionableItems
extends XNavigateItemAction {
    public CreateActionUsingAllActionableItems(XNavItemCat ... xNavItemCat) {
        super("Create Action Using All Actionable Items - Admin", (KeyedImage)PluginUiImage.ADMIN, xNavItemCat);
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)this.getName(), (String)this.getName())) {
            return;
        }
        try {
            ActionResult action = CreateActionUsingAllActionableItems.createActionWithAllAis();
            int numWfs = action.getTeamWfs().size();
            if (numWfs > 30) {
                AWorkbench.popup((String)(String.valueOf(numWfs) + " Workflows were created.  Only opening one."));
                AtsEditors.openATSAction(((IAtsTeamWorkflow)action.getTeamWfs().iterator().next()).getStoreObject(), AtsOpenOption.OpenOneOrPopupSelect);
            } else {
                AWorkbench.popup((String)"Completed", (String)"Completed");
                AtsEditors.openATSAction(action.getAction().getStoreObject(), AtsOpenOption.OpenAll);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public static ActionResult createActionWithAllAis() {
        AtsApiService.get().reloadServerAndClientCaches();
        HashSet<IAtsActionableItem> aias = new HashSet<IAtsActionableItem>();
        for (IAtsActionableItem aia : AtsApiService.get().getConfigService().getConfigurations().getIdToAi().values()) {
            if (!aia.isActionable() || !aia.isAllowUserActionCreation()) continue;
            aias.add(aia);
        }
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Create Action using all AIs");
        ActionResult action = AtsApiService.get().getActionService().createAction(null, "Big Action Test - Delete Me", "Description", ChangeTypes.Improvement, "1", false, null, aias, new Date(), AtsApiService.get().getUserService().getCurrentUser(), null, changes);
        changes.execute();
        return action;
    }
}

