/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.navigate;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.search.navigate.SavedActionSearchNavigateItem;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class ImportSavedSearchNavigateItem
extends XNavigateItem {
    AtsApi atsApi = AtsApiService.get();

    public ImportSavedSearchNavigateItem() {
        super("Import Saved Search", (KeyedImage)FrameworkImage.IMPORT, new XNavItemCat[]{SavedActionSearchNavigateItem.SAVED_ACTION_SEARCHES});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) throws Exception {
        EntryDialog dialog = new EntryDialog(this.getName(), "Paste Saved Search json");
        dialog.setFillVertically(true);
        try {
            if (dialog.open() == 0) {
                String json = dialog.getEntry();
                AtsSearchData data = this.atsApi.getSearchDataProvider("ats.search").fromJson("ats.search", json);
                if (data != null) {
                    data.setId(Lib.generateArtifactIdAsInt().longValue());
                    AtsApiService.get().getQueryService().saveSearch(data);
                    SavedActionSearchNavigateItem.refreshItems();
                    AWorkbench.popupf((String)"Search [%s] Saved", (Object[])new Object[]{data.getSearchName()});
                }
            }
        }
        catch (Exception ex) {
            ResultsEditor.open((String)this.getName(), (String)(String.valueOf(this.getName()) + " - Error"), (String)("Error importing saved search: " + Lib.exceptionToString((Exception)ex)));
        }
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Arrays.asList(CoreUserGroups.Everyone);
    }
}

