/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search;

import java.io.File;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.search.AtsSearchWorkflowSearchItem;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.program.Program;

public final class ShowSearchItemAction
extends Action {
    private final AtsSearchWorkflowSearchItem searchItem;
    private final AtsApi atsApi;

    public ShowSearchItemAction(AtsSearchWorkflowSearchItem searchItem) {
        this.searchItem = searchItem;
        this.atsApi = AtsApiService.get();
    }

    public String getText() {
        return "Show Search Item";
    }

    public String getToolTipText() {
        return "Select to show Search Item json";
    }

    public void run() {
        AtsSearchData data = AtsApiService.get().getQueryService().createSearchData(this.searchItem.getNamespace(), this.searchItem.getSearchName());
        this.searchItem.loadSearchData(data);
        String json = AtsApiService.get().jaxRsApi().toJson((Object)data);
        ResultsEditor.open((String)"json", (String)String.format("Search Item [%s]", data.getSearchName()), (String)json);
        if (this.atsApi.getUserService().isAtsAdmin()) {
            File file = OseeData.getFile((String)"SearchItem.json");
            try {
                Lib.writeStringToFile((String)json, (File)file);
                Program.launch((String)file.getAbsolutePath());
            }
            catch (IOException iOException) {}
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.QUESTION);
    }
}

