/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.program;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.program.IAtsProgramManager;
import org.eclipse.osee.ats.api.rule.validation.AbstractValidationRule;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.program.DemoCreateValidationRulesOperation;
import org.eclipse.osee.ats.ide.util.validate.ArtifactValidationRule;
import org.eclipse.osee.ats.ide.util.validate.ValidationReportOperation;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.OperationBuilder;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.Manipulations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;

public class DemoProgramManager
implements IAtsProgramManager {
    public static String NAME = "Demo";
    private static DemoProgramManager instance = new DemoProgramManager();

    public static DemoProgramManager instance() {
        return instance;
    }

    public boolean isApplicable(IAtsTeamWorkflow teamWf) {
        return teamWf.getArtifactType().getName().startsWith("Demo ");
    }

    public IOperation createValidateReqChangesOp(IAtsTeamWorkflow teamWf) {
        IOperation toReturn = Operations.getNoOpOperation();
        if (this.isApplicable(teamWf)) {
            IAtsProgram program = AtsApiService.get().getProgramService().getProgram((IAtsWorkItem)teamWf);
            final XResultData rd = new XResultData();
            if (program != null) {
                AbstractOperation createReport = new AbstractOperation("Create Validate Rules Report", "org.eclipse.osee.ats.ide"){

                    protected void doWork(IProgressMonitor monitor) throws Exception {
                        XResultDataUI.report((XResultData)rd, (String)"Demo Program Requirements Validation", (Manipulations[])new Manipulations[]{Manipulations.CONVERT_NEWLINES, Manipulations.ERROR_RED, Manipulations.ERROR_WARNING_FROM_SEARCH, Manipulations.ERROR_WARNING_HEADER, Manipulations.WARNING_YELLOW});
                    }
                };
                IOperation ops = DemoProgramManager.createValidationOperation(teamWf, rd);
                toReturn = Operations.createBuilder((String)"Validation Report", (IOperation)ops, (IOperation[])new IOperation[]{createReport}).build();
            }
        }
        return toReturn;
    }

    public static final IOperation createValidationOperation(IAtsTeamWorkflow teamWf, XResultData rd) {
        HashSet<AbstractValidationRule> rules = new HashSet<AbstractValidationRule>();
        rules.add(new ArtifactValidationRule(AtsApiService.get()));
        IOperation operationCollectRules = DemoProgramManager.createValidationRulesOperation((TeamWorkFlowArtifact)teamWf, rd, rules);
        ValidationReportOperation validationOperation = new ValidationReportOperation(rd, (TeamWorkFlowArtifact)teamWf, rules);
        OperationBuilder builder = Operations.createBuilder((String)"Requirement Change Validation Report - ", (IOperation)operationCollectRules, (IOperation[])new IOperation[]{validationOperation});
        return builder.build();
    }

    private static IOperation createValidationRulesOperation(TeamWorkFlowArtifact teamArt, XResultData results, Set<AbstractValidationRule> rules) {
        return new DemoCreateValidationRulesOperation(results, teamArt, rules, AtsApiService.get().getProgramService().getWorkType((IAtsTeamWorkflow)teamArt));
    }

    public String getName() {
        return NAME;
    }
}

