/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.operation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.operation.DetailedTestStatusOld;
import org.eclipse.osee.ats.ide.util.XVersionList;
import org.eclipse.osee.ats.ide.util.widgets.XAtsProgramComboWidget;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.define.ide.traceability.report.RequirementStatus;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.OteArtifactTypes;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.CharBackedInputStream;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.AIFile;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.widgets.XBranchSelectWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.ote.define.artifacts.ArtifactTestRunOperator;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DetailedTestStatusBlam
extends AbstractBlam {
    private static final Pattern taskNamePattern = Pattern.compile("(?:\"([^\"]+)\")? for \"([^\"]+)\"");
    private final Matcher taskNameMatcher = taskNamePattern.matcher("");
    private CharBackedInputStream charBak;
    private ISheetWriter excelWriter;
    private CompositeKeyHashMap<String, String, RequirementStatus> reqTaskMap;
    private StringBuilder sumFormula;
    private HashCollection<String, AtsUser> legacyIdToImplementers;
    private HashMap<String, Artifact> testRunArtifacts;
    private HashMap<String, String> scriptCategories;
    private HashSet<AtsUser> testPocs;
    private HashSet<String> requirementPocs;
    private ArrayList<String[]> statusLines;
    private ArrayList<RequirementStatus> statuses;
    private Collection<IAtsVersion> versions;
    private HashCollectionSet<String, Artifact> requirementNameToTestProcedures;
    private XBranchSelectWidget reportBranchWidget;
    private XVersionList versionsListViewer;
    private BranchToken selectedBranch;
    private IAtsProgram selectedProgram;
    private final BranchChangeListener branchSelectionListener = new BranchChangeListener();

    private String getScriptName(String scriptPath) {
        String scriptName = scriptPath;
        int endOfPackageName = scriptName.lastIndexOf(".");
        if (endOfPackageName != -1) {
            scriptName = String.valueOf(scriptName.substring(endOfPackageName + 1)) + ".java";
        }
        return scriptName.substring(scriptName.lastIndexOf(File.separatorChar) + 1, scriptName.length() - ".java".length());
    }

    private void loadTestRunArtifacts(BranchId scriptsBranch, IProgressMonitor monitor) {
        monitor.subTask("Loading Test Run Artifacts");
        List testRuns = ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)OteArtifactTypes.TestRun, (BranchId)scriptsBranch, (DeletionFlag)DeletionFlag.EXCLUDE_DELETED);
        double increment = 100.0 / (double)testRuns.size();
        double progress = 0.0;
        for (Artifact testRun : testRuns) {
            monitor.worked((int)Math.min(1.0, progress += increment));
            if (progress > 1.0) {
                progress = 0.0;
            }
            String shortName = testRun.getName();
            Artifact previousTestRun = this.testRunArtifacts.put(shortName = shortName.substring(shortName.lastIndexOf(46) + 1), testRun);
            if (previousTestRun == null) continue;
            Date date = new ArtifactTestRunOperator(testRun).getEndDate();
            Date previousDate = new ArtifactTestRunOperator(previousTestRun).getEndDate();
            if (!previousDate.after(date)) continue;
            this.testRunArtifacts.put(shortName, previousTestRun);
        }
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        if (!this.blamReadyToExecute()) {
            monitor.setCanceled(true);
            return;
        }
        BranchId reportBranch = variableMap.getBranch("Requirements Branch");
        BranchId resultsBranch = variableMap.getBranch("Test Results Branch");
        this.versions = variableMap.getCollection(IAtsVersion.class, "Versions");
        this.reqTaskMap = new CompositeKeyHashMap();
        this.legacyIdToImplementers = new HashCollection();
        this.testRunArtifacts = new HashMap();
        this.scriptCategories = new HashMap();
        this.testPocs = new HashSet();
        this.requirementPocs = new HashSet();
        this.statusLines = new ArrayList();
        this.statuses = new ArrayList(100);
        this.charBak = new CharBackedInputStream();
        this.excelWriter = new ExcelXmlWriter(this.charBak.getWriter());
        this.sumFormula = new StringBuilder();
        monitor.beginTask("Detailed Test Status", 500);
        this.loadTestRunArtifacts(resultsBranch, monitor);
        this.requirementNameToTestProcedures = this.getTestProcedureTraceability(reportBranch, monitor);
        this.loadReqTaskMap(monitor);
        List allSwReqs = ArtifactQuery.getArtifactListFromTypeWithInheritence((ArtifactTypeToken)CoreArtifactTypes.AbstractSoftwareRequirement, (BranchId)reportBranch, (DeletionFlag)DeletionFlag.EXCLUDE_DELETED);
        allSwReqs.addAll(ArtifactQuery.getArtifactListFromTypeWithInheritence((ArtifactTypeToken)CoreArtifactTypes.AbstractImplementationDetails, (BranchId)reportBranch, (DeletionFlag)DeletionFlag.EXCLUDE_DELETED));
        this.writeStatusSheet(allSwReqs, monitor);
        this.reqTaskMap = null;
        this.legacyIdToImplementers = null;
        this.versions = null;
        this.requirementNameToTestProcedures = null;
        this.testPocs = null;
        this.requirementPocs = null;
        this.statusLines = null;
        this.statuses = null;
        this.versions = null;
        List testCases = ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.TestCase, (BranchId)reportBranch);
        this.writeTestScriptSheet(testCases, monitor);
        this.testRunArtifacts = null;
        this.scriptCategories = null;
        this.excelWriter.endWorkbook();
        IFile iFile = OseeData.getIFile((String)("Detailed_Test_Status_" + Lib.getDateTimeString() + ".xml"));
        AIFile.writeToFile((IFile)iFile, (InputStream)this.charBak);
        Program.launch((String)iFile.getLocation().toOSString());
    }

    private boolean blamReadyToExecute() {
        boolean ready;
        final ArrayList<String> items = new ArrayList<String>();
        if (this.selectedProgram == null) {
            items.add("program");
        }
        if (this.selectedBranch == null) {
            items.add("branch");
        }
        if (!(ready = items.isEmpty())) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)Displays.getActiveShell(), (String)"Problem", (String)String.format("Select a %s ...", Strings.buildStatment((List)items)));
                }
            });
        }
        return ready;
    }

    private void writeTestScriptSheet(List<Artifact> testCases, IProgressMonitor monitor) throws IOException {
        monitor.subTask("Writing test script sheet");
        this.excelWriter.startSheet("Scripts", 8);
        this.excelWriter.writeRow(new Object[]{"Category", CoreArtifactTypes.TestCase.getName(), "Run Date", "Total Test Points", "Failed Test Points", "Duration", "Aborted", "Last Author"});
        double increment = 100.0 / (double)testCases.size();
        double progress = 0.0;
        for (Artifact testCase : testCases) {
            monitor.worked((int)Math.min(1.0, progress += increment));
            if (progress > 1.0) {
                progress = 0.0;
            }
            String scriptPath = testCase.getName();
            String scriptName = this.getScriptName(scriptPath);
            Artifact testRunArtifact = this.testRunArtifacts.get(scriptName);
            String totalTestPoints = null;
            String failedTestPoints = null;
            String category = this.scriptCategories.get(scriptPath);
            String runDate = null;
            String duration = null;
            String aborated = null;
            String lastAuthor = null;
            if (testRunArtifact != null) {
                ArtifactTestRunOperator runOperator = new ArtifactTestRunOperator(testRunArtifact);
                try {
                    runDate = DetailedTestStatusOld.getDateFormatter().format(runOperator.getEndDate());
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
                totalTestPoints = String.valueOf(runOperator.getTotalTestPoints());
                failedTestPoints = String.valueOf(runOperator.getTestPointsFailed());
                duration = runOperator.getRunDuration();
                aborated = runOperator.wasAborted() ? "aborted" : null;
                lastAuthor = runOperator.getLastAuthor();
            }
            this.excelWriter.writeRow(new Object[]{category, scriptName, runDate, totalTestPoints, failedTestPoints, duration, aborated, lastAuthor});
        }
        this.excelWriter.endSheet();
    }

    private void writeStatusSheet(Collection<Artifact> requirements, IProgressMonitor monitor) throws IOException {
        monitor.subTask("Writing status sheet");
        this.excelWriter.startSheet("SW Req Status", 256);
        this.excelWriter.writeRow(new Object[]{null, null, null, null, "Hours per UI per RPCR", "=4"});
        this.excelWriter.writeRow(new Object[]{null, null, null, null, "Hours to integrate all scripts for a UI", "=11"});
        this.excelWriter.writeRow(new Object[]{null, null, null, null, "Hours to develop a new script", "=20"});
        this.excelWriter.writeRow(new Object[0]);
        this.excelWriter.writeRow(new Object[0]);
        this.excelWriter.writeRow(new Object[]{"Category", "Test POCs", CoreAttributeTypes.Partition.getName(), CoreAttributeTypes.Subsystem.getName(), "Requirement Name", CoreAttributeTypes.QualificationMethod.getName(), "Requirement POCs", "SW Enhancement", CoreArtifactTypes.TestProcedure.getName(), CoreArtifactTypes.TestCase.getName(), "Run Date", "Total Test Points", "Failed Test Points", "Hours Remaining", "RPCR", "Hours", "Resolution by Partition"});
        double increment = 100.0 / (double)requirements.size();
        double progress = 0.0;
        for (Artifact requirement : requirements) {
            monitor.worked((int)Math.min(1.0, progress += increment));
            if (progress > 1.0) {
                progress = 0.0;
            }
            this.writeRequirementStatusLines(requirement);
        }
        this.excelWriter.endSheet();
    }

    private void setScriptCategories(Artifact requirement, Collection<Artifact> scripts) {
        try {
            String reqCategory = (String)requirement.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Category, (Object)"");
            for (Artifact scriptPath : scripts) {
                String scriptCategory = this.scriptCategories.get(scriptPath.getName());
                if (scriptCategory != null && scriptCategory.compareTo(reqCategory) <= 0) continue;
                this.scriptCategories.put(scriptPath.getName(), reqCategory);
            }
        }
        catch (Exception exception) {}
    }

    private void processRpcrStatuses(Artifact requirement, String[] statusLine) {
        int columnIndex = Index.HOURS_REMAINING.ordinal() + 1;
        this.sumFormula.append(",");
        for (String requirementName : this.getAliases(requirement)) {
            List tempStatuses = this.reqTaskMap.getValues((Object)requirementName);
            if (tempStatuses == null) continue;
            this.statuses.clear();
            this.statuses.addAll(tempStatuses);
            Collections.sort(this.statuses);
            int i = this.statuses.size() - 1;
            while (i >= 0) {
                RequirementStatus status = this.statuses.get(i);
                statusLine[columnIndex++] = status.getLegacyId();
                statusLine[columnIndex++] = "=R1C6*(100-" + status.getRolledupPercentComplete() + ")/100";
                this.sumFormula.append("RC");
                this.sumFormula.append(columnIndex);
                this.sumFormula.append(",");
                statusLine[columnIndex++] = status.getPartitionStatuses();
                Collection implementers = this.legacyIdToImplementers.getValues((Object)status.getLegacyId());
                if (implementers != null) {
                    for (AtsUser implementer : implementers) {
                        this.requirementPocs.add(implementer.getName());
                    }
                }
                this.testPocs.addAll(status.getTestPocs());
                --i;
            }
        }
        this.sumFormula.setCharAt(this.sumFormula.length() - 1, ')');
    }

    private void processTestScriptsAndProcedures(Artifact requirement, String[] statusLine) {
        List scripts = requirement.getRelatedArtifacts(CoreRelationTypes.Verification_Verifier);
        if (scripts.isEmpty()) {
            if (requirement.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.IndirectSoftwareRequirementMsWord}) || requirement.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractImplementationDetails})) {
                statusLine[Index.TEST_SCRIPT.ordinal()] = requirement.getArtifactTypeName();
                this.sumFormula.insert(0, "=sum(0");
                statusLine[Index.HOURS_REMAINING.ordinal()] = this.sumFormula.toString();
            } else {
                statusLine[Index.TEST_SCRIPT.ordinal()] = "No script found";
                statusLine[Index.HOURS_REMAINING.ordinal()] = "=R3C6";
            }
            this.statusLines.add(statusLine);
        } else {
            this.setScriptCategories(requirement, scripts);
            int testPointTotalForScripts = 0;
            int testPointFailsForScripts = 0;
            for (Artifact script : scripts) {
                String scriptName;
                statusLine[Index.TEST_SCRIPT.ordinal()] = scriptName = this.getScriptName(script.getName());
                Artifact testRunArtifact = this.testRunArtifacts.get(scriptName);
                if (testRunArtifact != null) {
                    ArtifactTestRunOperator runOperator = new ArtifactTestRunOperator(testRunArtifact);
                    try {
                        statusLine[Index.RUN_DATE.ordinal()] = DetailedTestStatusOld.getDateFormatter().format(runOperator.getEndDate());
                    }
                    catch (Exception ex) {
                        this.log(ex);
                    }
                    if (runOperator.wasAborted()) {
                        statusLine[Index.TOTAL_TP.ordinal()] = "Aborted";
                        statusLine[Index.FAILED_TP.ordinal()] = "Aborted";
                    } else {
                        int individualTestPointsFailed = runOperator.getTestPointsFailed();
                        int individualTestPointTotal = runOperator.getTotalTestPoints();
                        statusLine[Index.TOTAL_TP.ordinal()] = String.valueOf(individualTestPointTotal);
                        statusLine[Index.FAILED_TP.ordinal()] = String.valueOf(individualTestPointsFailed);
                        testPointFailsForScripts += individualTestPointsFailed;
                        testPointTotalForScripts += individualTestPointTotal;
                    }
                }
                this.statusLines.add(statusLine);
                String[] oldStatusLine = statusLine;
                statusLine = new String[100];
                this.initStatusLine(oldStatusLine, statusLine);
            }
            String failRatio = "1";
            if (testPointTotalForScripts != 0) {
                failRatio = String.valueOf(testPointFailsForScripts) + "/" + testPointTotalForScripts;
            }
            this.sumFormula.insert(0, "=sum(R2C6*" + failRatio);
            this.statusLines.get((int)0)[Index.HOURS_REMAINING.ordinal()] = this.sumFormula.toString();
        }
        this.addTestProcedureNames(requirement.getName());
    }

    private void writeRequirementStatusLines(Artifact requirement) throws IOException {
        this.statusLines.clear();
        this.testPocs.clear();
        this.requirementPocs.clear();
        this.sumFormula.delete(0, 99999);
        String[] statusLine = new String[100];
        this.processRpcrStatuses(requirement, statusLine);
        statusLine[Index.Category.ordinal()] = (String)requirement.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Category, (Object)"");
        if (requirement.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.IndirectSoftwareRequirementMsWord}) || requirement.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractImplementationDetails})) {
            statusLine[Index.Category.ordinal()] = "I";
        }
        statusLine[Index.TEST_POC.ordinal()] = AtsObjects.toString((String)"; ", this.testPocs);
        statusLine[Index.PARTITION.ordinal()] = requirement.getAttributesToString((AttributeTypeId)CoreAttributeTypes.Partition);
        statusLine[Index.SUBSYSTEM.ordinal()] = (String)requirement.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)"");
        statusLine[Index.REQUIREMENT_NAME.ordinal()] = requirement.getName();
        statusLine[Index.QUALIFICATION_METHOD.ordinal()] = requirement.getAttributesToStringSorted((AttributeTypeId)CoreAttributeTypes.QualificationMethod);
        statusLine[Index.REQUIREMENT_POC.ordinal()] = org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", this.requirementPocs);
        List reqStats = this.reqTaskMap.getValues((Object)requirement.getName());
        statusLine[Index.SW_ENHANCEMENT.ordinal()] = reqStats.isEmpty() ? "" : ((RequirementStatus)reqStats.iterator().next()).getSwEnhancement();
        this.processTestScriptsAndProcedures(requirement, statusLine);
        for (Object[] objectArray : this.statusLines) {
            this.excelWriter.writeRow(objectArray);
        }
    }

    private HashCollectionSet<String, Artifact> getTestProcedureTraceability(BranchId testProcedureBranch, IProgressMonitor monitor) {
        monitor.subTask("Gathering test procedures");
        HashCollectionSet requirementNameToTestProcedures = new HashCollectionSet(HashSet::new);
        List tpReqs = ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.SoftwareRequirementMsWord, (BranchId)testProcedureBranch);
        double increment = 100.0 / (double)tpReqs.size();
        double progress = 0.0;
        for (Artifact tpRequirement : tpReqs) {
            monitor.worked((int)Math.min(1.0, progress += increment));
            if (progress > 1.0) {
                progress = 0.0;
            }
            HashSet foundProcedures = new HashSet(tpRequirement.getRelatedArtifacts(CoreRelationTypes.Validation_Validator));
            HashSet toAdd = new HashSet();
            toAdd = foundProcedures;
            requirementNameToTestProcedures.put((Object)tpRequirement.getName(), toAdd);
        }
        return requirementNameToTestProcedures;
    }

    private void addTestProcedureNames(String requirementName) {
        Collection testProcedures = this.requirementNameToTestProcedures.getValues((Object)requirementName);
        if (testProcedures != null) {
            int index = 0;
            String[] firstStatusLine = this.statusLines.get(index);
            String lastTestProcedure = null;
            for (Artifact testProcedure : testProcedures) {
                if (index < this.statusLines.size()) {
                    this.statusLines.get((int)index++)[Index.TEST_PROCEDURE.ordinal()] = testProcedure.getName();
                    lastTestProcedure = testProcedure.getName();
                    continue;
                }
                String[] statusLine = new String[Index.RUN_DATE.ordinal()];
                this.initStatusLine(firstStatusLine, statusLine);
                statusLine[Index.TEST_PROCEDURE.ordinal()] = testProcedure.getName();
                this.statusLines.add(statusLine);
            }
            while (index < this.statusLines.size()) {
                this.statusLines.get((int)index++)[Index.TEST_PROCEDURE.ordinal()] = lastTestProcedure;
            }
        }
    }

    private void initStatusLine(String[] oldStatusLine, String[] newStatusLine) {
        System.arraycopy(oldStatusLine, 0, newStatusLine, 0, Index.RUN_DATE.ordinal());
    }

    private void loadReqTaskMap(IProgressMonitor monitor) throws Exception {
        monitor.subTask("Loading tasks");
        for (IAtsVersion version : this.versions) {
            Collection targetedForTeamArtifacts = AtsApiService.get().getVersionService().getTargetedForTeamWorkflows(version);
            double increment = 100.0 / (double)targetedForTeamArtifacts.size();
            double progress = 0.0;
            for (IAtsTeamWorkflow workflow : targetedForTeamArtifacts) {
                monitor.worked((int)Math.min(1.0, progress += increment));
                if (progress > 1.0) {
                    progress = 0.0;
                }
                this.loadTasksFromWorkflow((TeamWorkFlowArtifact)workflow.getStoreObject());
            }
        }
    }

    public void widgetCreating(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        String widgetLabel = xWidget.getLabel();
        if (widgetLabel.equals("Versions")) {
            this.versionsListViewer = (XVersionList)xWidget;
        } else if (widgetLabel.equals("Requirements Branch")) {
            this.reportBranchWidget = (XBranchSelectWidget)xWidget;
        }
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        String widgetName = xWidget.getLabel();
        if (widgetName.equals("Program")) {
            XAtsProgramComboWidget programWidget = (XAtsProgramComboWidget)xWidget;
            programWidget.getComboViewer().addSelectionChangedListener((ISelectionChangedListener)new ProgramSelectionListener());
        }
    }

    private void loadTasksFromWorkflow(TeamWorkFlowArtifact workflow) {
        Collection tasks = AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)workflow);
        String legacyId = (String)workflow.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.LegacyPcrId, "");
        List<AtsUser> implementers = workflow.getImplementers();
        this.legacyIdToImplementers.put((Object)legacyId, implementers);
        for (IAtsTask task : tasks) {
            this.taskNameMatcher.reset(task.getName());
            if (!this.taskNameMatcher.find()) continue;
            String requirementName = this.taskNameMatcher.group(2);
            RequirementStatus requirementStatus = (RequirementStatus)this.reqTaskMap.get((Object)requirementName, (Object)legacyId);
            if (requirementStatus == null) {
                requirementStatus = new RequirementStatus(requirementName, legacyId, workflow.getSoleAttributeValueAsString((AttributeTypeToken)AtsAttributeTypes.SwEnhancement, ""));
                this.reqTaskMap.put((Object)requirementName, (Object)legacyId, (Object)requirementStatus);
            }
            int percentComplete = AtsApiService.get().getWorkItemMetricsService().getPercentCompleteTotal((IAtsObject)task);
            requirementStatus.addPartitionStatus(percentComplete, this.taskNameMatcher.group(1), task.getCurrentStateName());
            requirementStatus.setTestPocs((Collection)task.getImplementers());
        }
    }

    private Collection<String> getAliases(Artifact artifact) {
        return Named.getNames((Named[])new Named[]{artifact});
    }

    public String getXWidgetsXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<xWidgets>");
        sb.append("<XWidget xwidgetType=\"XAtsProgramComboWidget\" horizontalLabel=\"true\" displayName=\"Program\" />");
        sb.append("<XWidget xwidgetType=\"XVersionList\" displayName=\"Versions\" multiSelect=\"true\" />");
        sb.append("<XWidget xwidgetType=\"XBranchSelectWidget\" displayName=\"Requirements Branch\" toolTip=\"Select a requirements branch.\" />");
        sb.append("<XWidget xwidgetType=\"XBranchSelectWidget\" displayName=\"Test Results Branch\" toolTip=\"Select a scripts results branch.\" />");
        sb.append("</xWidgets>");
        return sb.toString();
    }

    public String getDescriptionUsage() {
        return "Generates an excel spreadsheet with detailed test status for scripts and procedures";
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.OTE);
    }

    private class BranchChangeListener
    implements ISelectionChangedListener {
        private BranchChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection versionArtifactSelection = (IStructuredSelection)event.getSelectionProvider().getSelection();
            Iterator iter = versionArtifactSelection.iterator();
            if (iter.hasNext()) {
                IAtsVersion version = (IAtsVersion)iter.next();
                try {
                    if (version != null) {
                        DetailedTestStatusBlam.this.selectedBranch = BranchManager.getBranchToken((BranchId)AtsApiService.get().getVersionService().getBaselineBranchIdInherited(version));
                        DetailedTestStatusBlam.this.reportBranchWidget.setSelection(DetailedTestStatusBlam.this.selectedBranch);
                    }
                }
                catch (OseeCoreException ex) {
                    DetailedTestStatusBlam.this.log(ex);
                }
            }
        }
    }

    private static enum Index {
        Category,
        TEST_POC,
        PARTITION,
        SUBSYSTEM,
        REQUIREMENT_NAME,
        QUALIFICATION_METHOD,
        REQUIREMENT_POC,
        SW_ENHANCEMENT,
        TEST_PROCEDURE,
        TEST_SCRIPT,
        RUN_DATE,
        TOTAL_TP,
        FAILED_TP,
        HOURS_REMAINING;

    }

    private class ProgramSelectionListener
    implements ISelectionChangedListener {
        private ProgramSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelectionProvider().getSelection();
            Iterator iter = selection.iterator();
            if (iter.hasNext()) {
                DetailedTestStatusBlam.this.selectedProgram = (IAtsProgram)iter.next();
                DetailedTestStatusBlam.this.selectedBranch = null;
                try {
                    IAtsTeamDefinition teamDefHoldingVersions = AtsApiService.get().getTeamDefinitionService().getTeamDefHoldingVersions(DetailedTestStatusBlam.this.selectedProgram);
                    if (teamDefHoldingVersions == null) {
                        DetailedTestStatusBlam.this.versionsListViewer.setInputAtsObjects(new ArrayList());
                        DetailedTestStatusBlam.this.reportBranchWidget.setSelection(null);
                    } else {
                        Collection versionArtifacts = AtsApiService.get().getVersionService().getVersions(teamDefHoldingVersions);
                        DetailedTestStatusBlam.this.versionsListViewer.setInputAtsObjects(versionArtifacts);
                        DetailedTestStatusBlam.this.reportBranchWidget.setSelection(null);
                        DetailedTestStatusBlam.this.versionsListViewer.addSelectionChangedListener(DetailedTestStatusBlam.this.branchSelectionListener);
                    }
                }
                catch (OseeCoreException ex) {
                    DetailedTestStatusBlam.this.log(ex);
                }
            }
        }
    }
}

