/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.operation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.team.Priorities;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlabelActionableItemSelection;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlinkChangeTypeSelection;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlinkPrioritySelection;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.widgets.XListDropViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.builder.XWidgetBuilder;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CreateActionFromTaskBlam
extends AbstractBlam {
    private static final String TASKS = "Tasks (drop here)";
    private static final String TITLE = "Title";
    private static final String ACTIONABLE_ITEMS = "Actionable Item(s)";
    private static final String CHANGE_TYPE = "Change Type";
    private static final String PRIORITY = "Priority";
    private Collection<TaskArtifact> taskArtifacts;
    private final AtsApi atsApi = AtsApiService.get();
    private XHyperlinkChangeTypeSelection changeTypeWidget;
    private XHyperlinkPrioritySelection priorityWidget;
    private XHyperlabelActionableItemSelection aiWidget;

    public void runOperation(final VariableMap variableMap, final IProgressMonitor monitor) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    List artifacts = variableMap.getArtifacts(CreateActionFromTaskBlam.TASKS);
                    String title = variableMap.getString(CreateActionFromTaskBlam.TITLE);
                    Collection aiasArts = variableMap.getCollection(IAtsActionableItem.class, CreateActionFromTaskBlam.ACTIONABLE_ITEMS);
                    ChangeTypes changeType = (ChangeTypes)variableMap.getValue(CreateActionFromTaskBlam.CHANGE_TYPE);
                    if (changeType == null) {
                        AWorkbench.popup((String)"ERROR", (String)"Must select a Change Type");
                        return;
                    }
                    Priorities priority = (Priorities)variableMap.getValue(CreateActionFromTaskBlam.PRIORITY);
                    if (priority == null) {
                        AWorkbench.popup((String)"ERROR", (String)"Must select a Priority");
                        return;
                    }
                    if (artifacts.isEmpty()) {
                        AWorkbench.popup((String)"ERROR", (String)"Must drag in Tasks to create Actions.");
                        return;
                    }
                    Artifact artifact = (Artifact)artifacts.iterator().next();
                    if (!artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task})) {
                        AWorkbench.popup((String)"ERROR", (String)"Artifact MUST be Task");
                        return;
                    }
                    if (aiasArts.isEmpty()) {
                        AWorkbench.popup((String)"ERROR", (String)"Must select Actionable Item(s)");
                        return;
                    }
                    try {
                        try {
                            AtsUtilClient.setEmailEnabled(false);
                            List taskArts = Collections.castAll((Collection)artifacts);
                            List aias = Collections.castAll((Collection)aiasArts);
                            CreateActionFromTaskBlam.this.handleCreateActions(taskArts, title, aias, changeType, priority.getName(), monitor);
                        }
                        catch (Exception ex) {
                            CreateActionFromTaskBlam.this.log(ex);
                            AtsUtilClient.setEmailEnabled(true);
                        }
                    }
                    finally {
                        AtsUtilClient.setEmailEnabled(true);
                    }
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
    }

    private void handleCreateActions(Collection<TaskArtifact> tasks, String title, Collection<IAtsActionableItem> aias, ChangeTypes changeType, String priority, IProgressMonitor monitor) {
        HashSet<TeamWorkFlowArtifact> newTeamArts = new HashSet<TeamWorkFlowArtifact>();
        IAtsChangeSet changes = this.atsApi.createChangeSet("Create Actions from Tasks");
        for (TaskArtifact task : tasks) {
            String useTitle = title;
            if (!Strings.isValid((String)useTitle)) {
                useTitle = task.getName();
            }
            ActionResult result = this.atsApi.getActionService().createAction(this.atsApi.getUserService().getCurrentUser(), useTitle, this.getDescription(task), changeType, priority, false, null, aias, new Date(), this.atsApi.getUserService().getCurrentUser(), null, changes);
            for (IAtsTeamWorkflow teamWf : result.getTeamWfs()) {
                newTeamArts.add((TeamWorkFlowArtifact)teamWf.getStoreObject());
                changes.relate((Object)teamWf, CoreRelationTypes.SupportingInfo_SupportingInfo, (Object)task);
                changes.add((Object)teamWf);
            }
        }
        changes.execute();
        if (newTeamArts.size() == 1) {
            WorkflowEditor.editArtifact((AbstractWorkflowArtifact)((Object)newTeamArts.iterator().next()));
        } else {
            AtsEditors.openInAtsWorldEditor("Created Tasks from Actions", newTeamArts);
        }
    }

    private String getDescription(TaskArtifact taskArt) {
        if (Strings.isValid((String)taskArt.getDescription())) {
            return String.format("Create from task [%s]\n\n[%s]", taskArt.toStringWithId(), taskArt.getDescription());
        }
        return String.format("Created from task [%s]", taskArt.toStringWithId());
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, modListener, isEditable);
        if (xWidget.getLabel().equals(TASKS) && this.taskArtifacts != null) {
            XListDropViewer viewer = (XListDropViewer)xWidget;
            viewer.setInput(this.taskArtifacts);
        } else if (xWidget.getLabel().equals(CHANGE_TYPE)) {
            this.changeTypeWidget = (XHyperlinkChangeTypeSelection)xWidget;
        } else if (xWidget.getLabel().equals(PRIORITY)) {
            this.priorityWidget = (XHyperlinkPrioritySelection)xWidget;
        } else if (xWidget.getLabel().equals(ACTIONABLE_ITEMS)) {
            this.aiWidget = (XHyperlabelActionableItemSelection)xWidget;
            this.aiWidget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    Collection<IAtsActionableItem> ais = CreateActionFromTaskBlam.this.aiWidget.getSelectedActionableItems();
                    if (!ais.isEmpty()) {
                        IAtsActionableItem ai = ais.iterator().next();
                        List changeTypeOptions = CreateActionFromTaskBlam.this.atsApi.getWorkItemService().getChangeTypeOptions((IAtsObject)ai);
                        CreateActionFromTaskBlam.this.changeTypeWidget.setSelectable(changeTypeOptions);
                        List priorityOptions = CreateActionFromTaskBlam.this.atsApi.getWorkItemService().getPrioritiesOptions((IAtsObject)ai);
                        CreateActionFromTaskBlam.this.priorityWidget.setSelectable(priorityOptions);
                    }
                }
            });
        }
    }

    public List<XWidgetRendererItem> getXWidgetItems() {
        XWidgetBuilder wb = new XWidgetBuilder();
        wb.andWidget(TASKS, "XListDropViewer");
        wb.andXHyperlinkActionableItemActive().andRequired().endWidget();
        wb.andXText(TITLE).andDefault((Object)this.getDefaultTitle()).andRequired().endWidget();
        wb.andChangeType(ChangeTypes.DEFAULT_CHANGE_TYPES).andRequired().endWidget();
        wb.andPriority().andRequired().endWidget();
        return wb.getItems();
    }

    private String getDefaultTitle() {
        String title = "";
        if (this.taskArtifacts != null) {
            for (TaskArtifact taskArt : this.taskArtifacts) {
                if (title.equals("")) {
                    title = taskArt.getName();
                    continue;
                }
                if (title.equals(taskArt.getName())) continue;
                return "";
            }
        }
        return title;
    }

    public String getDescriptionUsage() {
        return "Create Action from task and relate using supporting information relation.";
    }

    public void setDefaultTeamWorkflows(Collection<? extends TaskArtifact> taskArtifacts) {
        this.taskArtifacts = new LinkedList<TaskArtifact>();
        this.taskArtifacts.addAll(taskArtifacts);
    }

    public String getName() {
        return "Create Actions from Tasks";
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(AtsNavigateViewItems.ATS_UTIL);
    }
}

