/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.data.AtsUserGroups;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.NavigateView;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Shell;

public class ToggleAtsAdmin
extends XNavigateItemAction {
    public ToggleAtsAdmin() {
        super("Toggle ATS Admin - Temporary", (KeyedImage)PluginUiImage.ADMIN, new XNavItemCat[]{XNavigateItem.DEMO});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) throws Exception {
        ToggleAtsAdmin.run();
    }

    public static void run() {
        try {
            UserService userService = AtsApiService.get().userService();
            if (!userService.getUserGroup(AtsUserGroups.AtsTempAdmin).isCurrentUserMember()) {
                AWorkbench.popup((String)"Current User not configured for Temporary Admin");
                return;
            }
            boolean isAdmin = AtsApiService.get().getUserService().isAtsAdmin();
            String message = "Currently " + (isAdmin ? "ADMIN" : "NOT ADMIN") + " - Toggle?";
            if (MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Toggle Admin", (String)message)) {
                IUserGroup oseeAdminGroup;
                IUserGroup atsAdminGroup;
                if (!isAdmin) {
                    atsAdminGroup = userService.getUserGroup(AtsUserGroups.AtsAdmin);
                    if (!atsAdminGroup.isCurrentUserMember()) {
                        atsAdminGroup.addMember((UserId)UserManager.getUser(), true);
                        Conditions.assertTrue((boolean)(atsAdminGroup.getArtifact() instanceof Artifact), (String)"Must be artifact.", (Object[])new Object[0]);
                        ((Artifact)atsAdminGroup.getArtifact()).persist("Toggle Admin");
                    }
                    if (!(oseeAdminGroup = userService.getOseeAdmin()).isCurrentUserMember()) {
                        oseeAdminGroup.addMember((UserId)UserManager.getUser(), true);
                        Conditions.assertTrue((boolean)(oseeAdminGroup.getArtifact() instanceof Artifact), (String)"Must be artifact.", (Object[])new Object[0]);
                        ((Artifact)oseeAdminGroup.getArtifact()).persist("Toggle Admin");
                    }
                } else {
                    atsAdminGroup = userService.getUserGroup(AtsUserGroups.AtsAdmin);
                    if (atsAdminGroup.isCurrentUserMember()) {
                        atsAdminGroup.removeMember((UserId)UserManager.getUser(), true);
                        Conditions.assertTrue((boolean)(atsAdminGroup.getArtifact() instanceof Artifact), (String)"Must be artifact.", (Object[])new Object[0]);
                        ((Artifact)atsAdminGroup.getArtifact()).persist("Toggle Admin");
                    }
                    if ((oseeAdminGroup = userService.getUserGroup(CoreUserGroups.OseeAdmin)).isCurrentUserMember()) {
                        oseeAdminGroup.removeMember((UserId)UserManager.getUser(), true);
                        Conditions.assertTrue((boolean)(oseeAdminGroup.getArtifact() instanceof Artifact), (String)"Must be artifact.", (Object[])new Object[0]);
                        ((Artifact)oseeAdminGroup.getArtifact()).persist("Toggle Admin");
                    }
                }
                AtsApiService.get().clearCaches();
                for (WorkflowEditor editor : WorkflowEditor.getWorkflowEditors()) {
                    editor.refresh();
                }
                if (NavigateView.getNavigateView() != null && NavigateView.isAccessible()) {
                    NavigateView.getNavigateView().refreshData();
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

