/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.review.ReviewFormalType;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelper;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.section.WfeWorkflowSection;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.review.AbstractReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.review.NewPeerReviewDialog;
import org.eclipse.osee.ats.ide.workflow.review.NewPeerToPeerReviewJob;
import org.eclipse.osee.ats.ide.workflow.review.ReviewManager;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.XFormToolkit;
import org.eclipse.osee.framework.ui.skynet.widgets.XLabelValueBase;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ReviewInfoXWidget
extends XLabelValueBase {
    private final IStateToken forState;
    private final List<Label> labelWidgets = new ArrayList<Label>();
    private Composite destroyableComposite = null;
    private final Composite composite;
    private final IManagedForm managedForm;
    private final int horizontalSpan;
    private final XFormToolkit toolkit;
    private final TeamWorkFlowArtifact teamArt;
    private final WfeWorkflowSection workflowSection;

    public ReviewInfoXWidget(WfeWorkflowSection workflowSection, XFormToolkit toolkit, TeamWorkFlowArtifact teamArt, IStateToken forState, Composite composite, int horizontalSpan) {
        super("\"" + forState.getName() + "\" State Reviews");
        this.workflowSection = workflowSection;
        this.managedForm = workflowSection.getManagedForm();
        this.toolkit = toolkit;
        this.teamArt = teamArt;
        this.forState = forState;
        this.composite = composite;
        this.horizontalSpan = horizontalSpan;
        this.reDisplay();
    }

    public void reDisplay() {
        if (this.composite != null && this.composite.isDisposed()) {
            return;
        }
        if (this.destroyableComposite != null) {
            this.destroyableComposite.dispose();
        }
        this.destroyableComposite = new Composite(this.composite, 0);
        this.destroyableComposite.setLayout((Layout)ALayout.getZeroMarginLayout((int)4, (boolean)false));
        this.setToolTip("Blocking Reviews must be completed before transtion.  Select Review hyperlink to view.");
        this.createWidgets(this.managedForm, this.destroyableComposite, this.horizontalSpan);
        try {
            this.addAdminRightClickOption();
            Collection<AbstractReviewArtifact> revArts = ReviewManager.getReviews(this.teamArt, this.forState);
            if (revArts.isEmpty()) {
                this.setValueText("No Reviews Created");
            }
            Hyperlink link = this.toolkit.createHyperlink(this.destroyableComposite, "[Add Peer to Peer Review]", 0);
            link.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    try {
                        if (ReviewInfoXWidget.this.workflowSection.getEditor().isDirty()) {
                            ReviewInfoXWidget.this.workflowSection.getEditor().doSave(null);
                        }
                        NewPeerReviewDialog dialog = new NewPeerReviewDialog("Add Peer to Peer Review", "Enter Title and Select Review Type.", AtsApiService.get().getWorkDefinitionService().getStateNames(ReviewInfoXWidget.this.teamArt.getWorkDefinition()), ReviewInfoXWidget.this.forState.getName(), null);
                        dialog.setReviewTitle(AtsApiService.get().getReviewService().getDefaultReviewTitle((IAtsTeamWorkflow)ReviewInfoXWidget.this.teamArt));
                        if (dialog.open() == 0) {
                            if (!Strings.isValid((String)dialog.getReviewTitle())) {
                                AWorkbench.popup((String)"ERROR", (String)"Must enter review title");
                                return;
                            }
                            ReviewBlockType blockType = null;
                            if (Strings.isValid((String)dialog.getBlockingType())) {
                                blockType = ReviewBlockType.valueOf((String)dialog.getBlockingType());
                            }
                            ReviewFormalType reviewType = null;
                            if (Strings.isValid((String)dialog.getReviewFormalType())) {
                                reviewType = ReviewFormalType.valueOf((String)dialog.getReviewFormalType());
                            }
                            NewPeerToPeerReviewJob job = new NewPeerToPeerReviewJob(ReviewInfoXWidget.this.teamArt, null, dialog.getReviewTitle(), dialog.getSelectedState(), blockType, reviewType);
                            job.setUser(true);
                            job.setPriority(30);
                            job.schedule();
                        }
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            });
            if (revArts.size() > 0) {
                Composite workComp = this.toolkit.createContainer(this.destroyableComposite, 1);
                workComp.setLayoutData((Object)new GridData(1810));
                GridData gd = new GridData();
                gd.horizontalIndent = 20;
                gd.horizontalSpan = 4;
                workComp.setLayoutData((Object)gd);
                for (AbstractReviewArtifact revArt : revArts) {
                    this.createReviewHyperlink(workComp, this.managedForm, this.toolkit, revArt, this.forState);
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public String toString() {
        try {
            return "ReviewInfoXWidget for SMA \"" + (Object)((Object)this.teamArt) + "\"";
        }
        catch (Exception ex) {
            return "ReviewInfoXWidget " + ex.getLocalizedMessage();
        }
    }

    public static String toHTML(TeamWorkFlowArtifact teamArt, IStateToken forState) {
        if (ReviewManager.getReviews(teamArt, forState).isEmpty()) {
            return "";
        }
        StringBuffer html = new StringBuffer();
        try {
            html.append(String.valueOf(AHTML.addSpace((int)1)) + AHTML.getLabelStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)("\"" + forState.getName() + "\" State Reviews")));
            html.append(AHTML.startBorderTable((int)100, (String)"#EEEEEE", (String)""));
            html.append(AHTML.addHeaderRowMultiColumnTable((String[])new String[]{"Review Type", "Title", "ID"}));
            for (AbstractReviewArtifact art : ReviewManager.getReviews(teamArt, forState)) {
                html.append(AHTML.addRowMultiColumnTable((String[])new String[]{art.getArtifactTypeName(), art.getName(), art.getAtsId()}));
            }
            html.append(AHTML.endBorderTable());
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return "Review Exception - " + ex.getLocalizedMessage();
        }
        return html.toString();
    }

    private void createReviewHyperlink(Composite comp, IManagedForm managedForm, XFormToolkit toolkit, final AbstractReviewArtifact revArt, IStateToken forState) {
        String str;
        IMessageManager messageManager;
        Composite workComp = toolkit.createContainer(comp, 1);
        workComp.setLayoutData((Object)new GridData(770));
        workComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)3, (boolean)false));
        Label strLabel = new Label(workComp, 0);
        this.labelWidgets.add(strLabel);
        if (revArt.isBlocking() && !revArt.isCompletedOrCancelled()) {
            strLabel.setText("State Blocking [" + revArt.getArtifactTypeName() + "] must be completed: ");
            messageManager = managedForm.getMessageManager();
            if (messageManager != null) {
                messageManager.addMessage((Object)"validation.error", "\"" + forState.getName() + "\" State has a blocking [" + revArt.getArtifactTypeName() + "] that must be completed.", null, 3, (Control)strLabel);
            }
        } else if (!revArt.isCompletedOrCancelled()) {
            strLabel.setText("Open [" + revArt.getArtifactTypeName() + "] exists: ");
            messageManager = managedForm.getMessageManager();
            if (messageManager != null) {
                messageManager.addMessage((Object)"validation.error", "\"" + forState.getName() + "\" State has an open [" + revArt.getArtifactTypeName() + "].", null, 2, (Control)strLabel);
            }
        } else {
            strLabel.setText(String.valueOf(revArt.getCurrentStateName()) + " [" + revArt.getArtifactTypeName() + "] exists: ");
        }
        Hyperlink hyperLabel = toolkit.createHyperlink(workComp, (str = "[" + revArt.getName() + "]").length() > 300 ? String.valueOf(Strings.truncate((String)str, (int)300)) + "..." : str, 0);
        hyperLabel.setToolTipText("Select to open review");
        hyperLabel.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                WorkflowEditor.editArtifact(revArt);
            }
        });
    }

    public void addAdminRightClickOption() {
        if (AtsApiService.get().getUserService().isAtsAdmin() && !AtsApiService.get().getStoreService().isProductionDb()) {
            this.labelWidget.addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    if (event.button == 3) {
                        if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Auto Complete Reviews", (String)"ATS Admin\n\nAuto Complete Reviews?")) {
                            return;
                        }
                        try {
                            ArrayList<AbstractReviewArtifact> awas = new ArrayList<AbstractReviewArtifact>();
                            for (IAtsAbstractReview review : ReviewManager.getReviewsFromCurrentState(ReviewInfoXWidget.this.teamArt)) {
                                AbstractReviewArtifact revArt = (AbstractReviewArtifact)AtsApiService.get().getQueryService().getArtifact((IAtsObject)review);
                                if (revArt.isCompletedOrCancelled()) continue;
                                if (revArt.getStateMgr().isUnAssigned()) {
                                    revArt.getStateMgr().setAssignee(AtsApiService.get().getUserService().getCurrentUser());
                                }
                                awas.add(revArt);
                            }
                            TransitionHelper helper = new TransitionHelper("ATS Auto Complete Reviews", (Collection)Collections.castAll(awas), TeamState.Completed.getName(), null, null, null, (AtsApi)AtsApiService.get(), new TransitionOption[]{TransitionOption.OverrideTransitionValidityCheck, TransitionOption.None});
                            TransitionResults results = AtsApiService.get().getWorkItemServiceIde().transition((ITransitionHelper)helper);
                            if (!results.isEmpty()) {
                                AWorkbench.popup((String)String.format("Transition Error %s", results.toString()));
                            }
                            ReviewInfoXWidget.this.workflowSection.getEditor().refresh();
                        }
                        catch (OseeCoreException ex) {
                            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                        }
                    }
                }
            });
        }
    }
}

