/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.team.Priorities;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workdef.IAtsDecisionReviewDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsDecisionReviewOption;
import org.eclipse.osee.ats.api.workdef.IAtsPeerReviewDefinition;
import org.eclipse.osee.ats.api.workdef.WidgetOption;
import org.eclipse.osee.ats.api.workdef.model.CompositeLayoutItem;
import org.eclipse.osee.ats.api.workdef.model.HeaderDefinition;
import org.eclipse.osee.ats.api.workdef.model.LayoutItem;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsWorkItemHook;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workdef.editor.WorkDefinitionViewer;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.WorkflowManager;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.skynet.ArtifactImageManager;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class WfeOutlinePage
extends ContentOutlinePage {
    private WorkflowEditor workflowEditor;
    private WorkDefinitionViewer workDefViewer;
    private boolean isTeamWf;

    public void createControl(Composite parent) {
        super.createControl(parent);
        Tree tree = this.getTreeViewer().getTree();
        tree.setLayout((Layout)new FillLayout(512));
        this.getTreeViewer().setContentProvider((IContentProvider)new InternalContentProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new InternalLabelProvider());
        if (this.workflowEditor != null) {
            this.setInput(this.workflowEditor);
        } else if (this.workDefViewer != null) {
            this.setInput((Object)this.workDefViewer);
        } else {
            this.setInput("No Imput Provided");
        }
        this.getSite().getActionBars().getToolBarManager().add((IAction)new Action("Refresh", ImageManager.getImageDescriptor((KeyedImage)PluginUiImage.REFRESH)){

            public void run() {
                WfeOutlinePage.this.refresh();
            }
        });
        this.getSite().getActionBars().getToolBarManager().update(true);
    }

    public void setInput(Object input) {
        if (input instanceof WorkflowEditor) {
            this.workflowEditor = (WorkflowEditor)input;
            if (this.getTreeViewer() != null && this.workflowEditor != null && this.getTreeViewer() != null && Widgets.isAccessible((Widget)this.getTreeViewer().getTree())) {
                this.getTreeViewer().setInput((Object)this.workflowEditor);
                try {
                    AbstractWorkflowArtifact awa = this.workflowEditor.getWorkItem();
                    if (awa != null) {
                        StateDefinition stateDef = WorkflowManager.getCurrentAtsWorkPage(awa).getStateDefinition();
                        StructuredSelection newSelection = new StructuredSelection(Arrays.asList(stateDef));
                        this.getTreeViewer().expandToLevel((Object)awa, 2);
                        this.getTreeViewer().expandToLevel((Object)stateDef, 1);
                        this.getTreeViewer().setSelection((ISelection)newSelection);
                    }
                }
                catch (OseeStateException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        } else if (input instanceof WorkDefinitionViewer && this.getTreeViewer() != null) {
            this.workDefViewer = (WorkDefinitionViewer)((Object)input);
            this.getTreeViewer().setInput((Object)this.workDefViewer);
            this.getTreeViewer().expandToLevel((Object)this.workDefViewer, 2);
        }
        this.isTeamWf = this.workflowEditor != null && this.workflowEditor.getWorkItem() != null && this.workflowEditor.getWorkItem().isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow}) || this.workDefViewer != null && this.workDefViewer.getWorkDef() != null && this.workDefViewer.getWorkDef().getName().contains("_Team_");
    }

    public void refresh() {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && Widgets.isAccessible((Widget)viewer.getTree())) {
            viewer.refresh();
        }
    }

    public void setWorkDefViewer(WorkDefinitionViewer workDefViewer) {
        this.workDefViewer = workDefViewer;
    }

    private class InternalContentProvider
    implements ITreeContentProvider {
        private InternalContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object element) {
            ArrayList<Object> items = new ArrayList<Object>();
            if (element instanceof WorkDefinitionViewer) {
                items.add(((WorkDefinitionViewer)((Object)element)).getWorkDef());
            } else if (element instanceof WrappedChangeTypes) {
                items.addAll(((WrappedChangeTypes)element).getChangeTypes());
            } else if (element instanceof WrappedPriorities) {
                items.addAll(((WrappedPriorities)element).getPriorities());
            } else if (element instanceof WorkflowEditor) {
                items.add((Object)((WorkflowEditor)element).getWorkItem());
                items.add(new WrappedStateItems(AtsApiService.get().getWorkItemService().getWorkItemHooks()));
            } else if (element instanceof AbstractWorkflowArtifact) {
                items.add(((AbstractWorkflowArtifact)((Object)element)).getWorkDefinition());
            } else if (element instanceof WrappedLayout) {
                items.addAll(((WrappedLayout)element).getStateItems());
            } else if (element instanceof WorkDefinition) {
                this.getChildrenFromWorkDefinition((WorkDefinition)element, items);
            } else if (element instanceof StateDefinition) {
                this.getChildrenFromStateDefinition(element, items);
            } else if (element instanceof CompositeLayoutItem) {
                items.addAll(((CompositeLayoutItem)element).getLayoutItems());
            } else if (element instanceof User) {
                items.add("Assignee: " + ((User)element).getName());
            } else if (element instanceof WrappedStateItems) {
                items.addAll(((WrappedStateItems)element).getStateItems());
            } else if (element instanceof IAtsWorkItemHook) {
                items.add("Description: " + ((IAtsWorkItemHook)element).getDescription());
                items.add("Full Name: " + ((IAtsWorkItemHook)element).getFullName());
            } else if (element instanceof WrappedTransitions) {
                items.addAll(((WrappedTransitions)element).getTransitions());
            } else if (element instanceof IAtsDecisionReviewDefinition) {
                this.getChildrenFromDecisionReviewDefinition(element, items);
            } else if (element instanceof IAtsPeerReviewDefinition) {
                this.getChildrenFromPeerReviewDefinition(element, items);
            } else if (element instanceof IAtsDecisionReviewOption) {
                this.getUsersFromDecisionReviewOpt((IAtsDecisionReviewOption)element, items);
            } else if (element instanceof WrappedDecisionReviews) {
                items.addAll(((WrappedDecisionReviews)element).getDecisionReviews());
            } else if (element instanceof WrappedPeerReviews) {
                items.addAll(((WrappedPeerReviews)element).getPeerReviews());
            } else if (element instanceof WrappedRules) {
                items.addAll(((WrappedRules)element).getRuleAndLocations());
            } else if (element instanceof WidgetDefinition) {
                this.getChildrenFromWidgetDefinition(element, items);
            } else if (element instanceof String) {
                items.add(element);
            } else if (element instanceof WrappedStates) {
                items.addAll(((WrappedStates)element).getStates());
            } else if (element instanceof HeaderDefinition) {
                this.getChildrentFromHeaderDefinition((HeaderDefinition)element, items);
            }
            return items.toArray(new Object[items.size()]);
        }

        public Object getParent(Object element) {
            if (element instanceof AbstractWorkflowArtifact) {
                return WfeOutlinePage.this.workflowEditor;
            }
            if (element instanceof WorkDefinition) {
                return WfeOutlinePage.this.workflowEditor != null ? WfeOutlinePage.this.workflowEditor : WfeOutlinePage.this.workDefViewer;
            }
            if (element instanceof StateDefinition) {
                return ((StateDefinition)element).getWorkDefinition();
            }
            if (element instanceof HeaderDefinition) {
                return ((HeaderDefinition)element).getWorkDefinition();
            }
            if (element instanceof WrappedChangeTypes) {
                return WfeOutlinePage.this.workflowEditor.getWorkItem().getWorkDefinition();
            }
            if (element instanceof WrappedPriorities) {
                return WfeOutlinePage.this.workflowEditor.getWorkItem().getWorkDefinition();
            }
            if (element instanceof String) {
                return WfeOutlinePage.this.workflowEditor != null ? WfeOutlinePage.this.workflowEditor : WfeOutlinePage.this.workDefViewer;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof String) {
                return false;
            }
            if (element instanceof AbstractWorkflowArtifact) {
                return true;
            }
            if (element instanceof WorkDefinition) {
                return true;
            }
            if (element instanceof StateDefinition) {
                return true;
            }
            if (element instanceof CompositeLayoutItem) {
                return true;
            }
            if (element instanceof IAtsWorkItemHook) {
                return true;
            }
            if (element instanceof WidgetDefinition) {
                return true;
            }
            if (element instanceof IAtsPeerReviewDefinition) {
                return true;
            }
            if (element instanceof IAtsDecisionReviewDefinition) {
                return true;
            }
            if (element instanceof IAtsDecisionReviewOption) {
                return !((IAtsDecisionReviewOption)element).getUserIds().isEmpty();
            }
            if (element instanceof WrappedTransitions) {
                return true;
            }
            if (element instanceof WrappedPercentWeight) {
                return false;
            }
            if (element instanceof WrappedChangeTypes) {
                return !((WrappedChangeTypes)element).getChangeTypes().isEmpty();
            }
            if (element instanceof WrappedPriorities) {
                return !((WrappedPriorities)element).getPriorities().isEmpty();
            }
            if (element instanceof WrappedLayout) {
                return !((WrappedLayout)element).stateItems.isEmpty();
            }
            if (element instanceof WrappedDecisionReviews) {
                return !((WrappedDecisionReviews)element).decReviews.isEmpty();
            }
            if (element instanceof WrappedPeerReviews) {
                return !((WrappedPeerReviews)element).decReviews.isEmpty();
            }
            if (element instanceof WrappedStateItems) {
                return !((WrappedStateItems)element).workflowHooks.isEmpty();
            }
            if (element instanceof WrappedStates) {
                if (((WrappedStates)element).states != null) {
                    return !((WrappedStates)element).states.isEmpty();
                }
            } else {
                if (element instanceof RuleAndLocation) {
                    return false;
                }
                if (element instanceof WrappedRules) {
                    return !((WrappedRules)element).getRuleAndLocations().isEmpty();
                }
                if (element instanceof HeaderDefinition) {
                    return true;
                }
            }
            return false;
        }

        private void getChildrenFromWidgetDefinition(Object element, List<Object> items) {
            items.add("XWidget: " + ((WidgetDefinition)element).getXWidgetName());
            if (((WidgetDefinition)element).getAttributeType() != null) {
                items.add("Attribute Name: " + ((WidgetDefinition)element).getAttributeType().getName());
            }
            if (Strings.isValid((String)((WidgetDefinition)element).getDescription())) {
                items.add("Description: " + ((WidgetDefinition)element).getDescription());
            }
            if (((WidgetDefinition)element).getHeight() > 0) {
                items.add("Height: " + ((WidgetDefinition)element).getHeight());
            }
            if (((WidgetDefinition)element).getAttributeType() != null) {
                items.add("Tooltip: " + ((WidgetDefinition)element).getAttributeType().getName());
            }
            if (!((WidgetDefinition)element).getOptions().getXOptions().isEmpty()) {
                items.addAll(((WidgetDefinition)element).getOptions().getXOptions());
            }
        }

        private void getChildrenFromPeerReviewDefinition(Object element, List<Object> items) {
            if (Strings.isValid((String)((IAtsPeerReviewDefinition)element).getReviewTitle())) {
                items.add("Title: " + ((IAtsPeerReviewDefinition)element).getReviewTitle());
            }
            if (Strings.isValid((String)((IAtsPeerReviewDefinition)element).getDescription())) {
                items.add("Description: " + ((IAtsPeerReviewDefinition)element).getDescription());
            }
            if (Strings.isValid((String)((IAtsPeerReviewDefinition)element).getLocation())) {
                items.add("Description: " + ((IAtsPeerReviewDefinition)element).getLocation());
            }
            items.add("On Event: " + ((IAtsPeerReviewDefinition)element).getStateEventType().name());
            items.add("Related To State: " + ((IAtsPeerReviewDefinition)element).getRelatedToState());
            items.add("Review Blocks: " + ((IAtsPeerReviewDefinition)element).getBlockingType().name());
            for (String userId : ((IAtsPeerReviewDefinition)element).getAssignees()) {
                try {
                    items.add(AtsApiService.get().getUserService().getUserByUserId(userId));
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    items.add(String.format("Exception loading user from id [%s] [%s]", userId, ex.getLocalizedMessage()));
                }
            }
        }

        private void getChildrenFromDecisionReviewDefinition(Object element, List<Object> items) {
            if (Strings.isValid((String)((IAtsDecisionReviewDefinition)element).getReviewTitle())) {
                items.add("Title: " + ((IAtsDecisionReviewDefinition)element).getReviewTitle());
            }
            if (Strings.isValid((String)((IAtsDecisionReviewDefinition)element).getDescription())) {
                items.add("Description: " + ((IAtsDecisionReviewDefinition)element).getDescription());
            }
            items.add("On Event: " + ((IAtsDecisionReviewDefinition)element).getStateEventType().name());
            items.add("Related To State: " + ((IAtsDecisionReviewDefinition)element).getRelatedToState());
            items.add("Review Blocks: " + ((IAtsDecisionReviewDefinition)element).getBlockingType().name());
            items.add("Auto Transition to Decision: " + ((IAtsDecisionReviewDefinition)element).isAutoTransitionToDecision());
            for (String userId : ((IAtsDecisionReviewDefinition)element).getAssignees()) {
                try {
                    items.add(AtsApiService.get().getUserService().getUserByUserId(userId));
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    items.add(String.format("Exception loading user from id [%s] [%s]", userId, ex.getLocalizedMessage()));
                }
            }
            items.addAll(((IAtsDecisionReviewDefinition)element).getOptions());
        }

        private void getChildrenFromStateDefinition(Object element, List<Object> items) {
            StateDefinition stateDef = (StateDefinition)element;
            items.add("Ordinal: " + stateDef.getOrdinal());
            if (Strings.isValid((String)stateDef.getDescription())) {
                items.add("Description: " + stateDef.getDescription());
            }
            items.add(new WrappedLayout(stateDef.getLayoutItems()));
            items.add(new WrappedRules(stateDef));
            if (stateDef.getRecommendedPercentComplete() == null) {
                items.add("Recommended Percent Complete: not set");
            } else {
                items.add("Recommended Percent Complete: " + stateDef.getRecommendedPercentComplete());
            }
            items.add("Color: " + (stateDef.getColor() == null ? "not set" : stateDef.getColor().toString()));
            if (WfeOutlinePage.this.isTeamWf) {
                items.add(new WrappedDecisionReviews(stateDef.getDecisionReviews()));
                items.add(new WrappedPeerReviews(stateDef.getPeerReviews()));
            }
            items.add(new WrappedTransitions(stateDef));
        }

        private void getChildrentFromHeaderDefinition(HeaderDefinition headerDef, List<Object> items) {
            try {
                items.add("Show Metrics Header: " + headerDef.isShowMetricsHeader());
                items.add("Show Work Package Header: " + headerDef.isShowWorkPackageHeader());
                items.add("Show Sibling Links: " + headerDef.isShowSiblingLinks());
            }
            catch (OseeStateException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
            try {
                items.add(new WrappedLayout(headerDef.getLayoutItems()));
            }
            catch (OseeStateException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }

        private void getChildrenFromWorkDefinition(WorkDefinition workDef, List<Object> items) {
            items.add(new WrappedChangeTypes(workDef));
            items.add(new WrappedPriorities(workDef));
            try {
                items.add(workDef.getHeaderDef());
            }
            catch (OseeStateException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
            try {
                items.addAll(AtsApiService.get().getWorkDefinitionService().getStatesOrderedByOrdinal(workDef));
            }
            catch (OseeStateException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
            items.add("Show State Metrics: " + workDef.isShowStateMetrics());
            items.add(new WrappedPercentWeight(workDef));
        }

        private void getUsersFromDecisionReviewOpt(IAtsDecisionReviewOption revOpt, List<Object> items) {
            for (String userId : revOpt.getUserIds()) {
                try {
                    items.add(AtsApiService.get().getUserService().getUserByUserId(userId));
                }
                catch (OseeCoreException ex) {
                    items.add(String.format("Erroring getting user by id [%s] : [%s]", userId, ex.getLocalizedMessage()));
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
            for (String userName : revOpt.getUserNames()) {
                try {
                    items.add(AtsApiService.get().getUserService().getUserByName(userName));
                }
                catch (OseeCoreException ex) {
                    items.add(String.format("Erroring getting user by name [%s] : [%s]", userName, ex.getLocalizedMessage()));
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }
    }

    private class InternalLabelProvider
    extends LabelProvider {
        private InternalLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof WorkflowEditor) {
                return ((WorkflowEditor)element).getTitle();
            }
            if (element instanceof WorkDefinitionViewer) {
                return ((WorkDefinitionViewer)((Object)element)).getName();
            }
            if (element instanceof ChangeTypes) {
                ChangeTypes changeTypes = (ChangeTypes)element;
                String desc = changeTypes.getDescription();
                if (Strings.isValid((String)desc)) {
                    return String.format("%s - %s", changeTypes.name(), desc);
                }
                return changeTypes.name();
            }
            return String.valueOf(element);
        }

        public Image getImage(Object element) {
            if (element instanceof WorkDefinitionViewer) {
                return ImageManager.getImage((OseeImage)AtsImage.WORKFLOW);
            }
            if (element instanceof WorkflowEditor) {
                return ((WorkflowEditor)element).getTitleImage();
            }
            if (element instanceof AbstractWorkflowArtifact) {
                return ArtifactImageManager.getImage((Artifact)((AbstractWorkflowArtifact)((Object)element)));
            }
            if (element instanceof StateDefinition) {
                return ImageManager.getImage((OseeImage)AtsImage.STATE_DEFINITION);
            }
            if (element instanceof IAtsWorkItemHook || element instanceof WrappedStateItems) {
                return ImageManager.getImage((OseeImage)AtsImage.STATE_ITEM);
            }
            if (element instanceof WorkDefinition) {
                return ImageManager.getImage((OseeImage)AtsImage.WORKFLOW);
            }
            if (element instanceof WidgetDefinition) {
                return ImageManager.getImage((KeyedImage)FrameworkImage.GEAR);
            }
            if (element instanceof CompositeLayoutItem || element instanceof WrappedLayout) {
                return ImageManager.getImage((OseeImage)AtsImage.COMPOSITE_STATE_ITEM);
            }
            if (element instanceof String || element instanceof WidgetOption || element instanceof WrappedPercentWeight) {
                return ImageManager.getImage((OseeImage)AtsImage.RIGHT_ARROW_SM);
            }
            if (element instanceof WrappedStates || element instanceof WrappedTransitions) {
                return ImageManager.getImage((OseeImage)AtsImage.TRANSITION);
            }
            if (element instanceof WrappedRules || element instanceof RuleAndLocation) {
                return ImageManager.getImage((KeyedImage)FrameworkImage.RULE);
            }
            if (element instanceof User) {
                return ImageManager.getImage((KeyedImage)FrameworkImage.USER);
            }
            if (element instanceof WrappedPeerReviews || element instanceof IAtsPeerReviewDefinition) {
                return ImageManager.getImage((OseeImage)AtsImage.PEER_REVIEW);
            }
            if (element instanceof WrappedDecisionReviews || element instanceof IAtsDecisionReviewDefinition) {
                return ImageManager.getImage((OseeImage)AtsImage.DECISION_REVIEW);
            }
            if (element instanceof IAtsDecisionReviewOption) {
                return ImageManager.getImage((KeyedImage)FrameworkImage.QUESTION);
            }
            if (element instanceof HeaderDefinition) {
                return ImageManager.getImage((OseeImage)AtsImage.WORKFLOW_DEFINITION);
            }
            if (element instanceof WrappedChangeTypes) {
                return ImageManager.getImage((OseeImage)AtsImage.CHANGE_REQUEST);
            }
            if (element instanceof WrappedPriorities) {
                return ImageManager.getImage((KeyedImage)FrameworkImage.PAGE);
            }
            if (element instanceof ChangeTypes) {
                return ImageManager.getImage((OseeImage)AtsImage.CHANGE_REQUEST);
            }
            return null;
        }
    }

    private class RuleAndLocation {
        private final String rule;
        private final String location;

        public RuleAndLocation(String rule, String location) {
            this.rule = rule;
            this.location = location;
        }

        public String toString() {
            return String.format("%s [%s]", this.rule, this.location);
        }
    }

    private class WrappedChangeTypes {
        private final String name = "Change Types";
        private final WorkDefinition workDef;

        public WrappedChangeTypes(WorkDefinition workDef) {
            this.workDef = workDef;
        }

        public String toString() {
            if (this.workDef.getChangeTypes() != null) {
                return "Change Types" + (this.workDef.getChangeTypes().isEmpty() ? " (Empty)" : "");
            }
            return "Change Types";
        }

        public Collection<ChangeTypes> getChangeTypes() {
            return this.workDef.getChangeTypes();
        }
    }

    private class WrappedDecisionReviews {
        private final Collection<IAtsDecisionReviewDefinition> decReviews;

        public WrappedDecisionReviews(Collection<IAtsDecisionReviewDefinition> decReviews) {
            this.decReviews = decReviews;
        }

        public String toString() {
            return "Decision Reviews" + (this.decReviews.isEmpty() ? " (Empty)" : "");
        }

        public Collection<IAtsDecisionReviewDefinition> getDecisionReviews() {
            return this.decReviews;
        }
    }

    private class WrappedLayout {
        private final Collection<LayoutItem> stateItems;

        public WrappedLayout(Collection<LayoutItem> stateItems) {
            this.stateItems = stateItems;
        }

        public String toString() {
            return "Layout" + (this.stateItems.isEmpty() ? " (Empty)" : "");
        }

        public Collection<LayoutItem> getStateItems() {
            return this.stateItems;
        }
    }

    private class WrappedPeerReviews {
        private final Collection<IAtsPeerReviewDefinition> decReviews;

        public WrappedPeerReviews(Collection<IAtsPeerReviewDefinition> decReviews) {
            this.decReviews = decReviews;
        }

        public String toString() {
            return "Peer Reviews" + (this.decReviews.isEmpty() ? " (Empty)" : "");
        }

        public Collection<IAtsPeerReviewDefinition> getPeerReviews() {
            return this.decReviews;
        }
    }

    private class WrappedPercentWeight {
        private final WorkDefinition workDef;

        public WrappedPercentWeight(WorkDefinition workDef) {
            this.workDef = workDef;
        }

        public String toString() {
            return "Total Percent Weighting: ";
        }

        public WorkDefinition getWorkDef() {
            return this.workDef;
        }
    }

    private class WrappedPriorities {
        private final String name = "Priorities";
        private final WorkDefinition workDef;

        public WrappedPriorities(WorkDefinition workDef) {
            this.workDef = workDef;
        }

        public String toString() {
            if (this.workDef.getPriorities() != null) {
                return "Priorities" + (this.workDef.getPriorities().isEmpty() ? " (Empty)" : "");
            }
            return "Priorities";
        }

        public Collection<Priorities> getPriorities() {
            return this.workDef.getPriorities();
        }
    }

    private class WrappedRules {
        private final StateDefinition stateDef;

        public WrappedRules(StateDefinition stateDef) {
            this.stateDef = stateDef;
        }

        public String toString() {
            return "Rules" + (this.getRuleAndLocations().isEmpty() ? " (Empty)" : "");
        }

        public Collection<RuleAndLocation> getRuleAndLocations() {
            ArrayList<RuleAndLocation> result = new ArrayList<RuleAndLocation>();
            for (String ruleDef : this.stateDef.getRules()) {
                result.add(new RuleAndLocation(ruleDef, "State Definition"));
            }
            if (WfeOutlinePage.this.workflowEditor != null && WfeOutlinePage.this.workflowEditor.getWfeInput().getArtifact().isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                try {
                    IAtsTeamDefinition teamDef = ((TeamWorkFlowArtifact)WfeOutlinePage.this.workflowEditor.getWfeInput().getArtifact()).getTeamDefinition();
                    for (String workRuleDef : AtsApiService.get().getTeamDefinitionService().getRules(teamDef)) {
                        String location = String.format("Team Definition [%s]", teamDef);
                        result.add(new RuleAndLocation(workRuleDef, location));
                        if (!workRuleDef.startsWith("ats")) continue;
                        result.add(new RuleAndLocation(workRuleDef.replaceFirst("^ats", ""), String.valueOf(location) + " translated from WorkRuleDefinition starting with ats"));
                    }
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
            return result;
        }
    }

    private class WrappedStateItems {
        private final Collection<IAtsWorkItemHook> workflowHooks;

        public WrappedStateItems(Collection<IAtsWorkItemHook> stateItems) {
            this.workflowHooks = stateItems;
        }

        public String toString() {
            return "Workflow Hooks" + (this.workflowHooks.isEmpty() ? " (Empty)" : "");
        }

        public Collection<IAtsWorkItemHook> getStateItems() {
            return this.workflowHooks;
        }
    }

    private class WrappedStates {
        private final String name;
        private final Collection<StateDefinition> states;

        public WrappedStates(String name, Collection<StateDefinition> states) {
            this.name = name;
            this.states = states;
        }

        public String toString() {
            if (this.states != null) {
                return String.valueOf(this.name) + (this.states.isEmpty() ? " (Empty)" : "");
            }
            return this.name;
        }

        public Collection<StateDefinition> getStates() {
            return this.states;
        }
    }

    private class WrappedTransitions {
        private final StateDefinition stateDef;

        public WrappedTransitions(StateDefinition stateDef) {
            this.stateDef = stateDef;
        }

        public Collection<Object> getTransitions() {
            ArrayList<Object> items = new ArrayList<Object>();
            if (this.stateDef.getToStates().isEmpty()) {
                items.add(new WrappedStates("DefaultToState: None", null));
            } else {
                items.add(new WrappedStates("DefaultToState: " + this.stateDef.getToStates().iterator().next(), null));
            }
            items.add(new WrappedStates("ToStates", this.stateDef.getToStates()));
            return items;
        }

        public String toString() {
            return "Transitions" + (this.stateDef.getToStates().isEmpty() ? " (Empty)" : "");
        }
    }
}

