/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelValueSelection;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class WfeWorkflowNotesHeader
extends Composite {
    private final IAtsWorkItem workItem;
    private final WorkflowEditor editor;
    private Composite nComp;
    private final String forStateName;

    public WfeWorkflowNotesHeader(Composite parent, int style, IAtsWorkItem workItem, String forStateName, WorkflowEditor editor) {
        super(parent, style);
        this.workItem = workItem;
        this.forStateName = forStateName;
        this.editor = editor;
        this.setLayoutData(new GridData(4, 0, true, false));
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
        editor.getToolkit().adapt((Composite)this);
        this.setBackground(Displays.getSystemColor((int)1));
        this.createNotes(workItem, forStateName, editor);
    }

    private void createNotes(final IAtsWorkItem workItem, String forStateName, WorkflowEditor editor) {
        try {
            final String wfNote = (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.WorkflowNotes, (Object)"");
            if (Strings.isValid((String)wfNote)) {
                this.nComp = new Composite((Composite)this, 0);
                this.nComp.setLayoutData((Object)new GridData(4, 0, true, false));
                this.nComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)2, (boolean)false));
                editor.getToolkit().adapt(this.nComp);
                Label iconLabel = editor.getToolkit().createLabel(this.nComp, "");
                iconLabel.setImage(ImageManager.getImage((OseeImage)AtsImage.NOTE));
                String hyperlinkStr = "Workflow Notes";
                String labelStr = wfNote;
                final String shortStr = Strings.truncate((String)labelStr, (int)150, (boolean)true).replaceAll("[\n\r]+", " ");
                XHyperlinkLabelValueSelection wid = new XHyperlinkLabelValueSelection(hyperlinkStr){

                    public String getCurrentValue() {
                        return shortStr;
                    }

                    public boolean handleSelection() {
                        EntryDialog ed = new EntryDialog(Displays.getActiveShell(), "View/Update Workflow Notes", null, "Enter Workflow Notes", 3, new String[]{"Remove", "Update", "Cancel"}, 2);
                        ed.setFillVertically(true);
                        ed.setEntry(wfNote);
                        int result = ed.open();
                        if (result == 0 || result == 1) {
                            IAtsChangeSet changes = AtsApiService.get().createChangeSet("Update WF Notes");
                            if (result == 0) {
                                changes.deleteAttributes((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.WorkflowNotes);
                            } else if (result == 1) {
                                changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.WorkflowNotes, ed.getEntry());
                            }
                            changes.executeIfNeeded();
                            return true;
                        }
                        return false;
                    }
                };
                wid.setEditable(true);
                wid.setToolTip("Select to View/Modify/Delete");
                wid.createWidgets(editor.getWorkFlowTab().getManagedForm(), this.nComp, 1);
            }
        }
        catch (OseeCoreException ex) {
            Label errorLabel = editor.getToolkit().createLabel((Composite)this, "Error: " + ex.getLocalizedMessage());
            errorLabel.setForeground(Displays.getSystemColor((int)3));
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public void refresh() {
        if (Widgets.isAccessible((Widget)this.nComp)) {
            this.nComp.dispose();
        }
        this.createNotes(this.workItem, this.forStateName, this.editor);
    }
}

