/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.importing.RoughArtifact;
import org.eclipse.osee.framework.skynet.core.importing.operations.RoughArtifactCollector;
import org.eclipse.osee.framework.skynet.core.importing.operations.RoughToRealArtifactOperation;
import org.eclipse.osee.framework.skynet.core.importing.operations.SourceToRoughArtifactOperation;
import org.eclipse.osee.framework.skynet.core.importing.parsers.IArtifactExtractor;
import org.eclipse.osee.framework.skynet.core.importing.resolvers.IArtifactImportResolver;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.Import.ArtifactResolverFactory;
import org.eclipse.osee.framework.ui.skynet.explorer.ArtifactExplorerDragAndDrop;

public class WfeEditorAddSupportingFiles
extends Job {
    private final Collection<File> supportingFiles;
    private final IAtsWorkItem workItem;
    private final String staticId;

    public WfeEditorAddSupportingFiles(IAtsWorkItem workItem, Collection<File> supportingFiles, String staticId) {
        super("Add Supporting Files");
        this.workItem = workItem;
        this.supportingFiles = supportingFiles;
        this.staticId = staticId;
    }

    public XResultData validate() {
        XResultData results = new XResultData();
        if (this.supportingFiles.isEmpty()) {
            results.error("Must pass in supporting files");
        }
        for (File file : this.supportingFiles) {
            if (file.exists()) continue;
            results.error("File does not exist " + file.getAbsolutePath());
        }
        return results;
    }

    public IStatus run(IProgressMonitor monitor) {
        XResultData results = this.validate();
        if (results.isErrors()) {
            throw new OseeArgumentException(results.toString(), new Object[0]);
        }
        SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)AtsApiService.get().getAtsBranch(), (String)"Import and relate supporting files");
        for (File file : this.supportingFiles) {
            IArtifactExtractor extractor = ArtifactExplorerDragAndDrop.getArtifactExtractor((ArtifactTypeToken)CoreArtifactTypes.GeneralDocument);
            RoughArtifactCollector collector = new RoughArtifactCollector(new RoughArtifact());
            IArtifactImportResolver resolver = ArtifactResolverFactory.createResolver((ArtifactResolverFactory.ArtifactCreationStrategy)ArtifactResolverFactory.ArtifactCreationStrategy.CREATE_ON_NEW_ART_GUID, (ArtifactTypeToken)CoreArtifactTypes.GeneralDocument, Arrays.asList(CoreAttributeTypes.Name), (boolean)true, (boolean)false);
            SourceToRoughArtifactOperation sourceToRoughArtifactOperation = new SourceToRoughArtifactOperation(null, extractor, file, collector);
            sourceToRoughArtifactOperation.run(null);
            Artifact workItemArt = AtsApiService.get().getQueryServiceIde().getArtifact(this.workItem);
            RoughToRealArtifactOperation roughToRealArtifactOperation = new RoughToRealArtifactOperation(transaction, workItemArt, collector, resolver, false, extractor);
            roughToRealArtifactOperation.setAddRelation(false);
            IStatus run = roughToRealArtifactOperation.run(null);
            if (!run.isOK()) {
                AWorkbench.popup((String)run.toString());
                return run;
            }
            Artifact supportingArt = (Artifact)roughToRealArtifactOperation.getCreatedArtifacts().iterator().next();
            transaction.addArtifact(supportingArt);
            workItemArt.addRelation(CoreRelationTypes.SupportingInfo_SupportingInfo, supportingArt);
            if (Strings.isValid((String)this.staticId)) {
                supportingArt.addAttribute((AttributeTypeId)CoreAttributeTypes.StaticId, (Object)this.staticId);
            }
            transaction.addArtifact(workItemArt);
        }
        transaction.execute();
        return Status.OK_STATUS;
    }
}

