/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.defects;

import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.core.review.ReviewDefectError;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.WfeAbstractTab;
import org.eclipse.osee.ats.ide.editor.tab.defects.WfeDefectsToolbar;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectContentProvider;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectData;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectLabelProvider;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectRefreshListener;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectXViewer;
import org.eclipse.osee.ats.ide.workflow.review.defect.ReviewDefectValidator;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class WfeDefectsTab
extends WfeAbstractTab
implements DefectRefreshListener {
    private Composite bodyComp;
    private ScrolledForm scrolledForm;
    public static final String ID = "ats.review.defects.tab";
    private final IAtsPeerToPeerReview review;
    private DefectXViewer xViewer;
    private WfeDefectsToolbar toolBar;
    private Label messageLabel;

    public WfeDefectsTab(WorkflowEditor editor, IAtsPeerToPeerReview review) {
        super(editor, ID, (IAtsWorkItem)review, "Defects");
        this.review = review;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.scrolledForm = managedForm.getForm();
        try {
            this.bodyComp = this.scrolledForm.getBody();
            GridLayout gridLayout = new GridLayout(1, true);
            this.bodyComp.setLayout((Layout)gridLayout);
            GridData gd = new GridData(16384, 16384, true, true);
            this.bodyComp.setLayoutData((Object)gd);
            Composite mainComp = new Composite(this.bodyComp, 2048);
            GridData gd2 = new GridData(4, 4, true, true);
            gd2.widthHint = 100;
            gd2.heightHint = 100;
            mainComp.setLayoutData((Object)gd2);
            mainComp.setLayout((Layout)ALayout.getZeroMarginLayout());
            managedForm.getToolkit().paintBordersFor(mainComp);
            this.messageLabel = new Label(mainComp, 0);
            this.messageLabel.setLayoutData((Object)new GridData(768));
            this.messageLabel.setText("");
            this.messageLabel.setForeground(Displays.getSystemColor((int)3));
            managedForm.getToolkit().adapt((Control)this.messageLabel, true, true);
            this.xViewer = new DefectXViewer(mainComp, 67586, null, this.review);
            this.xViewer.setContentProvider((IContentProvider)new DefectContentProvider(this.xViewer));
            this.xViewer.setLabelProvider((IBaseLabelProvider)new DefectLabelProvider(this.xViewer));
            this.xViewer.getTree().setLayoutData((Object)new GridData(1808));
            this.getSite().setSelectionProvider((ISelectionProvider)this.xViewer);
            this.xViewer.loadTable(this);
            this.updateTitleBar(managedForm);
            this.createToolbar(managedForm);
            FormsUtil.addHeadingGradient((FormToolkit)this.editor.getToolkit(), (ScrolledForm)managedForm.getForm(), (boolean)true);
            managedForm.reflow(true);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public void refreshMessageLabel() {
        Jobs.startJob((Job)new Job("Refresh Defect Label"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    DefectData data = new DefectData();
                    data.setError(ReviewDefectValidator.isValid(AtsApiService.get().getQueryServiceIde().getArtifact(WfeDefectsTab.this.review)));
                    WfeDefectsTab.this.refreshMessageLabel(data);
                }
                catch (Exception exception) {}
                return Status.OK_STATUS;
            }
        }, (boolean)false);
    }

    public void refreshMessageLabel(final DefectData data) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (!Widgets.isAccessible((Widget)WfeDefectsTab.this.messageLabel)) {
                        return;
                    }
                    ReviewDefectError error = data.getError();
                    if (error == ReviewDefectError.AllItemsMustBeMarkedAndClosed) {
                        WfeDefectsTab.this.messageLabel.setText("All items must be marked for severity, disposition and closed.  Select icon in cell or right-click to update field.");
                        WfeDefectsTab.this.messageLabel.setForeground(Displays.getSystemColor((int)3));
                    } else {
                        WfeDefectsTab.this.messageLabel.setText("Select \"New Defect\" to add.  Select icon in cell or right-click to update field.");
                        WfeDefectsTab.this.messageLabel.setForeground(Displays.getSystemColor((int)2));
                    }
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
    }

    @Override
    public void refresh() {
        if (this.xViewer != null) {
            this.xViewer.loadTable(this);
        }
    }

    @Override
    public void refreshCompleted(DefectData data) {
        this.xViewer.loadTable(data);
        this.refreshMessageLabel(data);
    }

    @Override
    public IToolBarManager createToolbar(IManagedForm managedForm) {
        this.toolBar = new WfeDefectsToolbar(this.scrolledForm, this.xViewer, this.review);
        this.toolBar.build();
        return super.createToolbar(managedForm);
    }
}

