/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.version;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.ChangeTypeColumn;
import org.eclipse.osee.ats.ide.config.version.VersionTeamMetrics;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.logging.OseeLog;

public class VersionMetrics {
    private final IAtsVersion verArt;
    private final VersionTeamMetrics verTeamMet;

    public VersionMetrics(IAtsVersion verArt, VersionTeamMetrics verTeamMet) {
        this.verArt = verArt;
        this.verTeamMet = verTeamMet;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.verArt.getName());
        sb.append("\n");
        try {
            sb.append("Workflows: ");
            sb.append(AtsApiService.get().getVersionService().getTargetedForTeamWorkflows(this.verArt).size());
            sb.append(" Problem: ");
            sb.append(this.getTeamWorkFlows(ChangeTypes.Problem).size());
            sb.append(" Improve: ");
            sb.append(this.getTeamWorkFlows(ChangeTypes.Improvement).size());
            sb.append(" Support: ");
            sb.append(this.getTeamWorkFlows(ChangeTypes.Support).size());
            sb.append(" Release Date: ");
            sb.append(AtsApiService.get().getVersionService().getReleaseDate(this.verArt));
            VersionMetrics prevVerMet = this.getPreviousVerMetViaReleaseDate();
            if (prevVerMet == null) {
                sb.append(" Prev Release Version: <not found>");
            } else {
                sb.append(" Prev Release Version \"");
                sb.append(prevVerMet);
                sb.append("\"   Release Date: ");
                sb.append(AtsApiService.get().getVersionService().getReleaseDate(this.verArt));
            }
            sb.append(" Start Date: ");
            sb.append(this.getReleaseStartDate());
            sb.append(" Num Days: ");
            sb.append(this.getNumberDaysInRelease());
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return sb.toString();
    }

    public Integer getNumberDaysInRelease() {
        Date startDate = this.getReleaseStartDate();
        if (startDate == null) {
            return null;
        }
        Date relDate = AtsApiService.get().getVersionService().getReleaseDate(this.verArt);
        if (relDate == null) {
            return null;
        }
        return DateUtil.getDifference((Date)startDate, (Date)relDate);
    }

    public Date getReleaseStartDate() {
        VersionMetrics prevVerMet = this.getPreviousVerMetViaReleaseDate();
        if (prevVerMet == null) {
            return null;
        }
        Date relDate = AtsApiService.get().getVersionService().getReleaseDate(this.verArt);
        return relDate;
    }

    public Collection<TeamWorkFlowArtifact> getTeamWorkFlows(ChangeTypes ... changeType) {
        List<ChangeTypes> changeTypes = Arrays.asList(changeType);
        HashSet<TeamWorkFlowArtifact> teams = new HashSet<TeamWorkFlowArtifact>();
        for (IAtsTeamWorkflow team : AtsApiService.get().getVersionService().getTargetedForTeamWorkflows(this.verArt)) {
            TeamWorkFlowArtifact teamArt = (TeamWorkFlowArtifact)team.getStoreObject();
            if (!changeTypes.contains(ChangeTypeColumn.getChangeType((IAtsWorkItem)teamArt, (AtsApi)AtsApiService.get()))) continue;
            teams.add(teamArt);
        }
        return teams;
    }

    public VersionMetrics getPreviousVerMetViaReleaseDate() {
        if (AtsApiService.get().getVersionService().getReleaseDate(this.verArt) == null) {
            return null;
        }
        int index = this.verTeamMet.getReleasedOrderedVersions().indexOf(this);
        if (index > 0) {
            return this.verTeamMet.getReleasedOrderedVersions().get(index - 1);
        }
        return null;
    }

    public VersionMetrics getNextVerMetViaReleaseDate() {
        if (AtsApiService.get().getVersionService().getReleaseDate(this.verArt) == null) {
            return null;
        }
        int index = this.verTeamMet.getReleasedOrderedVersions().indexOf(this);
        if (index < this.verTeamMet.getReleasedOrderedVersions().size() - 1) {
            return this.verTeamMet.getReleasedOrderedVersions().get(index + 1);
        }
        return null;
    }

    public IAtsVersion getVerArt() {
        return this.verArt;
    }
}

