/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Collection;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class PercentCompleteTasksReviewsColumn
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static PercentCompleteTasksReviewsColumn instance = new PercentCompleteTasksReviewsColumn();

    public static PercentCompleteTasksReviewsColumn getInstance() {
        return instance;
    }

    private PercentCompleteTasksReviewsColumn() {
        super("ats.column.taskReviewPercentComplete", "Task and Review Percent Complete", 40, XViewerAlign.Center, false, SortDataType.Percent, false, "Percent Complete for the tasks and reviews related to the workflow.\n\nCalculation: total percent of all tasks and reviews / number of tasks and reviews");
    }

    public PercentCompleteTasksReviewsColumn copy() {
        PercentCompleteTasksReviewsColumn newXCol = new PercentCompleteTasksReviewsColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            if (element instanceof IAtsObject && ((IAtsObject)element).isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow, AtsArtifactTypes.Action})) {
                return String.valueOf(PercentCompleteTasksReviewsColumn.getPercentCompleteFromTasksAndReviews(AtsApiService.get().getQueryServiceIde().getArtifact(element)));
            }
        }
        catch (OseeCoreException ex) {
            return LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return "";
    }

    public static int getPercentCompleteFromTasksAndReviews(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
            double percent = 0.0;
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams((Object)artifact)) {
                if (team.isCancelled()) continue;
                percent += (double)PercentCompleteTasksReviewsColumn.getPercentCompleteFromTasksAndReviews(AtsApiService.get().getQueryServiceIde().getArtifact(team));
            }
            if (percent == 0.0) {
                return 0;
            }
            Double rollPercent = percent / (double)AtsApiService.get().getWorkItemService().getTeams((Object)artifact).size();
            return rollPercent.intValue();
        }
        int spent = 0;
        int size = 0;
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            Collection tasks = AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)((TeamWorkFlowArtifact)artifact));
            for (IAtsTask task : tasks) {
                spent += AtsApiService.get().getWorkItemMetricsService().getPercentCompleteTotal((IAtsObject)task);
            }
            size = tasks.size();
            TeamWorkFlowArtifact teamWf = (TeamWorkFlowArtifact)artifact;
            Collection reviewArts = AtsApiService.get().getReviewService().getReviews((IAtsTeamWorkflow)teamWf);
            for (IAtsAbstractReview reviewArt : reviewArts) {
                spent += AtsApiService.get().getWorkItemMetricsService().getPercentCompleteTotal((IAtsObject)reviewArt);
            }
            size += reviewArts.size();
        }
        if (size == 0) {
            return 0;
        }
        return spent / size;
    }
}

