/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IAltLeftClickProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractNumericTotalColumn
extends XViewerAtsColumn
implements IXViewerValueColumn,
IAltLeftClickProvider {
    private final String calulationStr;
    private final AttributeTypeToken pointsAttrType;

    public AbstractNumericTotalColumn(String id, String name, String description, String calulationStr, AttributeTypeToken pointsAttrType) {
        super(id, name, 40, XViewerAlign.Center, false, SortDataType.Float, false, description);
        this.calulationStr = calulationStr;
        this.pointsAttrType = pointsAttrType;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        if (element instanceof AbstractWorkflowArtifact) {
            return AtsUtil.doubleToI18nString((double)this.getRemainingPoints(element));
        }
        if (element instanceof IAtsWorkItem) {
            return this.getColumnText(((IAtsWorkItem)element).getStoreObject(), column, columnIndex);
        }
        return "";
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        try {
            AbstractWorkflowArtifact aba = null;
            if (treeItem.getData() instanceof AbstractWorkflowArtifact) {
                aba = (AbstractWorkflowArtifact)((Object)treeItem.getData());
            } else if (Artifacts.isOfType((Object)treeItem.getData(), (ArtifactTypeToken)AtsArtifactTypes.Action) && AtsApiService.get().getWorkItemService().getTeams(treeItem.getData()).size() == 1) {
                aba = (AbstractWorkflowArtifact)AtsApiService.get().getWorkItemService().getFirstTeam(treeItem.getData()).getStoreObject();
            }
            if (aba != null) {
                AWorkbench.popup((String)"Calculated Field", (String)(String.valueOf(this.getDescription()) + "\n\n" + this.calulationStr));
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    private double getRemainingPoints(Object object) {
        if (object instanceof AbstractWorkflowArtifact) {
            return this.getRemainPointsFromArtifact((IAtsWorkItem)object);
        }
        if (Artifacts.isOfType((Object)object, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
            double hours = 0.0;
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams(object)) {
                hours += this.getRemainingPoints(team);
            }
            return hours;
        }
        return 0.0;
    }

    private double getRemainPointsFromArtifact(IAtsWorkItem workItem) {
        if (workItem.getCurrentStateType().isCompletedOrCancelled()) {
            return 0.0;
        }
        double est = this.getTotalPoints(workItem);
        if (est > 0.0) {
            int percentComplete = this.getPercentComplete(workItem);
            est -= est * (double)percentComplete / 100.0;
        }
        return est;
    }

    private double getTotalPoints(IAtsWorkItem workItem) {
        IAttributeResolver attributeResolver = AtsApiService.get().getAttributeResolver();
        double est = this.pointsAttrType.isDouble() ? ((Double)attributeResolver.getSoleAttributeValue((IAtsObject)workItem, this.pointsAttrType, (Object)0.0)).doubleValue() : Double.valueOf((String)attributeResolver.getSoleAttributeValue((IAtsObject)workItem, this.pointsAttrType, (Object)"0")).doubleValue();
        return est;
    }

    protected abstract int getPercentComplete(IAtsWorkItem var1);
}

