/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile.navigate;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.agile.jira.JiraByEpicData;
import org.eclipse.osee.ats.ide.agile.navigate.AgileNavigateItemProvider;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;

public class SyncJiraAndOseeByEpicBlam
extends AbstractBlam {
    private static final String NAME = "Sync JIRA by Epic";

    public String getName() {
        return NAME;
    }

    public IOperation createOperation(VariableMap variableMap, OperationLogger logger) throws Exception {
        return new AbstractOperation(this.getName(), "org.eclipse.osee.ats.ide", logger, variableMap){
            final String tabDelimStr;
            {
                this.tabDelimStr = variableMap.getString("Jira by Epic Query Results");
            }

            protected void doWork(IProgressMonitor monitor) throws Exception {
                JiraByEpicData data = new JiraByEpicData();
                data.setTabDelimReport(this.tabDelimStr);
                data = AtsApiService.get().getServerEndpoints().getActionEndpoint().reportEpicDiffsByEpic(data);
                XResultDataUI.report((XResultData)data.getResults(), (String)this.getName());
            }
        };
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(AgileNavigateItemProvider.AGILE);
    }

    public String getXWidgetsXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<xWidgets>");
        sb.append("<XWidget xwidgetType=\"XText\" fill=\"Vertically\" displayName=\"Jira by Epic Query Results\" />");
        sb.append("</xWidgets>");
        return sb.toString();
    }

    public String getDescriptionUsage() {
        return "Copy/Paste JIRA report by epic and team from exported Excel spreadsheet.\nReturns differences between JIRA and OSEE for resulting entries.\nReport should have Summary, ID, Epic Link, Description, Status, Story Points columns";
    }
}

