/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.util.AtsEditor;
import org.eclipse.osee.ats.ide.world.search.MultipleIdSearchData;
import org.eclipse.osee.ats.ide.world.search.MultipleIdSearchOperation;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Event;

public class OpenWorkflowByIdAction
extends Action {
    private String overrideId = null;
    private boolean pend = false;

    public void setPend(boolean pend) {
        this.pend = pend;
    }

    public OpenWorkflowByIdAction() {
        this("Open Workflow Editor by ID(s)");
    }

    public OpenWorkflowByIdAction(String name) {
        super(name);
        this.setToolTipText(String.valueOf(this.getText()) + "\nClick to open dialog OR\nCtrl-Click to search ID(s) in clipboard");
    }

    public void run() {
        MultipleIdSearchData data = new MultipleIdSearchData(this.getText(), AtsEditor.WorkflowEditor);
        if (Strings.isValid((String)this.overrideId)) {
            data.setEnteredIds(this.overrideId);
        }
        MultipleIdSearchOperation operation = new MultipleIdSearchOperation(data);
        if (this.pend) {
            try {
                Operations.executeWorkAndCheckStatus((IOperation)operation);
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        } else {
            Operations.executeAsJob((IOperation)operation, (boolean)true);
        }
    }

    public void runWithEvent(Event event) {
        MultipleIdSearchData data = null;
        if ((event.stateMask & SWT.MODIFIER_MASK) == 262144) {
            Clipboard clipboard = new Clipboard(AWorkbench.getDisplay());
            String str = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
            if (Strings.isValid((String)str)) {
                data = new MultipleIdSearchData(this.getText(), AtsEditor.WorkflowEditor);
                data.setEnteredIds(str);
            }
        } else {
            data = new MultipleIdSearchData(this.getText(), AtsEditor.WorkflowEditor);
            if (Strings.isValid((String)this.overrideId)) {
                data.setEnteredIds(this.overrideId);
            }
        }
        MultipleIdSearchOperation operation = new MultipleIdSearchOperation(data);
        if (this.pend) {
            try {
                Operations.executeWorkAndCheckStatus((IOperation)operation);
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        } else {
            Operations.executeAsJob((IOperation)operation, (boolean)true);
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.WORKFLOW);
    }

    public void setOverrideId(String overrideId) {
        this.overrideId = overrideId;
    }
}

