/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class CopyActionDetailsAction
extends Action {
    private final IAtsWorkItem workItem;
    private final AtsApi atsApi;

    public CopyActionDetailsAction(IAtsWorkItem workItem, AtsApi atsApi) {
        this.workItem = workItem;
        this.atsApi = atsApi;
        this.setText("Copy " + workItem.getArtifactTypeName() + " details to clipboard");
        this.setToolTipText(this.getText());
    }

    private void performCopy() {
        Clipboard clipboard = new Clipboard(null);
        try {
            String detailsStr = this.atsApi.getWorkItemService().getCopyActionDetails(this.workItem);
            clipboard.setContents(new Object[]{detailsStr}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            clipboard.dispose();
        }
    }

    public void run() {
        this.performCopy();
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.COPY_TO_CLIPBOARD);
    }
}

