/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.hooks;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.logging.OseeLog;

public class AtsWriteDiffWhenCompleteHook
implements IAtsTransitionHook {
    public String getName() {
        return AtsWriteDiffWhenCompleteHook.class.getSimpleName();
    }

    public String getDescription() {
        return "When the Workflow is transitioned to Completed, write an attribute with the diff information";
    }

    public void transitioned(IAtsWorkItem workItem, IStateToken fromState, IStateToken toState, Collection<? extends AtsUser> toAssignees, AtsUser asUser, IAtsChangeSet changes) {
        try {
            if (workItem instanceof IAtsTeamWorkflow && workItem.isWorkType(WorkType.Requirements) && toState.getStateType().isCompleted()) {
                BranchToken branch = AtsApiService.get().getBranchService().getWorkingBranch((IAtsTeamWorkflow)workItem, true);
                if (AtsApiService.get().getBranchService().branchExists((BranchId)branch) && branch != null && branch.isValid()) {
                    IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
                    List changeItems = AtsApiService.get().getBranchService().getChangeData((BranchId)branch);
                    if (!changeItems.isEmpty()) {
                        String changeItemJson = JsonUtil.toJson((Object)changeItems);
                        if (AtsApiService.get().getAttributeResolver().getAttributeCount((IAtsWorkItem)teamWf, (AttributeTypeToken)CoreAttributeTypes.BranchDiffData) == 0) {
                            changes.addAttribute((IAtsObject)workItem, (AttributeTypeToken)CoreAttributeTypes.BranchDiffData, (Object)changeItemJson);
                        } else if (!((String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)CoreAttributeTypes.BranchDiffData, (Object)"")).equals(changeItemJson)) {
                            changes.setSoleAttributeFromString((IAtsObject)workItem, (AttributeTypeGeneric)CoreAttributeTypes.BranchDiffData, changeItemJson);
                            AtsApiService.get().getAttributeResolver().setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)CoreAttributeTypes.BranchDiffData, (Object)changeItemJson);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(AtsWriteDiffWhenCompleteHook.class, (Level)Level.WARNING, (String)"Error setting Branch Diff Data JSON", (Throwable)ex);
        }
    }
}

