/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.hooks;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.PeerToPeerReviewState;
import org.eclipse.osee.ats.api.review.UserRole;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.review.UserRoleManager;

public class AtsPeerToPeerReviewReviewWorkItemHook
implements IAtsTransitionHook {
    public String getName() {
        return AtsPeerToPeerReviewReviewWorkItemHook.class.getSimpleName();
    }

    public String getDescription() {
        return "Assign review state to all members of review as per role in prepare state.";
    }

    public void transitioned(IAtsWorkItem workItem, IStateToken fromState, IStateToken toState, Collection<? extends AtsUser> toAssignees, AtsUser asUser, IAtsChangeSet changes) {
        if (workItem instanceof IAtsPeerToPeerReview && toState.getName().equals(PeerToPeerReviewState.Review.getName())) {
            HashSet<AtsUser> assignees = new HashSet<AtsUser>();
            IAtsPeerToPeerReview peerRev = (IAtsPeerToPeerReview)workItem;
            for (UserRole uRole : peerRev.getRoleManager().getUserRoles()) {
                if (uRole.isCompleted()) continue;
                assignees.add(UserRoleManager.getUser(uRole, AtsApiService.get()));
            }
            assignees.addAll(workItem.getStateMgr().getAssignees());
            workItem.getStateMgr().setAssignees(assignees);
            changes.add((Object)workItem);
        }
    }
}

