/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.hooks;

import java.util.Collection;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResult;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public class AtsHoldOrBlockedTransitionHook
implements IAtsTransitionHook {
    public String getName() {
        return AtsHoldOrBlockedTransitionHook.class.getSimpleName();
    }

    public String getDescription() {
        return "Can not transition with hold or blocked set.";
    }

    public void transitioning(TransitionResults results, IAtsWorkItem workItem, IStateToken fromState, IStateToken toState, Collection<? extends AtsUser> toAssignees, AtsUser asUser) {
        boolean isHold;
        boolean isBlocked = workItem.getAtsApi().getWorkItemService().isBlocked(workItem);
        if (isBlocked) {
            String reason = (String)workItem.getAtsApi().getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.BlockedReason, (Object)"unknown");
            results.addResult(new TransitionResult("Can not transition a Blocked Workflow.\nBlock Reason: [%s]", new Object[]{reason}));
        }
        if (isHold = workItem.getAtsApi().getWorkItemService().isOnHold(workItem)) {
            String reason = (String)workItem.getAtsApi().getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.HoldReason, (Object)"");
            results.addResult(new TransitionResult("Can not transition a Workflow on Hold.\nHold Reason: [%s]", new Object[]{reason}));
        }
    }
}

