/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.task;

import java.util.Collection;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsTaskDefToken;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskData;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinitionBuilder;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.task.CreateChangeReportTasksOperation;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public class CreateChangeReportTaskTransitionHook
implements IAtsTransitionHook {
    private final AtsTaskDefToken taskDefToken;

    public CreateChangeReportTaskTransitionHook(AtsTaskDefToken taskDefToken) {
        this.taskDefToken = taskDefToken;
    }

    public void transitioned(final IAtsWorkItem workItem, IStateToken fromState, IStateToken toState, Collection<? extends AtsUser> toAssignees, final AtsUser asUser, final IAtsChangeSet changes) {
        if (!workItem.isTeamWorkflow()) {
            return;
        }
        if (!toState.getStateType().isCompleted()) {
            return;
        }
        Thread thread = new Thread("Create/Update Tasks"){

            @Override
            public void run() {
                ChangeReportTaskData data;
                CreateTasksDefinitionBuilder taskSetDefinition = AtsApiService.get().getTaskSetDefinitionProviderService().getTaskSetDefinition(CreateChangeReportTaskTransitionHook.this.taskDefToken);
                if (taskSetDefinition != null && taskSetDefinition.getCreateTasksDef().getHelper().isApplicable(workItem, AtsApiService.get()) && (data = CreateChangeReportTaskTransitionHook.runChangeReportTaskOperation(workItem, CreateChangeReportTaskTransitionHook.this.taskDefToken, true, changes, asUser)).getResults().isErrors()) {
                    throw new OseeArgumentException(data.getResults().toString(), new Object[0]);
                }
            }
        };
        if (AtsUtil.isInTest()) {
            thread.run();
        } else {
            thread.start();
        }
    }

    public static ChangeReportTaskData runChangeReportTaskOperation(IAtsWorkItem workItem, AtsTaskDefToken taskDefToken, boolean finalTaskGen, IAtsChangeSet changes, AtsUser asUser) {
        ChangeReportTaskData data = new ChangeReportTaskData();
        data.setTaskDefToken(taskDefToken);
        data.setHostTeamWf(workItem.getStoreObject());
        data.setAsUser(asUser);
        data.setFinalTaskGen(finalTaskGen);
        CreateChangeReportTasksOperation operation = new CreateChangeReportTasksOperation(data, AtsApiService.get(), changes);
        operation.run();
        return data;
    }

    public String getDescription() {
        return "Checks for and runs Change Report Task Set Definitions during tranisition";
    }
}

