/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.Date;
import java.util.HashSet;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.AbstractServicesColumn;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;

public class CreatedDateColumn
extends AbstractServicesColumn {
    public CreatedDateColumn(AtsApi atsApi) {
        super(atsApi);
    }

    @Override
    public String getText(IAtsObject atsObject) throws Exception {
        return CreatedDateColumn.getDateStr(atsObject);
    }

    public static Date getDate(Object object) {
        Date result = null;
        if (object instanceof IAtsAction) {
            IAtsAction action = (IAtsAction)object;
            if (!action.getTeamWorkflows().isEmpty()) {
                result = CreatedDateColumn.getDate(action.getTeamWorkflows().iterator().next());
            }
        } else if (object instanceof IAtsWorkItem) {
            result = ((IAtsWorkItem)object).getCreatedDate();
        }
        return result;
    }

    public static String getDateStr(Object object) {
        HashSet<String> strs = new HashSet<String>();
        if (object instanceof IAtsAction) {
            IAtsAction action = (IAtsAction)object;
            for (IAtsTeamWorkflow team : action.getTeamWorkflows()) {
                Date date = CreatedDateColumn.getDate(team);
                if (date == null) {
                    strs.add("");
                    continue;
                }
                strs.add(DateUtil.getMMDDYYHHMM((Date)CreatedDateColumn.getDate(team)));
            }
            return Collections.toString((String)";", strs);
        }
        return DateUtil.getMMDDYYHHMM((Date)CreatedDateColumn.getDate(object));
    }
}

