/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.AbstractServicesColumn;
import org.eclipse.osee.ats.core.internal.AtsApiService;

public class ActionableItemsColumn
extends AbstractServicesColumn {
    public ActionableItemsColumn(AtsApi atsApi) {
        super(atsApi);
    }

    @Override
    public String getText(IAtsObject atsObject) throws Exception {
        return this.getActionableItemsStr(atsObject);
    }

    public String getActionableItemsStr(IAtsObject atsObject) {
        StringBuilder sb = new StringBuilder();
        for (IAtsActionableItem ai : ActionableItemsColumn.getActionableItems(atsObject)) {
            sb.append(ai.getName());
            sb.append(", ");
        }
        return sb.toString().replace(", $", "");
    }

    public static Collection<IAtsActionableItem> getActionableItems(IAtsObject atsObject) {
        if (atsObject instanceof IAtsTeamWorkflow) {
            return AtsApiService.get().getActionableItemService().getActionableItems((IAtsWorkItem)((IAtsTeamWorkflow)atsObject));
        }
        return Collections.emptyList();
    }
}

