/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.agile.IAgileProgram;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.core.model.impl.AtsConfigObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.logger.Log;

public class AgileProgram
extends AtsConfigObject
implements IAgileProgram {
    public AgileProgram(Log logger, AtsApi atsApi, ArtifactToken artifact) {
        super(logger, atsApi, artifact, AtsArtifactTypes.AgileProgram);
    }

    public List<Long> getTeamIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ArtifactToken child : this.atsApi.getRelationResolver().getChildren((ArtifactId)this.artifact)) {
            if (!child.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileTeam})) continue;
            ids.add(child.getId());
        }
        return ids;
    }

    public static IAgileProgram construct(ArtifactId progArt, AtsApi atsApi) {
        return new AgileProgram(atsApi.getLogger(), atsApi, atsApi.getQueryService().getArtifact(progArt));
    }
}

