/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.utilities;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.ote.define.TestRunField;
import org.eclipse.osee.ote.define.artifacts.OteToAttributeMap;
import org.eclipse.osee.ote.define.internal.Activator;
import org.eclipse.osee.ote.define.parser.IDataListener;

public class OutfileDataCollector
implements IDataListener {
    protected static final OteToAttributeMap oteToAttributeMap = OteToAttributeMap.getInstance();
    protected final Map<String, String> collectedData = new HashMap<String, String>();

    @Override
    public void notifyDataEvent(String name, String value) {
        this.collectedData.put(name, value);
    }

    public void populate(Artifact artifact, Artifact parent) {
        Conditions.checkNotNull((Object)artifact, (String)"artifact");
        Conditions.checkNotNull((Object)parent, (String)"parent");
        for (String fieldName : this.collectedData.keySet()) {
            AttributeTypeId attributeType = oteToAttributeMap.getAttributeType(fieldName);
            if (attributeType == null || !artifact.isAttributeTypeValid(attributeType)) continue;
            try {
                String value = this.collectedData.get(fieldName);
                Object object = oteToAttributeMap.asTypedObject(attributeType, value);
                artifact.setSoleAttributeValue(attributeType, object);
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        artifact.setName(this.getField(TestRunField.SCRIPT_NAME.name()));
        parent.addChild(artifact);
    }

    public String getField(String name) {
        String toReturn = this.collectedData.get(name);
        return Strings.isValid((String)toReturn) ? toReturn : "";
    }
}

