/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.osee.framework.jdk.core.util.Message;

public class ListMap<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 64;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_MIN_SPLIT_SIZE = 128;
    private int cursor;
    private final Function<V, K> keyExtractor;
    private final ArrayList<Element<K, V>> list;
    private final HashMap<K, Element<K, V>> map;
    private final int minSplitSize;
    private long safety;

    public ListMap() {
        this(64, 0.75f, 128, null);
    }

    public ListMap(int initialCapacity, float loadFactor, int minimumSplitSize) {
        this(initialCapacity, loadFactor, minimumSplitSize, null);
    }

    public ListMap(int initialCapacity, float loadFactor, int minSplitSize, Function<V, K> keyExtractor) {
        if (minSplitSize < 1) {
            throw new IllegalArgumentException("ListMap::new, the parameter \"minSpitSize\" cannot be less than 1.");
        }
        this.map = new HashMap(initialCapacity, loadFactor);
        this.list = new ArrayList(initialCapacity);
        this.minSplitSize = minSplitSize;
        this.cursor = -1;
        this.safety = 0L;
        this.keyExtractor = keyExtractor;
    }

    public Stream<Element<K, V>> backwardsStream(boolean parallel) {
        return this.getBackwardsSpliterator().map(spliterator -> StreamSupport.stream(spliterator, parallel)).orElse(Stream.empty());
    }

    public Stream<Element<K, V>> backwardsStream(int index, boolean parallel) {
        return this.getBackwardsSpliterator((K)index).map(spliterator -> StreamSupport.stream(spliterator, parallel)).orElse(Stream.empty());
    }

    public Stream<Element<K, V>> backwardsStream(K key, boolean parallel) {
        return this.getBackwardsSpliterator(key).map(spliterator -> StreamSupport.stream(spliterator, parallel)).orElse(Stream.empty());
    }

    public Stream<Element<K, V>> forwardStream(boolean parallel) {
        return this.getForwardSpliterator().map(spliterator -> StreamSupport.stream(spliterator, parallel)).orElse(Stream.empty());
    }

    public Stream<Element<K, V>> forwardStream(int index, boolean parallel) {
        return this.getForwardSpliterator((K)index).map(spliterator -> StreamSupport.stream(spliterator, parallel)).orElse(Stream.empty());
    }

    public Stream<Element<K, V>> forwardStream(K key, boolean parallel) {
        return this.getForwardSpliterator(key).map(spliterator -> StreamSupport.stream(spliterator, parallel)).orElse(Stream.empty());
    }

    public Optional<V> get(int index) {
        if (this.outOfBounds(index)) {
            this.cursor = -1;
            return Optional.empty();
        }
        Element<K, V> element = this.list.get(index);
        this.cursor = index;
        return Optional.of(element.getValue());
    }

    public Optional<V> get(K key) {
        if (Objects.isNull(key)) {
            return Optional.empty();
        }
        Element<K, V> element = this.map.get(key);
        if (Objects.isNull(element)) {
            this.cursor = -1;
            return Optional.empty();
        }
        this.cursor = element.getPosition();
        assert (this.inBounds(this.cursor)) : new Message().title("ListMap::get, position from an element is out of bounds.").indentInc().segment((CharSequence)"Element", element).toString();
        return Optional.of(element.getValue());
    }

    public Optional<Spliterator<Element<K, V>>> getBackwardsSpliterator() {
        Spliterator<Element<K, V>> spliterator = this.getBackwardsSpliterator(this.list.size() - 1, 0, this.safety);
        return Optional.ofNullable(spliterator);
    }

    public Optional<Spliterator<Element<K, V>>> getBackwardsSpliterator(int index) {
        if (this.outOfBounds(index)) {
            return Optional.empty();
        }
        Spliterator<Element<K, V>> spliterator = this.getBackwardsSpliterator(index, 0, this.safety);
        return Optional.ofNullable(spliterator);
    }

    private Spliterator<Element<K, V>> getBackwardsSpliterator(int start, int end, long safetyMark) {
        if (start < 0 || start >= this.list.size() || end > start || end < 0) {
            return null;
        }
        Spliterator spliterator = new Spliterator<Element<K, V>>(start, end, safetyMark){
            private Element<K, V> currentElement;
            private Element<K, V> lastElement;
            private final long safety;
            {
                this.currentElement = ListMap.this.list.get(n);
                this.lastElement = ListMap.this.list.get(n2);
                this.safety = l;
            }

            @Override
            public int characteristics() {
                this.checkSafety();
                return 16720;
            }

            private void checkSafety() {
                if (this.safety != ListMap.this.safety) {
                    throw new ConcurrentModificationException("A ListMap forwared spliterator detected a modification of the ListMap.");
                }
            }

            @Override
            public long estimateSize() {
                this.checkSafety();
                return this.currentElement.getPosition() - this.lastElement.getPosition() + 1;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Element<K, V>> action) {
                this.checkSafety();
                if (Objects.isNull(this.currentElement)) {
                    return false;
                }
                action.accept(this.currentElement);
                if (this.currentElement == this.lastElement) {
                    this.currentElement = null;
                    return true;
                }
                int position = this.currentElement.getPosition();
                this.currentElement = ListMap.this.list.get(--position);
                return true;
            }

            @Override
            public Spliterator<Element<K, V>> trySplit() {
                this.checkSafety();
                int c = this.currentElement.getPosition();
                int l = this.lastElement.getPosition();
                int r = c - l + 1;
                int h = r >>> 1;
                if (h < ListMap.this.minSplitSize) {
                    return null;
                }
                int ac = c;
                int al = c - h + 1;
                int bc = c - h;
                int bl = l;
                this.currentElement = ListMap.this.list.get(bc);
                this.lastElement = ListMap.this.list.get(bl);
                return ListMap.this.getBackwardsSpliterator(ac, al, this.safety);
            }
        };
        return spliterator;
    }

    public Optional<Spliterator<Element<K, V>>> getBackwardsSpliterator(K key) {
        Element<K, V> element = this.map.get(key);
        if (Objects.isNull(element)) {
            return Optional.empty();
        }
        int index = element.getPosition();
        return this.getBackwardsSpliterator((K)index);
    }

    public Optional<V> getCurrent() {
        if (this.outOfBounds(this.cursor)) {
            this.cursor = -1;
            return Optional.empty();
        }
        Element<K, V> element = this.list.get(this.cursor);
        assert (element.getPosition() == this.cursor) : new Message().title("ListMap::getCurrent, position from element at cursor does not match cursor position.").indentInc().segment((CharSequence)"Cursor Position", this.cursor).segment((CharSequence)"Element", element).toString();
        return Optional.of(element.getValue());
    }

    public Optional<K> getCurrentKey() {
        if (this.outOfBounds(this.cursor)) {
            this.cursor = -1;
            return Optional.empty();
        }
        Element<K, V> element = this.list.get(this.cursor);
        assert (element.getPosition() == this.cursor) : new Message().title("ListMap::getCurrentKey, position from element at cursor does not match cursor position.").indentInc().segment((CharSequence)"Cursor Position", this.cursor).segment((CharSequence)"Element", element).toString();
        return Optional.of(element.getKey());
    }

    public int getCurrentPosition() {
        return this.inBounds(this.cursor) ? this.cursor : (this.cursor = -1);
    }

    public Optional<V> getFirst() {
        if (this.list.isEmpty()) {
            this.cursor = -1;
            return Optional.empty();
        }
        Element<K, V> element = this.list.get(0);
        assert (element.getPosition() == 0) : new Message().title("ListMap::getFirst, position from element at start of list is not zero.").indentInc().segment((CharSequence)"Element", element).toString();
        this.cursor = element.getPosition();
        return Optional.of(element.getValue());
    }

    public Optional<Spliterator<Element<K, V>>> getForwardSpliterator() {
        Spliterator<Element<K, V>> spliterator = this.getForwardSpliterator(0, this.list.size() - 1, this.safety);
        return Optional.ofNullable(spliterator);
    }

    public Optional<Spliterator<Element<K, V>>> getForwardSpliterator(int index) {
        if (this.outOfBounds(index)) {
            return Optional.empty();
        }
        Spliterator<Element<K, V>> spliterator = this.getForwardSpliterator(index, this.list.size() - 1, this.safety);
        return Optional.ofNullable(spliterator);
    }

    private Spliterator<Element<K, V>> getForwardSpliterator(int start, int end, long safetyMark) {
        if (this.outOfBounds(start) || this.outOfBounds(end) || end < start) {
            throw new IndexOutOfBoundsException();
        }
        Spliterator spliterator = new Spliterator<Element<K, V>>(start, end, safetyMark){
            private Element<K, V> currentElement;
            private Element<K, V> lastElement;
            private final long safety;
            {
                this.currentElement = ListMap.this.list.get(n);
                this.lastElement = ListMap.this.list.get(n2);
                this.safety = l;
            }

            @Override
            public int characteristics() {
                this.checkSafety();
                return 16720;
            }

            private void checkSafety() {
                if (this.safety != ListMap.this.safety) {
                    throw new ConcurrentModificationException("A ListMap forwared spliterator detected a modification of the ListMap.");
                }
            }

            @Override
            public long estimateSize() {
                this.checkSafety();
                return this.lastElement.getPosition() - this.currentElement.getPosition() - 1;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Element<K, V>> action) {
                this.checkSafety();
                if (Objects.isNull(this.currentElement)) {
                    return false;
                }
                action.accept(this.currentElement);
                if (this.currentElement == this.lastElement) {
                    this.currentElement = null;
                    return true;
                }
                int position = this.currentElement.getPosition();
                this.currentElement = ListMap.this.list.get(++position);
                return true;
            }

            @Override
            public Spliterator<Element<K, V>> trySplit() {
                this.checkSafety();
                int c = this.currentElement.getPosition();
                int l = this.lastElement.getPosition();
                int r = l - c + 1;
                int h = r >>> 1;
                if (h < ListMap.this.minSplitSize) {
                    return null;
                }
                int ac = c;
                int al = c + h - 1;
                int bc = c + h;
                int bl = l;
                this.currentElement = ListMap.this.list.get(bc);
                this.lastElement = ListMap.this.list.get(bl);
                return ListMap.this.getForwardSpliterator(ac, al, this.safety);
            }
        };
        return spliterator;
    }

    public Optional<Spliterator<Element<K, V>>> getForwardSpliterator(K key) {
        Element<K, V> element = this.map.get(key);
        if (Objects.isNull(element)) {
            return Optional.empty();
        }
        int index = element.getPosition();
        return this.getForwardSpliterator((K)index);
    }

    public Optional<V> getLast() {
        if (this.list.isEmpty()) {
            this.cursor = -1;
            return Optional.empty();
        }
        Element<K, V> element = this.list.get(this.list.size() - 1);
        this.cursor = element.getPosition();
        return Optional.of(element.getValue());
    }

    public Optional<V> getNext() {
        if (this.outOfBoundsOrAtEnd(this.cursor)) {
            this.cursor = -1;
            return Optional.empty();
        }
        Element<K, V> element = this.list.get(++this.cursor);
        return Optional.of(element.getValue());
    }

    public Optional<V> getNext(int index) {
        if (this.outOfBoundsOrAtEnd(index)) {
            this.cursor = -1;
            return Optional.empty();
        }
        this.cursor = index + 1;
        Element<K, V> element = this.list.get(this.cursor);
        return Optional.of(element.getValue());
    }

    public Optional<V> getNext(K key) {
        Element<K, V> element = this.map.get(key);
        if (Objects.isNull(element)) {
            this.cursor = -1;
            return Optional.empty();
        }
        int position = element.getPosition();
        if (this.outOfBoundsOrAtEnd(position)) {
            this.cursor = -1;
            return Optional.empty();
        }
        this.cursor = position + 1;
        element = this.list.get(this.cursor);
        return Optional.of(element.getValue());
    }

    public Optional<V> getPrevious() {
        if (this.outOfBoundsOrAtStart(this.cursor)) {
            this.cursor = -1;
            return Optional.empty();
        }
        Element<K, V> element = this.list.get(--this.cursor);
        return Optional.of(element.getValue());
    }

    public Optional<V> getPrevious(int index) {
        if (this.outOfBoundsOrAtStart(index)) {
            this.cursor = -1;
            return Optional.empty();
        }
        this.cursor = index - 1;
        Element<K, V> element = this.list.get(this.cursor);
        return Optional.of(element.getValue());
    }

    public Optional<V> getPrevious(K key) {
        Element<K, V> element = this.map.get(key);
        if (Objects.isNull(element)) {
            this.cursor = -1;
            return Optional.empty();
        }
        int position = element.getPosition();
        if (this.outOfBoundsOrAtStart(position)) {
            this.cursor = -1;
            return Optional.empty();
        }
        this.cursor = position - 1;
        element = this.list.get(this.cursor);
        return Optional.of(element.getValue());
    }

    private boolean inBounds(int index) {
        return index >= 0 && index < this.list.size();
    }

    private boolean outOfBounds(int index) {
        return index < 0 || index >= this.list.size();
    }

    private boolean outOfBoundsOrAtEnd(int index) {
        return this.outOfBounds(index) || index == this.list.size() - 1;
    }

    private boolean outOfBoundsOrAtStart(int index) {
        return this.outOfBounds(index) || index == 0;
    }

    public Optional<V> put(K key, V value) {
        Objects.requireNonNull(key, "ListMap::put, parameter \"key\" cannot be null.");
        Objects.requireNonNull(value, "ListMap::put parameter \"value\" cannot be null.");
        Element<K, V> oldElement = this.map.get(key);
        if (Objects.nonNull(oldElement)) {
            int position = oldElement.getPosition();
            Element<K, V> element = new Element<K, V>(key, value, position);
            this.map.put(key, element);
            this.list.set(position, element);
            ++this.safety;
            this.cursor = position;
            return Optional.of(oldElement.getValue());
        }
        int position = this.list.size();
        Element<K, V> element = new Element<K, V>(key, value, position);
        this.map.put(key, element);
        this.list.add(element);
        ++this.safety;
        this.cursor = position;
        return Optional.empty();
    }

    public Optional<V> put(V value) {
        if (Objects.isNull(this.keyExtractor)) {
            throw new UnsupportedOperationException("ListMap::put(V value), a key extractor function is not available.");
        }
        Objects.requireNonNull(value, "ListMap::put parameter \"value\" cannot be null.");
        return this.put(this.keyExtractor.apply(value), value);
    }

    public int size() {
        return this.list.size();
    }

    public static class Element<K, V> {
        private final K key;
        private final int position;
        private final V value;

        Element(K key, V value, int position) {
            this.key = Objects.requireNonNull(key, "ListMap.Element::new, null keys are not allowed.");
            this.value = Objects.requireNonNull(value, "ListMap.Element::new, null values are not allowed.");
            if (position < 0) {
                throw new IndexOutOfBoundsException("ListMap.Element::new, position is less than zero.");
            }
            this.position = position;
        }

        public K getKey() {
            return this.key;
        }

        int getPosition() {
            return this.position;
        }

        public V getValue() {
            return this.value;
        }
    }
}

