/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.type.Pair;

public class CompositeKeyHashMap<KeyOne, KeyTwo, Value>
implements Map<Pair<KeyOne, KeyTwo>, Value> {
    private final HashCollectionSet<KeyOne, KeyTwo> singleKeyMap;
    private final Map<Pair<KeyOne, KeyTwo>, Value> map;
    private final ThreadLocal<Pair<KeyOne, KeyTwo>> threadLocalKey = new ThreadLocal<Pair<KeyOne, KeyTwo>>(){

        @Override
        protected Pair<KeyOne, KeyTwo> initialValue() {
            return new Pair<Object, Object>(null, null);
        }
    };

    public CompositeKeyHashMap() {
        this(50, false);
    }

    public CompositeKeyHashMap(int initialCapacity, boolean isThreadSafe) {
        this.map = isThreadSafe ? new ConcurrentHashMap<Pair<KeyOne, KeyTwo>, Value>(initialCapacity) : new HashMap<Pair<KeyOne, KeyTwo>, Value>(initialCapacity);
        this.singleKeyMap = new HashCollectionSet(isThreadSafe, HashSet::new);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.singleKeyMap.clear();
    }

    @Override
    public boolean containsKey(Object key1) {
        return this.singleKeyMap.containsKey(key1);
    }

    public boolean containsKey(KeyOne key1, KeyTwo key2) {
        return this.map.containsKey(this.threadLocalKey.get().set(key1, key2));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Pair<KeyOne, KeyTwo>, Value>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Value get(Object key) {
        List<Value> values = this.getValues(key);
        if (!values.isEmpty()) {
            return values.iterator().next();
        }
        return null;
    }

    public Map<KeyTwo, Value> getKeyedValues(KeyOne key1) {
        int size = this.singleKeyMap.sizeByKey((Object)key1);
        if (size == 0) {
            return Collections.emptyMap();
        }
        HashMap values = new HashMap(size);
        this.singleKeyMap.forEachValue((Object)key1, key2 -> {
            Value Value = values.put(key2, this.get(key1, key2));
        });
        return values;
    }

    public List<Value> getValues(KeyOne key1) {
        int size = this.singleKeyMap.sizeByKey((Object)key1);
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList values = new ArrayList(size);
        this.singleKeyMap.forEachValue((Object)key1, key2 -> {
            boolean bl = values.add(this.get(key1, key2));
        });
        return values;
    }

    public Value get(KeyOne key1, KeyTwo key2) {
        return this.map.get(this.threadLocalKey.get().set(key1, key2));
    }

    public List<Pair<KeyOne, KeyTwo>> getEnumeratedKeys() {
        ArrayList toReturn = new ArrayList();
        for (Object firstKey : this.singleKeyMap.keySet()) {
            this.singleKeyMap.forEachValue(firstKey, secondKey -> {
                boolean bl = toReturn.add(new Pair<Object, Object>(firstKey, secondKey));
            });
        }
        return toReturn;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<Pair<KeyOne, KeyTwo>> keySet() {
        return this.map.keySet();
    }

    @Override
    public Value put(Pair<KeyOne, KeyTwo> key, Value value) {
        this.putKeys(key.getFirst(), key.getSecond());
        return this.map.put(key, value);
    }

    public Value put(KeyOne key1, KeyTwo key2, Value value) {
        this.putKeys(key1, key2);
        return this.map.put(new Pair<KeyOne, KeyTwo>(key1, key2), value);
    }

    @Override
    public void putAll(Map<? extends Pair<KeyOne, KeyTwo>, ? extends Value> copyMap) {
        this.map.putAll(copyMap);
        for (Pair<KeyOne, KeyTwo> key : copyMap.keySet()) {
            this.putKeys(key.getFirst(), key.getSecond());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putKeys(KeyOne key1, KeyTwo key2) {
        if (this.singleKeyMap.isSynchronized()) {
            HashCollectionSet<KeyOne, KeyTwo> hashCollectionSet = this.singleKeyMap;
            synchronized (hashCollectionSet) {
                this.singleKeyMap.put((Object)key1, (Object)key2);
            }
        } else {
            this.singleKeyMap.put((Object)key1, (Object)key2);
        }
    }

    @Override
    public Value remove(Object key) {
        Collection<Value> values = this.removeValues(key);
        if (values != null && !values.isEmpty()) {
            return values.iterator().next();
        }
        return null;
    }

    public Collection<Value> removeValues(KeyOne key1) {
        int size = this.singleKeyMap.sizeByKey((Object)key1);
        if (size == 0) {
            return null;
        }
        ArrayList values = new ArrayList(size);
        this.singleKeyMap.forEachValue((Object)key1, key2 -> {
            boolean bl = values.add(this.map.remove(this.threadLocalKey.get().set(key1, key2)));
        });
        this.singleKeyMap.removeValues((Object)key1);
        return values;
    }

    public Value removeAndGet(KeyOne key1, KeyTwo key2) {
        Value value = this.map.remove(this.threadLocalKey.get().set(key1, key2));
        this.singleKeyMap.removeValue((Object)key1, (Object)key2);
        return value;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Value> values() {
        return this.map.values();
    }
}

