/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.Objects;
import org.eclipse.osee.framework.jdk.core.type.StringRange;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class CharSequenceWindow
implements CharSequence,
ToMessage {
    private final CharSequence charSequence;
    private final StringRange stringRange;

    public CharSequenceWindow(CharSequence charSequence, int start) {
        this.charSequence = Objects.requireNonNull(charSequence, "CharSequenceWindow::new, parameter \"charSequence\" cannot be null.");
        try {
            StringRange checkStringRange = new StringRange(0, charSequence.length());
            this.stringRange = new StringRange(start, charSequence.length(), StringRange.NONNEGATIVE_ENDPOINTS);
            checkStringRange.requireInRange(this.stringRange);
        }
        catch (IndexOutOfBoundsException ioobe) {
            IndexOutOfBoundsException exception = new IndexOutOfBoundsException(new Message().title("CharSequenceWindow::new, window range out of bounds.").indentInc().segment((CharSequence)"CharSequence", charSequence).segment((CharSequence)"Start", start).segment((CharSequence)"End", charSequence.length()).toString());
            exception.initCause(ioobe);
            throw exception;
        }
    }

    public CharSequenceWindow(CharSequence charSequence, int start, int end) {
        this.charSequence = Objects.requireNonNull(charSequence, "CharSequenceWindow::new, parameter \"charSequence\" cannot be null.");
        try {
            StringRange checkStringRange = new StringRange(0, charSequence.length());
            this.stringRange = new StringRange(start, end, StringRange.NONNEGATIVE_ENDPOINTS);
            checkStringRange.requireInRange(this.stringRange);
        }
        catch (IndexOutOfBoundsException ioobe) {
            IndexOutOfBoundsException exception = new IndexOutOfBoundsException(new Message().title("CharSequenceWindow::new, window range out of bounds.").indentInc().segment((CharSequence)"CharSequence", charSequence).segment((CharSequence)"Start", start).segment((CharSequence)"End", end).toString());
            exception.initCause(ioobe);
            throw exception;
        }
    }

    private CharSequenceWindow(CharSequence charSequence, StringRange stringRange) {
        this.charSequence = charSequence;
        this.stringRange = stringRange;
    }

    @Override
    public int length() {
        return this.stringRange.absLength();
    }

    @Override
    public char charAt(int index) {
        int baseIndex = this.stringRange.baseIndex(index);
        return this.charSequence.charAt(baseIndex);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        StringRange offsetStringRange;
        try {
            offsetStringRange = this.stringRange.subRange(start, end, StringRange.NONNEGATIVE_ENDPOINTS);
        }
        catch (IndexOutOfBoundsException ioobe) {
            IndexOutOfBoundsException exception = new IndexOutOfBoundsException(new Message().title("CharSequenceWindow:subSequence, specified window range is invalid.").indentInc().segment((CharSequence)"CharSequenceWindow", this).segment((CharSequence)"Start", start).segment((CharSequence)"End", end).toString());
            exception.initCause(ioobe);
            throw exception;
        }
        this.stringRange.requireInRange(offsetStringRange, () -> new Message().title("CharSequenceWindow::subSequence, specified window range is out of this CharSequenceWindow's range.").indentInc().segment((CharSequence)"CharSequenceWindow", this).segment((CharSequence)"Start", start).segment((CharSequence)"End", end).toString());
        return new CharSequenceWindow(this.charSequence, offsetStringRange);
    }

    @Override
    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title("CharSequenceWindow").indentInc().segment((CharSequence)"CharSequence", this.charSequence).segment((CharSequence)"StringRange", this.stringRange).indentDec();
        return outMessage;
    }

    @Override
    public String toString() {
        if (this.stringRange.isPositive()) {
            return this.charSequence.subSequence(this.stringRange.start(), this.stringRange.end()).toString();
        }
        char[] charArray = new char[this.stringRange.absLength()];
        int i = this.stringRange.start() - 1;
        int e = this.stringRange.end();
        int j = 0;
        while (i >= e) {
            charArray[j] = this.charSequence.charAt(i);
            --i;
            ++j;
        }
        return new String(charArray);
    }
}

