/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api.publishing.templatemanager;

import java.util.Objects;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class PublishingTemplateRequest
implements ToMessage {
    private Boolean byOptions;
    private String option;
    private String presentationType;
    private String publishArtifactTypeName;
    private String rendererId;
    private String templateId;

    public PublishingTemplateRequest() {
        this.byOptions = null;
        this.option = null;
        this.presentationType = null;
        this.publishArtifactTypeName = null;
        this.rendererId = null;
    }

    public PublishingTemplateRequest(String rendererId, String publishArtifactTypeName, String presentationType, String option) {
        this.byOptions = true;
        this.templateId = null;
        this.rendererId = Objects.requireNonNull(rendererId, "PublishingTemplateRequest::new, parameter \"rendererId\" cannot be null.");
        this.publishArtifactTypeName = Objects.requireNonNull(publishArtifactTypeName, "PublishingTemplateRequest::new, parameter \"publishArtifactTypeName\" cannot be null.");
        this.presentationType = Objects.requireNonNull(presentationType, "PublishingTemplateRequest::new, parameter \"presentationType\" cannot be null.");
        this.option = option;
    }

    public PublishingTemplateRequest(String templateId) {
        this.byOptions = false;
        this.option = null;
        this.presentationType = null;
        this.publishArtifactTypeName = null;
        this.rendererId = null;
        this.templateId = Objects.requireNonNull(templateId, "PublishingTemplateRequest::new, parameter \"templateId\" cannot be null.");
    }

    public String getOption() {
        return this.option;
    }

    public String getPresentationType() {
        if (Objects.isNull(this.byOptions)) {
            throw new IllegalStateException("PublishingTemplateRequest::getTemplateId, the member \"byOptions\" has not been set.");
        }
        if (Objects.isNull(this.presentationType) && this.byOptions.booleanValue()) {
            throw new IllegalStateException("PublishingTemplateRequest::getPresentationType, the member \"presentationType\" has not been set.");
        }
        return this.presentationType;
    }

    public String getPublishArtifactTypeName() {
        if (Objects.isNull(this.byOptions)) {
            throw new IllegalStateException("PublishingTemplateRequest::getTemplateId, the member \"byOptions\" has not been set.");
        }
        if (Objects.isNull(this.publishArtifactTypeName) && this.byOptions.booleanValue()) {
            throw new IllegalStateException("PublishingTemplateRequest::getPublishArtifactTypeName, the member \"publishArtifactTypeName\" has not been set.");
        }
        return this.publishArtifactTypeName;
    }

    public String getRendererId() {
        if (Objects.isNull(this.byOptions)) {
            throw new IllegalStateException("PublishingTemplateRequest::getTemplateId, the member \"byOptions\" has not been set.");
        }
        if (Objects.isNull(this.rendererId) && this.byOptions.booleanValue()) {
            throw new IllegalStateException("PublishingTemplateRequest::getRendererId, the member \"rendererId\" has not been set.");
        }
        return this.rendererId;
    }

    public String getTemplateId() {
        if (Objects.isNull(this.byOptions)) {
            throw new IllegalStateException("PublishingTemplateRequest::getTemplateId, the member \"byOptions\" has not been set.");
        }
        if (Objects.isNull(this.templateId) && !this.byOptions.booleanValue()) {
            throw new IllegalStateException("PublishingTemplateRequest::getTemplateId, the member \"templateId\" has not been set.");
        }
        return this.templateId;
    }

    public boolean isByOptions() {
        if (Objects.isNull(this.byOptions)) {
            throw new IllegalStateException("PublishingTemplateRequest::isByOptions, the member \"byOptions\" has not been set.");
        }
        return this.byOptions;
    }

    public boolean isValid() {
        if (Objects.isNull(this.byOptions)) {
            return false;
        }
        if (this.byOptions.booleanValue()) {
            return Objects.nonNull(this.presentationType) && !this.presentationType.isBlank() && Objects.nonNull(this.publishArtifactTypeName) && Objects.nonNull(this.rendererId) && !this.rendererId.isBlank() && Objects.isNull(this.templateId);
        }
        return Objects.isNull(this.option) && Objects.isNull(this.presentationType) && Objects.isNull(this.publishArtifactTypeName) && Objects.isNull(this.rendererId) && Objects.nonNull(this.templateId);
    }

    public void setByOption(Boolean byOptions) {
        if (Objects.nonNull(this.byOptions)) {
            throw new IllegalStateException("PublishingTemplateRequest::setByOptions, member \"byOptions\" has already been set.");
        }
        this.byOptions = Objects.requireNonNull(byOptions, "PublishingTemplateRequset::setByOptions, parameter \"byOptions\" cannot be null.");
    }

    public void setOption(String option) {
        if (Objects.nonNull(this.option)) {
            throw new IllegalStateException("PublishingTemplateRequest::setOption, member \"option\" has already been set.");
        }
        this.option = option;
    }

    public void setPresentationType(String presentationType) {
        if (Objects.nonNull(this.presentationType)) {
            throw new IllegalStateException("PublishingTemplateRequest::setPresentationType, member \"presentationType\" has already been set.");
        }
        this.presentationType = presentationType;
    }

    public void setPublishArtifactTypeName(String publishArtifactTypeName) {
        if (Objects.nonNull(this.publishArtifactTypeName)) {
            throw new IllegalStateException("PublishingTemplateRequest::setPublishArtifactTypeName, member \"publishArtifactTypeName\" has already been set.");
        }
        this.publishArtifactTypeName = publishArtifactTypeName;
    }

    public void setRendererId(String rendererId) {
        if (Objects.nonNull(this.rendererId)) {
            throw new IllegalStateException("PublishingTemplateRequest::setRendererId, member \"rendererId\" has already been set.");
        }
        this.rendererId = rendererId;
    }

    public void setTemplateId(String templateId) {
        if (Objects.nonNull(this.templateId)) {
            throw new IllegalStateException("PublishingTemplateRequest::setTemplateId, member \"templateId\" has already been set.");
        }
        this.templateId = templateId;
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Publishing Template Request:").indentInc();
        if (Objects.isNull(this.byOptions)) {
            return outMessage.title((CharSequence)"IllegalState, member \"byOptions\" is null.").indentDec();
        }
        if (this.byOptions.booleanValue()) {
            return outMessage.title((CharSequence)"Publishing Template Requset is by options.").indentInc().segment((CharSequence)"Option", (Object)this.option).segment((CharSequence)"Presentation Type", (Object)this.presentationType).segment((CharSequence)"Publish Artifact Type Name", (Object)this.publishArtifactTypeName).segment((CharSequence)"Renderer Identifier", (Object)this.rendererId).indentDec().indentDec();
        }
        return outMessage.title((CharSequence)"Publishing Template Request is by template identifier.").indentInc().segment((CharSequence)"Template Identifier", (Object)this.templateId).indentDec().indentDec();
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

