/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.internal.activemq;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.messaging.ConnectionListener;
import org.eclipse.osee.framework.messaging.ConnectionNodeFailoverSupport;
import org.eclipse.osee.framework.messaging.MessageID;
import org.eclipse.osee.framework.messaging.NodeInfo;
import org.eclipse.osee.framework.messaging.OseeMessagingListener;
import org.eclipse.osee.framework.messaging.OseeMessagingStatusCallback;
import org.eclipse.osee.framework.messaging.internal.Activator;
import org.eclipse.osee.framework.messaging.internal.ConsoleDebugSupport;
import org.eclipse.osee.framework.messaging.internal.ServiceUtility;
import org.eclipse.osee.framework.messaging.internal.activemq.ActiveMqMessageListenerWrapper;
import org.eclipse.osee.framework.messaging.internal.activemq.ActiveMqUtil;
import org.eclipse.osee.framework.messaging.internal.activemq.ReplyConnectionActiveMqImpl;
import org.eclipse.osee.framework.messaging.services.internal.OseeMessagingStatusImpl;

class ConnectionNodeActiveMq
implements ConnectionNodeFailoverSupport,
MessageListener {
    private final NodeInfo nodeInfo;
    private Connection connection;
    private Session session;
    private TemporaryTopic temporaryTopic;
    private MessageConsumer replyToConsumer;
    private final Map<String, OseeMessagingListener> replyListeners;
    private final CompositeKeyHashMap<String, MessageConsumer, OseeMessagingListener> regularListeners;
    private boolean started = false;
    private final ConcurrentHashMap<String, Topic> topicCache;
    private final ConcurrentHashMap<Topic, MessageProducer> messageProducerCache;
    private final ExceptionListener exceptionListener;
    private MessageProducer replyProducer;
    private final ActiveMqUtil activeMqUtil;

    public ConnectionNodeActiveMq(String version, String sourceId, NodeInfo nodeInfo, ExecutorService executor, ExceptionListener exceptionListener) {
        this.nodeInfo = nodeInfo;
        this.exceptionListener = exceptionListener;
        this.activeMqUtil = new ActiveMqUtil();
        this.topicCache = new ConcurrentHashMap();
        this.messageProducerCache = new ConcurrentHashMap();
        this.regularListeners = new CompositeKeyHashMap(64, true);
        this.replyListeners = new ConcurrentHashMap<String, OseeMessagingListener>();
    }

    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        try {
            String uri = this.nodeInfo.getUri().toASCIIString();
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(ActiveMQConnectionFactory.DEFAULT_USER, ActiveMQConnectionFactory.DEFAULT_PASSWORD, uri);
            this.connection = factory.createConnection();
            this.connection.setExceptionListener(this.exceptionListener);
            this.session = this.connection.createSession(false, 2);
            this.temporaryTopic = this.session.createTemporaryTopic();
            this.replyToConsumer = this.session.createConsumer((Destination)this.temporaryTopic);
            this.replyToConsumer.setMessageListener((MessageListener)this);
            this.replyProducer = this.session.createProducer(null);
            this.connection.start();
            this.started = true;
        }
        catch (Throwable ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    @Override
    public void send(MessageID topic, Object body) {
        String errorMessage = String.format("Error sending message(%s)", topic.getId());
        OseeMessagingStatusImpl defaultErrorHandler = new OseeMessagingStatusImpl(errorMessage, this.getClass());
        this.send(topic, body, defaultErrorHandler);
    }

    @Override
    public synchronized void send(MessageID messageId, Object message, OseeMessagingStatusCallback statusCallback) {
        this.send(messageId, message, null, statusCallback);
    }

    @Override
    public synchronized void send(MessageID messageId, Object message, Properties properties, OseeMessagingStatusCallback statusCallback) {
        try {
            if (messageId.isTopic()) {
                try {
                    this.sendInternal(messageId, message, properties);
                    statusCallback.success();
                }
                catch (JMSException jMSException) {
                    this.removeProducerFromCache(messageId);
                    this.sendInternal(messageId, message, properties);
                    statusCallback.success();
                }
            }
        }
        catch (Exception ex) {
            statusCallback.fail(ex);
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    private synchronized void sendInternal(MessageID messageId, Object message, Properties properties) throws JMSException {
        ConsoleDebugSupport support = null;
        try {
            support = ServiceUtility.getConsoleDebugSupport();
        }
        catch (NullPointerException nullPointerException) {
            System.out.print("getBundle() is null");
        }
        if (support != null) {
            if (support.getPrintSends()) {
                StackTraceElement[] stack;
                System.out.println("+++++++++++++++++++++++++++++++++++++++++++++++");
                System.out.println(String.valueOf(messageId.getName()) + " ==> " + new Date());
                if (properties != null) {
                    System.out.println("PROPERTIES:");
                    System.out.println(properties.toString());
                }
                System.out.println("MESSAGE:");
                System.out.println(message.toString());
                System.out.println("STACK:");
                StackTraceElement[] stackTraceElementArray = stack = Thread.currentThread().getStackTrace();
                int n = stack.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement el = stackTraceElementArray[n2];
                    System.out.println("   " + el.toString());
                    ++n2;
                }
                System.out.println("-----------------------------------------------------------------------------");
            }
            support.addSend(messageId);
        }
        Topic destination = this.getOrCreateTopic(messageId);
        MessageProducer producer = this.getOrCreateProducer(destination);
        Message msg = this.activeMqUtil.createMessage(this.session, messageId.getSerializationClass(), message);
        if (messageId.isReplyRequired()) {
            msg.setJMSReplyTo((Destination)this.temporaryTopic);
        }
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (entry.getValue() instanceof Integer) {
                    msg.setIntProperty(entry.getKey().toString(), ((Integer)entry.getValue()).intValue());
                }
                if (entry.getValue() instanceof Boolean) {
                    msg.setBooleanProperty(entry.getKey().toString(), ((Boolean)entry.getValue()).booleanValue());
                }
                if (entry.getValue() instanceof Byte) {
                    msg.setByteProperty(entry.getKey().toString(), ((Byte)entry.getValue()).byteValue());
                }
                if (entry.getValue() instanceof Double) {
                    msg.setDoubleProperty(entry.getKey().toString(), ((Double)entry.getValue()).doubleValue());
                }
                if (entry.getValue() instanceof Float) {
                    msg.setFloatProperty(entry.getKey().toString(), ((Float)entry.getValue()).floatValue());
                }
                if (entry.getValue() instanceof Long) {
                    msg.setLongProperty(entry.getKey().toString(), ((Long)entry.getValue()).longValue());
                }
                if (entry.getValue() instanceof String) {
                    msg.setStringProperty(entry.getKey().toString(), (String)entry.getValue());
                }
                if (entry.getValue() instanceof Short) {
                    msg.setShortProperty(entry.getKey().toString(), ((Short)entry.getValue()).shortValue());
                    continue;
                }
                msg.setObjectProperty(entry.getKey().toString(), entry.getValue());
            }
        }
        producer.send(msg);
    }

    @Override
    public synchronized void subscribe(MessageID messageId, OseeMessagingListener listener, OseeMessagingStatusCallback statusCallback) {
        try {
            if (this.isConnectedThrow()) {
                Topic destination = this.getOrCreateTopic(messageId);
                MessageConsumer consumer = this.session.createConsumer((Destination)destination);
                consumer.setMessageListener((MessageListener)new ActiveMqMessageListenerWrapper(this.activeMqUtil, this.replyProducer, this.session, listener));
                this.regularListeners.put((Object)messageId.getId(), (Object)consumer, (Object)listener);
                statusCallback.success();
            } else {
                statusCallback.fail(new OseeCoreException("This connection is not started.", new Object[0]));
            }
        }
        catch (JMSException ex) {
            statusCallback.fail(ex);
        }
        catch (NullPointerException ex) {
            statusCallback.fail(ex);
        }
    }

    @Override
    public void subscribe(MessageID messageId, OseeMessagingListener listener, String selector, OseeMessagingStatusCallback statusCallback) {
        try {
            if (this.isConnectedThrow()) {
                Topic destination = this.getOrCreateTopic(messageId);
                MessageConsumer consumer = this.session.createConsumer((Destination)destination, selector);
                consumer.setMessageListener((MessageListener)new ActiveMqMessageListenerWrapper(this.activeMqUtil, this.replyProducer, this.session, listener));
                this.regularListeners.put((Object)messageId.getId(), (Object)consumer, (Object)listener);
                statusCallback.success();
            } else {
                statusCallback.fail(new OseeCoreException("This connection is not started.", new Object[0]));
            }
        }
        catch (JMSException ex) {
            statusCallback.fail(ex);
        }
        catch (NullPointerException ex) {
            statusCallback.fail(ex);
        }
    }

    @Override
    public void subscribe(MessageID messageId, OseeMessagingListener listener) {
        String errorMessage = String.format("Error subscribing message(%s)", messageId.getId());
        OseeMessagingStatusImpl defaultErrorHandler = new OseeMessagingStatusImpl(errorMessage, this.getClass());
        this.subscribe(messageId, listener, defaultErrorHandler);
    }

    private Topic getOrCreateTopic(MessageID messageId) throws JMSException {
        Topic topic = this.topicCache.get(messageId.getId());
        if (topic == null) {
            topic = this.session.createTopic(messageId.getId());
            this.topicCache.put(messageId.getId(), topic);
        }
        return topic;
    }

    private MessageProducer getOrCreateProducer(Topic destination) throws JMSException {
        MessageProducer producer = this.messageProducerCache.get(destination);
        if (producer == null) {
            producer = this.session.createProducer((Destination)destination);
            producer.setDeliveryMode(1);
            this.messageProducerCache.put(destination, producer);
        }
        return producer;
    }

    private void removeProducerFromCache(MessageID topic) throws JMSException {
        Topic destination = this.getOrCreateTopic(topic);
        this.messageProducerCache.remove(destination);
    }

    @Override
    public boolean subscribeToReply(MessageID messageId, OseeMessagingListener listener) {
        this.replyListeners.put(messageId.getId(), listener);
        return true;
    }

    @Override
    public void unsubscribe(MessageID messageId, OseeMessagingListener listener) {
        String errorMessage = String.format("Error unsubscribing message(%s)", messageId.getId());
        OseeMessagingStatusImpl defaultErrorHandler = new OseeMessagingStatusImpl(errorMessage, this.getClass());
        this.unsubscribe(messageId, listener, defaultErrorHandler);
    }

    @Override
    public void unsubscribe(MessageID messageId, OseeMessagingListener listener, OseeMessagingStatusCallback statusCallback) {
        Map listeners = this.regularListeners.getKeyedValues((Object)messageId.getId());
        ArrayList<MessageConsumer> consumersToRemove = new ArrayList<MessageConsumer>();
        if (listeners != null) {
            try {
                for (Map.Entry entry : listeners.entrySet()) {
                    if (!((OseeMessagingListener)entry.getValue()).equals(listener)) continue;
                    consumersToRemove.add((MessageConsumer)entry.getKey());
                }
                for (MessageConsumer messageConsumer : consumersToRemove) {
                    listeners.remove(messageConsumer);
                    messageConsumer.close();
                }
            }
            catch (JMSException ex) {
                statusCallback.fail(ex);
            }
        }
        statusCallback.success();
    }

    @Override
    public boolean unsubscribteToReply(MessageID messageId, OseeMessagingListener listener) {
        this.replyListeners.remove(messageId.getId());
        return true;
    }

    public void onMessage(Message jmsMessage) {
        try {
            OseeMessagingListener listener;
            String correlationId = jmsMessage.getJMSCorrelationID();
            if (correlationId != null && (listener = this.replyListeners.get(correlationId)) != null) {
                listener.process(this.activeMqUtil.translateMessage(jmsMessage, listener.getClazz()), new HashMap<String, Object>(), new ReplyConnectionActiveMqImpl());
            }
        }
        catch (JMSException ex) {
            OseeLog.log(ConnectionNodeActiveMq.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(ConnectionNodeActiveMq.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        OseeLog.logf(Activator.class, (Level)Level.FINE, (String)"recieved reply message %s", (Object[])new Object[]{jmsMessage});
    }

    @Override
    public synchronized void stop() {
        this.topicCache.clear();
        this.messageProducerCache.clear();
        this.regularListeners.clear();
        this.started = false;
        try {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
        }
        catch (JMSException ex) {
            OseeLog.log(ConnectionNodeActiveMq.class, (Level)Level.FINEST, (Throwable)ex);
        }
        try {
            if (this.connection != null) {
                this.connection.setExceptionListener(null);
                this.connection.close();
                this.connection = null;
            }
        }
        catch (JMSException ex) {
            OseeLog.log(ConnectionNodeActiveMq.class, (Level)Level.FINEST, (Throwable)ex);
        }
    }

    @Override
    public synchronized boolean isConnected() {
        try {
            return this.isConnectedThrow();
        }
        catch (JMSException jMSException) {
            this.started = false;
            return false;
        }
    }

    private synchronized boolean isConnectedThrow() throws JMSException {
        if (this.connection == null || !this.started) {
            return false;
        }
        this.connection.getMetaData();
        return true;
    }

    @Override
    public void addConnectionListener(ConnectionListener connectionListener) {
    }

    @Override
    public void removeConnectionListener(ConnectionListener connectionListener) {
    }

    @Override
    public String getSenders() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Topic, MessageProducer> entry : this.messageProducerCache.entrySet()) {
            try {
                sb.append(String.format("Topic [%s] \n", entry.getKey().getTopicName()));
                sb.append(String.format("\tProducer Destination [%s]\n", entry.getValue().getDestination().toString()));
            }
            catch (JMSException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return sb.toString();
    }

    @Override
    public String getSubscribers() {
        StringBuilder sb = new StringBuilder();
        for (Pair entry : this.regularListeners.keySet()) {
            try {
                sb.append(String.format("Topic [%s] \n", entry.getFirst()));
                sb.append(String.format("\tConsumer Selector [%s]\n", ((MessageConsumer)entry.getSecond()).getMessageSelector()));
                MessageListener listener = ((MessageConsumer)entry.getSecond()).getMessageListener();
                if (!(listener instanceof ActiveMqMessageListenerWrapper)) continue;
                sb.append("\tConsumer Listeners:\n");
                sb.append(String.format("\t\t%s\n", ((ActiveMqMessageListenerWrapper)listener).getListener().toString()));
            }
            catch (JMSException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return sb.toString();
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nodeInfo.toString());
        sb.append("\n");
        sb.append(String.format("\tisStarted[%b]\n", this.started));
        sb.append(this.getSenders());
        sb.append(this.getSubscribers());
        return sb.toString();
    }
}

