/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.users;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.cache.admin.Cache;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.LazyObject;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.filter.ArtifactTypeEventFilter;
import org.eclipse.osee.framework.skynet.core.event.filter.BranchIdEventFilter;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactTopicEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ArtifactTopicTypeEventFilter;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.BranchIdTopicEventFilter;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ITopicEventFilter;

public class UserArtifactEventListener
implements IArtifactEventListener,
IArtifactTopicEventListener {
    private final List<? extends IEventFilter> eventFilters = Arrays.asList(new ArtifactTypeEventFilter(CoreArtifactTypes.User), new BranchIdEventFilter((BranchId)CoreBranches.COMMON));
    private final List<? extends ITopicEventFilter> topicEventFilters = Arrays.asList(new ArtifactTopicTypeEventFilter(CoreArtifactTypes.User), new BranchIdTopicEventFilter((BranchId)CoreBranches.COMMON));
    private final LazyObject<Cache<String, User>> cacheProvider;
    private final LazyObject<Iterable<? extends String>> keysProvider;

    public UserArtifactEventListener(LazyObject<Cache<String, User>> cacheProvider, LazyObject<Iterable<? extends String>> keysProvider) {
        this.cacheProvider = cacheProvider;
        this.keysProvider = keysProvider;
    }

    @Override
    public List<? extends IEventFilter> getEventFilters() {
        return this.eventFilters;
    }

    @Override
    public List<? extends ITopicEventFilter> getTopicEventFilters() {
        return this.topicEventFilters;
    }

    @Override
    public void handleArtifactEvent(ArtifactEvent artifactEvent, Sender sender) {
        Set<String> keys;
        Collection<Artifact> cacheArtifacts;
        if (this.areUsers(artifactEvent, EventModType.Added, EventModType.Purged, EventModType.Deleted)) {
            this.keysProvider.invalidate();
        }
        if (!(cacheArtifacts = artifactEvent.getCacheArtifacts(EventModType.Purged, EventModType.Deleted)).isEmpty() && !(keys = this.getKeysToInvalidate(cacheArtifacts)).isEmpty()) {
            try {
                ((Cache)this.cacheProvider.get()).invalidate(keys);
            }
            catch (OseeCoreException ex) {
                OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Error updating users", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void handleArtifactTopicEvent(ArtifactTopicEvent artifactTopicEvent, Sender sender) {
        Set<String> keys;
        Collection<Artifact> cacheArtifacts;
        if (this.areUsers(artifactTopicEvent, EventModType.Added, EventModType.Purged, EventModType.Deleted)) {
            this.keysProvider.invalidate();
        }
        if (!(cacheArtifacts = artifactTopicEvent.getCacheArtifacts(EventModType.Purged, EventModType.Deleted)).isEmpty() && !(keys = this.getKeysToInvalidate(cacheArtifacts)).isEmpty()) {
            try {
                ((Cache)this.cacheProvider.get()).invalidate(keys);
            }
            catch (OseeCoreException ex) {
                OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Error updating users", (Object[])new Object[0]);
            }
        }
    }

    private boolean areUsers(ArtifactEvent artifactEvent, EventModType ... eventType) {
        for (EventBasicGuidArtifact artifact : artifactEvent.get(eventType)) {
            if (!artifact.isTypeEqual(CoreArtifactTypes.User)) continue;
            return true;
        }
        return false;
    }

    private boolean areUsers(ArtifactTopicEvent artifactTopicEvent, EventModType ... eventType) {
        for (EventBasicGuidArtifact artifact : artifactTopicEvent.get(eventType)) {
            if (!artifact.isTypeEqual(CoreArtifactTypes.User)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getKeysToInvalidate(Collection<Artifact> cacheArtifacts) {
        HashSet<String> keys = new HashSet<String>();
        for (Artifact artifact : cacheArtifacts) {
            if (!(artifact instanceof User)) continue;
            User user = (User)artifact;
            try {
                keys.add(user.getUserId());
            }
            catch (OseeCoreException ex) {
                OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Error updating user [%s]", (Object[])new Object[]{user});
            }
        }
        return keys;
    }
}

