/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.httpRequests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.TransactionResult;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.EventTopicTransferType;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.core.model.event.DefaultBasicIdRelation;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.messaging.event.res.AttributeEventModificationType;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.change.RelationChange;
import org.eclipse.osee.framework.skynet.core.event.FrameworkEventUtil;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.event.model.AttributeChange;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEvent;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEventType;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidRelation;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.event.model.EventModifiedBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicArtifactTransfer;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicAttributeChangeTransfer;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicRelationTransfer;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.relation.RelationEventType;
import org.eclipse.osee.framework.skynet.core.revision.ChangeManager;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.orcs.rest.model.BranchCommitOptions;
import org.eclipse.osee.orcs.rest.model.BranchEndpoint;

public final class CommitBranchHttpRequestOperation
extends AbstractOperation {
    private final ArtifactId committer;
    private final BranchId sourceBranch;
    private final BranchId destinationBranch;
    private final boolean isArchiveAllowed;
    private final boolean skipChecksAndEvents;
    private TransactionResult transactionResult;
    private static final boolean useNewEvents = FrameworkEventUtil.USE_NEW_EVENTS;

    public CommitBranchHttpRequestOperation(ArtifactId committer, BranchId sourceBranch, BranchId destinationBranch, boolean isArchiveAllowed, boolean skipChecksAndEvents) {
        super("Commit " + sourceBranch, "org.eclipse.osee.framework.skynet.core");
        this.committer = committer;
        this.sourceBranch = sourceBranch;
        this.destinationBranch = destinationBranch;
        this.isArchiveAllowed = isArchiveAllowed;
        this.skipChecksAndEvents = skipChecksAndEvents;
    }

    protected void doWork(IProgressMonitor monitor) {
        this.transactionResult = new TransactionResult();
        try {
            BranchEvent branchEvent = new BranchEvent(BranchEventType.Committing, this.sourceBranch, this.destinationBranch);
            OseeEventManager.kickBranchEvent(((Object)((Object)this)).getClass(), branchEvent);
            OseeClient client = ServiceUtil.getOseeClient();
            BranchEndpoint branchEp = client.getBranchEndpoint();
            BranchCommitOptions options = new BranchCommitOptions();
            options.setArchive(this.isArchiveAllowed);
            options.setCommitter(this.committer);
            this.transactionResult = branchEp.commitBranch(this.sourceBranch, this.destinationBranch, options);
            if (this.transactionResult.getResults().isErrors() || this.transactionResult.getTx().isInvalid()) {
                OseeEventManager.kickBranchEvent(((Object)((Object)this)).getClass(), new BranchEvent(BranchEventType.CommitFailed, this.sourceBranch));
            } else {
                this.handleResponse(this.transactionResult.getTx(), monitor, this.sourceBranch, this.destinationBranch);
            }
        }
        catch (Exception ex) {
            OseeEventManager.kickBranchEvent(((Object)((Object)this)).getClass(), new BranchEvent(BranchEventType.CommitFailed, this.sourceBranch));
            this.transactionResult.getResults().errorf("Exception CommitBranchHttpRequestOperation [%s]", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
    }

    private void handleResponse(TransactionToken newTransaction, IProgressMonitor monitor, BranchId sourceBranch, BranchId destinationBranch) {
        ServiceUtil.getOseeClient().getAccessControlService().removePermissions(sourceBranch);
        Artifact associatedArtifact = BranchManager.getAssociatedArtifact(sourceBranch);
        if (associatedArtifact.isValid()) {
            TransactionManager.cacheCommittedArtifactTransaction((ArtifactId)associatedArtifact, newTransaction);
        }
        BranchManager.reloadBranch(sourceBranch);
        if (!this.skipChecksAndEvents) {
            ArrayList<Change> changes = new ArrayList<Change>();
            IOperation operation = ChangeManager.comparedToPreviousTx(newTransaction, changes);
            this.doSubWork(operation, monitor, 1.0);
            this.handleArtifactEvents(newTransaction, changes);
        }
        OseeEventManager.kickBranchEvent(((Object)((Object)this)).getClass(), new BranchEvent(BranchEventType.Committed, sourceBranch, destinationBranch));
    }

    private void handleArtifactEvents(TransactionToken newTransaction, Collection<Change> changes) {
        if (useNewEvents) {
            ArtifactTopicEvent artifactTopicEvent = new ArtifactTopicEvent(newTransaction);
            HashMap artEventMap = new HashMap();
            HashSet<Artifact> artifacts = new HashSet<Artifact>();
            for (Change change : changes) {
                Artifact changedArtifact;
                ChangeType changeType = change.getChangeType();
                if (changeType.isArtifactChange()) continue;
                if (changeType.isRelationChange()) {
                    Artifact artB;
                    RelationChange relChange = (RelationChange)change;
                    RelationEventType relationEventType = change.getModificationType().isDeleted() ? RelationEventType.Deleted : (change.getModificationType().isUnDeleted() ? RelationEventType.Undeleted : RelationEventType.Added);
                    EventTopicRelationTransfer event = FrameworkEventUtil.relationTransferFactory(relationEventType, relChange.getChangeArtifact(), relChange.getEndTxBArtifact(), RelationId.valueOf((Long)relChange.getItemId().getId()), relChange.getRelationType().getId(), relChange.getGamma(), relChange.getRationale());
                    artifactTopicEvent.getRelations().add(event);
                    Artifact artA = ArtifactCache.getActive(relChange.getArtId(), newTransaction.getBranch());
                    if (artA != null) {
                        artifacts.add(artA);
                    }
                    if ((artB = ArtifactCache.getActive(relChange.getBArtId(), newTransaction.getBranch())) == null) continue;
                    artifacts.add(artB);
                    continue;
                }
                if (!changeType.isAttributeChange()) continue;
                ArtifactId artifactId = change.getArtId();
                Artifact artifact = ArtifactCache.getActive(artifactId, newTransaction.getBranch());
                if (artifact != null) {
                    artifacts.add(artifact);
                }
                if (!(changedArtifact = change.getChangeArtifact()).isValid()) continue;
                EventTopicArtifactTransfer artEvent = (EventTopicArtifactTransfer)artEventMap.get(artifactId);
                ArrayList<EventTopicAttributeChangeTransfer> changeAttrs = new ArrayList<EventTopicAttributeChangeTransfer>();
                if (artEvent == null) {
                    artEvent = FrameworkEventUtil.artifactTransferFactory(newTransaction.getBranch(), change.getChangeArtifact(), (ArtifactTypeId)changedArtifact.getArtifactType(), EventModType.Modified, null, changeAttrs, EventTopicTransferType.MODIFICATION);
                }
                org.eclipse.osee.framework.skynet.core.change.AttributeChange attributeChange = (org.eclipse.osee.framework.skynet.core.change.AttributeChange)change;
                EventTopicAttributeChangeTransfer attrChangeEvent = FrameworkEventUtil.attributeChangeTransferFactory((AttributeTypeId)attributeChange.getAttributeType(), attributeChange.getModificationType().getId(), attributeChange.getAttrId(), attributeChange.getGamma(), null, null);
                Attribute<?> attribute = changedArtifact.getAttributeById(attributeChange.getAttrId().getId(), true);
                if (attribute != null) {
                    attrChangeEvent.setData(Arrays.asList(attribute.getAttributeDataProvider().getData()));
                }
                artEvent.getAttributeChanges().add(attrChangeEvent);
                artifactTopicEvent.addArtifact(artEvent);
            }
            OseeEventManager.kickArtifactTopicEvent(((Object)((Object)this)).getClass(), artifactTopicEvent);
            ArtifactTopicEvent artifactTopicEvent2 = FrameworkEventUtil.getPersistTopicEvent(FrameworkEventUtil.getRemotePersistTopicEvent(artifactTopicEvent), ServiceUtil.getOrcsTokenService());
            OseeEventManager.kickCommitTopicEvent(((Object)((Object)this)).getClass(), artifactTopicEvent2);
        } else {
            ArtifactEvent artifactEvent = new ArtifactEvent(newTransaction);
            HashMap artEventMap = new HashMap();
            HashSet<Artifact> artifacts = new HashSet<Artifact>();
            for (Change change : changes) {
                Artifact changedArtifact;
                ChangeType changeType = change.getChangeType();
                if (changeType.isArtifactChange()) continue;
                if (changeType.isRelationChange()) {
                    Artifact artB;
                    RelationChange relChange = (RelationChange)change;
                    RelationEventType relationEventType = change.getModificationType().isDeleted() ? RelationEventType.Deleted : (change.getModificationType().isUnDeleted() ? RelationEventType.Undeleted : RelationEventType.Added);
                    DefaultBasicIdRelation defaultBasicGuidRelation = new DefaultBasicIdRelation((BranchId)relChange.getBranch(), relChange.getRelationType().getId(), relChange.getItemId().getId(), relChange.getGamma(), relChange.getChangeArtifact().getBasicGuidArtifact(), relChange.getEndTxBArtifact().getBasicGuidArtifact());
                    EventBasicGuidRelation event = new EventBasicGuidRelation(relationEventType, relChange.getArtId(), relChange.getBArtId(), defaultBasicGuidRelation);
                    event.setRationale(relChange.getRationale());
                    artifactEvent.getRelations().add(event);
                    Artifact artA = ArtifactCache.getActive(relChange.getArtId(), newTransaction.getBranch());
                    if (artA != null) {
                        artifacts.add(artA);
                    }
                    if ((artB = ArtifactCache.getActive(relChange.getArtId(), newTransaction.getBranch())) == null) continue;
                    artifacts.add(artB);
                    continue;
                }
                if (!changeType.isAttributeChange()) continue;
                ArtifactId artifactId = change.getArtId();
                Artifact artifact = ArtifactCache.getActive(artifactId, newTransaction.getBranch());
                if (artifact != null) {
                    artifacts.add(artifact);
                }
                if (!(changedArtifact = change.getChangeArtifact()).isValid()) continue;
                EventModifiedBasicGuidArtifact artEvent = (EventModifiedBasicGuidArtifact)((Object)artEventMap.get(artifactId.getIdIntValue()));
                if (artEvent == null) {
                    artEvent = new EventModifiedBasicGuidArtifact(newTransaction.getBranch(), change.getArtifactType(), changedArtifact.getGuid(), new ArrayList<AttributeChange>());
                    artifactEvent.addArtifact(artEvent);
                }
                org.eclipse.osee.framework.skynet.core.change.AttributeChange attributeChange = (org.eclipse.osee.framework.skynet.core.change.AttributeChange)change;
                AttributeChange attrChangeEvent = new AttributeChange();
                attrChangeEvent.setAttrTypeGuid(attributeChange.getAttributeType().getId());
                attrChangeEvent.setGammaId(attributeChange.getGamma());
                attrChangeEvent.setAttributeId(attributeChange.getAttrId().getIdIntValue());
                attrChangeEvent.setModTypeGuid(AttributeEventModificationType.getType((ModificationType)attributeChange.getModificationType()).getGuid());
                Attribute<?> attribute = changedArtifact.getAttributeById(attributeChange.getAttrId().getId(), true);
                if (attribute != null) {
                    Object[] objectArray = attribute.getAttributeDataProvider().getData();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj == null) {
                            attrChangeEvent.getData().add("");
                        } else {
                            attrChangeEvent.getData().add(obj);
                        }
                        ++n2;
                    }
                }
                artEvent.getAttributeChanges().add(attrChangeEvent);
            }
            OseeEventManager.kickPersistEvent(((Object)((Object)this)).getClass(), artifactEvent);
            ArtifactEvent artifactEvent2 = FrameworkEventUtil.getPersistEvent(FrameworkEventUtil.getRemotePersistEvent(artifactEvent), ServiceUtil.getOrcsTokenService());
            OseeEventManager.kickCommitEvent(((Object)((Object)this)).getClass(), artifactEvent2);
        }
    }

    public TransactionResult getTransactionResult() {
        return this.transactionResult;
    }

    public void setTransactionResult(TransactionResult transactionResult) {
        this.transactionResult = transactionResult;
    }
}

