/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.conflict.ConflictManagerExternal;

public class FinishUpdateBranchOperation
extends AbstractOperation {
    private final ConflictManagerExternal conflictManager;
    private final boolean archiveSourceBranch;
    private final boolean overwriteUnresolvedConflicts;

    public FinishUpdateBranchOperation(ConflictManagerExternal conflictManager, boolean archiveSourceBranch, boolean overwriteUnresolvedConflicts) {
        super(String.format("Complete Branch Update [%s]", conflictManager.getSourceBranch().getShortName()), "org.eclipse.osee.framework.skynet.core");
        this.conflictManager = conflictManager;
        this.archiveSourceBranch = archiveSourceBranch;
        this.overwriteUnresolvedConflicts = overwriteUnresolvedConflicts;
    }

    private String getUpdatedName(String branchName) {
        String storeName = Strings.truncate((String)branchName, (int)100);
        return String.format("%s - moved by update on - %s", storeName, Lib.getDateTimeString());
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        monitor.setTaskName("Merging updates");
        BranchManager.commitBranch(null, this.conflictManager, this.archiveSourceBranch, this.overwriteUnresolvedConflicts);
        monitor.worked(this.calculateWork(0.6));
        BranchToken sourceBranch = this.conflictManager.getSourceBranch();
        BranchToken destinationBranch = this.conflictManager.getDestinationBranch();
        String originalBranchName = sourceBranch.getName();
        BranchManager.setName((BranchId)sourceBranch, this.getUpdatedName(originalBranchName));
        monitor.worked(this.calculateWork(0.2));
        BranchManager.setName((BranchId)destinationBranch, originalBranchName);
        BranchManager.setAssociatedArtifactId((BranchId)destinationBranch, BranchManager.getAssociatedArtifactId((BranchId)sourceBranch));
        BranchManager.setState((BranchId)sourceBranch, BranchState.REBASELINED);
        monitor.worked(this.calculateWork(0.2));
    }
}

