/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;

public class ArtifactPersistenceManager {
    public static XResultData deleteArtifact(SkynetTransaction transaction, boolean overrideDeleteCheck, XResultData rd, Artifact ... artifacts) {
        return ArtifactPersistenceManager.deleteArtifactCollection(transaction, overrideDeleteCheck, rd, Arrays.asList(artifacts));
    }

    public static XResultData deleteArtifactCollection(SkynetTransaction transaction, boolean overrideDeleteCheck, XResultData rd, Collection<Artifact> artifacts) {
        if (rd == null) {
            rd = new XResultData();
        }
        if (artifacts.isEmpty()) {
            return rd;
        }
        ArtifactPersistenceManager.bulkLoadRelatives(artifacts);
        if (!overrideDeleteCheck) {
            ArtifactPersistenceManager.performDeleteChecks(artifacts, rd);
        }
        boolean reorderRelations = true;
        for (Artifact artifact : artifacts) {
            ArtifactPersistenceManager.deleteTrace(artifact, transaction, reorderRelations, rd);
        }
        return rd;
    }

    private static XResultData performDeleteChecks(Collection<Artifact> artifacts, XResultData rd) {
        return ServiceUtil.getOseeClient().getAccessControlService().isDeleteable(artifacts, rd);
    }

    public static XResultData performDeleteRelationChecks(Artifact artifact, RelationTypeToken relationType, XResultData rd) {
        return ServiceUtil.getOseeClient().getAccessControlService().isDeleteableRelation((ArtifactToken)artifact, relationType, rd);
    }

    private static void bulkLoadRelatives(Collection<Artifact> artifacts) {
        HashSet<ArtifactToken> relatives = new HashSet<ArtifactToken>();
        for (Artifact artifact : artifacts) {
            for (RelationLink link : artifact.getRelationsAll(DeletionFlag.EXCLUDE_DELETED)) {
                relatives.add(link.getArtifactIdA());
                relatives.add(link.getArtifactIdB());
            }
        }
        BranchToken branch = artifacts.iterator().next().getBranch();
        ArtifactQuery.getArtifactListFrom(relatives, (BranchId)branch);
    }

    private static XResultData deleteTrace(Artifact artifact, SkynetTransaction transaction, boolean reorderRelations, XResultData rd) {
        if (!artifact.isDeleted()) {
            for (Artifact childArtifact : artifact.getChildren()) {
                ArtifactPersistenceManager.deleteTrace(childArtifact, transaction, false, rd);
            }
            try {
                artifact.internalSetDeleted();
                RelationManager.deleteRelationsAll(artifact, reorderRelations, transaction, rd);
                if (transaction != null) {
                    artifact.persist(transaction);
                }
            }
            catch (OseeCoreException ex) {
                artifact.resetToPreviousModType();
                throw ex;
            }
        }
        return rd;
    }
}

